/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.BluetoothConnectionBase;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.LegoMindstormsNxtBase;
import java.util.ArrayList;
import java.util.List;

@DesignerComponent(version=1, description="A component that provides a high-level interface to a LEGO MINDSTORMS NXT robot, with functions that can move and turn the robot.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsNxt.png")
@SimpleObject
public class NxtDrive
extends LegoMindstormsNxtBase {
    private static final int MODE_MOTORON = 1;
    private static final int MODE_BRAKE = 2;
    private static final int MODE_REGULATED = 4;
    private static final int REGULATION_MODE_IDLE = 0;
    private static final int REGULATION_MODE_MOTOR_SPEED = 1;
    private static final int REGULATION_MODE_MOTOR_SYNC = 2;
    private static final int MOTOR_RUN_STATE_IDLE = 0;
    private static final int MOTOR_RUN_STATE_RAMPUP = 16;
    private static final int MOTOR_RUN_STATE_RUNNING = 32;
    private static final int MOTOR_RUN_STATE_RAMPDOWN = 64;
    private String driveMotors;
    private List<Integer> driveMotorPorts;
    private double wheelDiameter;
    private boolean stopBeforeDisconnect;

    public NxtDrive(ComponentContainer container) {
        super(container, "NxtDrive");
        this.DriveMotors("CB");
        this.WheelDiameter(4.32f);
        this.StopBeforeDisconnect(true);
    }

    public void beforeDisconnect(BluetoothConnectionBase bluetoothConnection) {
        if (this.stopBeforeDisconnect) {
            for (int port : this.driveMotorPorts) {
                this.setOutputState("Disconnect", port, 0, 2, 0, 0, 0, 0L);
            }
        }
    }

    @SimpleProperty(description="The motor ports that are used for driving: the left wheel's motor port followed by the right wheel's motor port.", category=PropertyCategory.BEHAVIOR, userVisible=false)
    public String DriveMotors() {
        return this.driveMotors;
    }

    @DesignerProperty(editorType="string", defaultValue="CB")
    @SimpleProperty
    public void DriveMotors(String motorPortLetters) {
        this.driveMotors = motorPortLetters;
        this.driveMotorPorts = new ArrayList<Integer>();
        for (int i = 0; i < motorPortLetters.length(); ++i) {
            char ch = motorPortLetters.charAt(i);
            try {
                this.driveMotorPorts.add(this.convertMotorPortLetterToNumber(ch));
                continue;
            }
            catch (IllegalArgumentException e) {
                this.form.dispatchErrorOccurredEvent(this, "DriveMotors", 407, Character.valueOf(ch));
            }
        }
    }

    @SimpleProperty(description="The diameter of the wheels used for driving.", category=PropertyCategory.BEHAVIOR, userVisible=false)
    public float WheelDiameter() {
        return (float)this.wheelDiameter;
    }

    @DesignerProperty(editorType="float", defaultValue="4.32")
    @SimpleProperty
    public void WheelDiameter(float wheelDiameter) {
        this.wheelDiameter = wheelDiameter;
    }

    @SimpleProperty(description="Whether to stop the drive motors before disconnecting.", category=PropertyCategory.BEHAVIOR)
    public boolean StopBeforeDisconnect() {
        return this.stopBeforeDisconnect;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void StopBeforeDisconnect(boolean stopBeforeDisconnect) {
        this.stopBeforeDisconnect = stopBeforeDisconnect;
    }

    @SimpleFunction(description="Move the robot forward indefinitely, with the specified percentage of maximum power, by powering both drive motors forward.")
    public void MoveForwardIndefinitely(int power) {
        this.move("MoveForwardIndefinitely", power, 0L);
    }

    @SimpleFunction(description="Move the robot backward indefinitely, with the specified percentage of maximum power, by powering both drive motors backward.")
    public void MoveBackwardIndefinitely(int power) {
        this.move("MoveBackwardIndefinitely", -power, 0L);
    }

    @SimpleFunction(description="Move the robot forward the given distance, with the specified percentage of maximum power, by powering both drive motors forward.")
    public void MoveForward(int power, double distance) {
        long tachoLimit = (long)(360.0 * distance / (this.wheelDiameter * Math.PI));
        this.move("MoveForward", power, tachoLimit);
    }

    @SimpleFunction(description="Move the robot backward the given distance, with the specified percentage of maximum power, by powering both drive motors backward.")
    public void MoveBackward(int power, double distance) {
        long tachoLimit = (long)(360.0 * distance / (this.wheelDiameter * Math.PI));
        this.move("MoveBackward", -power, tachoLimit);
    }

    private void move(String functionName, int power, long tachoLimit) {
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        for (int port : this.driveMotorPorts) {
            this.setOutputState(functionName, port, power, 1, 1, 0, 32, tachoLimit);
        }
    }

    @SimpleFunction(description="Turn the robot clockwise indefinitely, with the specified percentage of maximum power, by powering the left drive motor forward and the right drive motor backward.")
    public void TurnClockwiseIndefinitely(int power) {
        int numDriveMotors = this.driveMotorPorts.size();
        if (numDriveMotors >= 2) {
            int forwardMotorIndex = 0;
            int backwardMotorIndex = numDriveMotors - 1;
            this.turnIndefinitely("TurnClockwiseIndefinitely", power, forwardMotorIndex, backwardMotorIndex);
        }
    }

    @SimpleFunction(description="Turn the robot counterclockwise indefinitely, with the specified percentage of maximum power, by powering the right drive motor forward and the left drive motor backward.")
    public void TurnCounterClockwiseIndefinitely(int power) {
        int numDriveMotors = this.driveMotorPorts.size();
        if (numDriveMotors >= 2) {
            int forwardMotorIndex = numDriveMotors - 1;
            int backwardMotorIndex = 0;
            this.turnIndefinitely("TurnCounterClockwiseIndefinitely", power, forwardMotorIndex, backwardMotorIndex);
        }
    }

    private void turnIndefinitely(String functionName, int power, int forwardMotorIndex, int reverseMotorIndex) {
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        this.setOutputState(functionName, this.driveMotorPorts.get(forwardMotorIndex), power, 1, 1, 0, 32, 0L);
        this.setOutputState(functionName, this.driveMotorPorts.get(reverseMotorIndex), -power, 1, 1, 0, 32, 0L);
    }

    @SimpleFunction(description="Stop the drive motors of the robot.")
    public void Stop() {
        String functionName = "Stop";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        for (int port : this.driveMotorPorts) {
            this.setOutputState(functionName, port, 0, 2, 0, 0, 0, 0L);
        }
    }
}

