/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.LegoMindstormsNxtBase;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.YailList;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=1, description="A component that provides a low-level interface to a LEGO MINDSTORMS NXT robot, with functions to send NXT Direct Commands.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsNxt.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET,android.permission.WRITE_EXTERNAL_STORAGE,android.permission.READ_EXTERNAL_STORAGE")
public class NxtDirectCommands
extends LegoMindstormsNxtBase {
    public NxtDirectCommands(ComponentContainer container) {
        super(container, "NxtDirectCommands");
    }

    @SimpleFunction(description="Start execution of a previously downloaded program on the robot.")
    public void StartProgram(String programName) {
        String functionName = "StartProgram";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        if (programName.length() == 0) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 405, new Object[0]);
            return;
        }
        if (programName.indexOf(".") == -1) {
            programName = programName + ".rxe";
        }
        byte[] command = new byte[22];
        command[0] = -128;
        command[1] = 0;
        this.copyStringValueToBytes(programName, command, 2, 19);
        this.sendCommand(functionName, command);
    }

    @SimpleFunction(description="Stop execution of the currently running program on the robot.")
    public void StopProgram() {
        String functionName = "StopProgram";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        byte[] command = new byte[]{-128, 1};
        this.sendCommand(functionName, command);
    }

    @SimpleFunction(description="Play a sound file on the robot.")
    public void PlaySoundFile(String fileName) {
        String functionName = "PlaySoundFile";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        if (fileName.length() == 0) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 406, new Object[0]);
            return;
        }
        if (fileName.indexOf(".") == -1) {
            fileName = fileName + ".rso";
        }
        byte[] command = new byte[23];
        command[0] = -128;
        command[1] = 2;
        this.copyBooleanValueToBytes(false, command, 2);
        this.copyStringValueToBytes(fileName, command, 3, 19);
        this.sendCommand(functionName, command);
    }

    @SimpleFunction(description="Make the robot play a tone.")
    public void PlayTone(int frequencyHz, int durationMs) {
        String functionName = "PlayTone";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        if (frequencyHz < 200) {
            Log.w((String)this.logTag, (String)("frequencyHz " + frequencyHz + " is invalid, using 200."));
            frequencyHz = 200;
        }
        if (frequencyHz > 14000) {
            Log.w((String)this.logTag, (String)("frequencyHz " + frequencyHz + " is invalid, using 14000."));
            frequencyHz = 14000;
        }
        byte[] command = new byte[6];
        command[0] = -128;
        command[1] = 3;
        this.copyUWORDValueToBytes(frequencyHz, command, 2);
        this.copyUWORDValueToBytes(durationMs, command, 4);
        this.sendCommand(functionName, command);
    }

    @SimpleFunction(description="Sets the output state of a motor on the robot.")
    public void SetOutputState(String motorPortLetter, int power, int mode, int regulationMode, int turnRatio, int runState, long tachoLimit) {
        int port;
        String functionName = "SetOutputState";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        try {
            port = this.convertMotorPortLetterToNumber(motorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 407, motorPortLetter);
            return;
        }
        this.setOutputState(functionName, port, power, mode, regulationMode, this.sanitizeTurnRatio(turnRatio), runState, tachoLimit);
    }

    @SimpleFunction(description="Configure an input sensor on the robot.")
    public void SetInputMode(String sensorPortLetter, int sensorType, int sensorMode) {
        int port;
        String functionName = "SetInputMode";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        try {
            port = this.convertSensorPortLetterToNumber(sensorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 408, sensorPortLetter);
            return;
        }
        this.setInputMode(functionName, port, sensorType, sensorMode);
    }

    @SimpleFunction(description="Reads the output state of a motor on the robot.")
    public List<Number> GetOutputState(String motorPortLetter) {
        int port;
        String functionName = "GetOutputState";
        if (!this.checkBluetooth(functionName)) {
            return new ArrayList<Number>();
        }
        try {
            port = this.convertMotorPortLetterToNumber(motorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 407, motorPortLetter);
            return new ArrayList<Number>();
        }
        byte[] returnPackage = this.getOutputState(functionName, port);
        if (returnPackage != null) {
            ArrayList<Number> outputState = new ArrayList<Number>();
            outputState.add(this.getSBYTEValueFromBytes(returnPackage, 4));
            outputState.add(this.getUBYTEValueFromBytes(returnPackage, 5));
            outputState.add(this.getUBYTEValueFromBytes(returnPackage, 6));
            outputState.add(this.getSBYTEValueFromBytes(returnPackage, 7));
            outputState.add(this.getUBYTEValueFromBytes(returnPackage, 8));
            outputState.add(this.getULONGValueFromBytes(returnPackage, 9));
            outputState.add(this.getSLONGValueFromBytes(returnPackage, 13));
            outputState.add(this.getSLONGValueFromBytes(returnPackage, 17));
            outputState.add(this.getSLONGValueFromBytes(returnPackage, 21));
            return outputState;
        }
        return new ArrayList<Number>();
    }

    private byte[] getOutputState(String functionName, int port) {
        byte[] command = new byte[3];
        command[0] = 0;
        command[1] = 6;
        this.copyUBYTEValueToBytes(port, command, 2);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 25) {
                return returnPackage;
            }
            Log.w((String)this.logTag, (String)(functionName + ": unexpected return package length " + returnPackage.length + " (expected 25)"));
        }
        return null;
    }

    @SimpleFunction(description="Reads the values of an input sensor on the robot. Assumes sensor type has been configured via SetInputMode.")
    public List<Object> GetInputValues(String sensorPortLetter) {
        int port;
        String functionName = "GetInputValues";
        if (!this.checkBluetooth(functionName)) {
            return new ArrayList<Object>();
        }
        try {
            port = this.convertSensorPortLetterToNumber(sensorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 408, sensorPortLetter);
            return new ArrayList<Object>();
        }
        byte[] returnPackage = this.getInputValues(functionName, port);
        if (returnPackage != null) {
            ArrayList<Object> inputValues = new ArrayList<Object>();
            inputValues.add(this.getBooleanValueFromBytes(returnPackage, 4));
            inputValues.add(this.getBooleanValueFromBytes(returnPackage, 5));
            inputValues.add(this.getUBYTEValueFromBytes(returnPackage, 6));
            inputValues.add(this.getUBYTEValueFromBytes(returnPackage, 7));
            inputValues.add(this.getUWORDValueFromBytes(returnPackage, 8));
            inputValues.add(this.getUWORDValueFromBytes(returnPackage, 10));
            inputValues.add(this.getSWORDValueFromBytes(returnPackage, 12));
            inputValues.add(this.getSWORDValueFromBytes(returnPackage, 14));
            return inputValues;
        }
        return new ArrayList<Object>();
    }

    @SimpleFunction(description="Reset the scaled value of an input sensor on the robot.")
    public void ResetInputScaledValue(String sensorPortLetter) {
        int port;
        String functionName = "ResetInputScaledValue";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        try {
            port = this.convertSensorPortLetterToNumber(sensorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 408, sensorPortLetter);
            return;
        }
        this.resetInputScaledValue(functionName, port);
        byte[] command = new byte[3];
        command[0] = -128;
        command[1] = 8;
        this.copyUBYTEValueToBytes(port, command, 2);
        this.sendCommand(functionName, command);
    }

    @SimpleFunction(description="Write a message to a mailbox (1-10) on the robot.")
    public void MessageWrite(int mailbox, String message) {
        String functionName = "MessageWrite";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        if (mailbox < 1 || mailbox > 10) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 409, mailbox);
            return;
        }
        int messageLength = message.length();
        if (messageLength > 58) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 410, new Object[0]);
            return;
        }
        byte[] command = new byte[4 + messageLength + 1];
        command[0] = -128;
        command[1] = 9;
        this.copyUBYTEValueToBytes(--mailbox, command, 2);
        this.copyUBYTEValueToBytes(messageLength + 1, command, 3);
        this.copyStringValueToBytes(message, command, 4, messageLength);
        this.sendCommand(functionName, command);
    }

    @SimpleFunction(description="Reset motor position.")
    public void ResetMotorPosition(String motorPortLetter, boolean relative) {
        int port;
        String functionName = "ResetMotorPosition";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        try {
            port = this.convertMotorPortLetterToNumber(motorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 407, motorPortLetter);
            return;
        }
        byte[] command = new byte[4];
        command[0] = -128;
        command[1] = 10;
        this.copyUBYTEValueToBytes(port, command, 2);
        this.copyBooleanValueToBytes(relative, command, 3);
        this.sendCommand(functionName, command);
    }

    @SimpleFunction(description="Get the battery level for the robot. Returns the voltage in millivolts.")
    public int GetBatteryLevel() {
        String functionName = "GetBatteryLevel";
        if (!this.checkBluetooth(functionName)) {
            return 0;
        }
        byte[] command = new byte[]{0, 11};
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 5) {
                return this.getUWORDValueFromBytes(returnPackage, 3);
            }
            Log.w((String)this.logTag, (String)("GetBatteryLevel: unexpected return package length " + returnPackage.length + " (expected 5)"));
        }
        return 0;
    }

    @SimpleFunction(description="Stop sound playback.")
    public void StopSoundPlayback() {
        String functionName = "StopSoundPlayback";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        byte[] command = new byte[]{-128, 12};
        this.sendCommand(functionName, command);
    }

    @SimpleFunction(description="Keep Alive. Returns the current sleep time limit in milliseconds.")
    public long KeepAlive() {
        String functionName = "KeepAlive";
        if (!this.checkBluetooth(functionName)) {
            return 0L;
        }
        byte[] command = new byte[]{0, 13};
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 7) {
                return this.getULONGValueFromBytes(returnPackage, 3);
            }
            Log.w((String)this.logTag, (String)("KeepAlive: unexpected return package length " + returnPackage.length + " (expected 7)"));
        }
        return 0L;
    }

    @SimpleFunction(description="Returns the count of available bytes to read.")
    public int LsGetStatus(String sensorPortLetter) {
        int port;
        String functionName = "LsGetStatus";
        if (!this.checkBluetooth(functionName)) {
            return 0;
        }
        try {
            port = this.convertSensorPortLetterToNumber(sensorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 408, sensorPortLetter);
            return 0;
        }
        return this.lsGetStatus(functionName, port);
    }

    @SimpleFunction(description="Writes low speed data to an input sensor on the robot. Assumes sensor type has been configured via SetInputMode.")
    public void LsWrite(String sensorPortLetter, YailList list, int rxDataLength) {
        int port;
        String functionName = "LsWrite";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        try {
            port = this.convertSensorPortLetterToNumber(sensorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 408, sensorPortLetter);
            return;
        }
        if (list.size() > 16) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 411, new Object[0]);
            return;
        }
        Object[] array = list.toArray();
        byte[] bytes = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            int n;
            Object element = array[i];
            String s = element.toString();
            try {
                n = Integer.decode(s);
            }
            catch (NumberFormatException e) {
                this.form.dispatchErrorOccurredEvent(this, functionName, 412, i + 1);
                return;
            }
            bytes[i] = (byte)(n & 0xFF);
            if ((n >>= 8) == 0 || n == -1) continue;
            this.form.dispatchErrorOccurredEvent(this, functionName, 413, i + 1);
            return;
        }
        this.lsWrite(functionName, port, bytes, rxDataLength);
    }

    @SimpleFunction(description="Reads unsigned low speed data from an input sensor on the robot. Assumes sensor type has been configured via SetInputMode.")
    public List<Integer> LsRead(String sensorPortLetter) {
        int port;
        String functionName = "LsRead";
        if (!this.checkBluetooth(functionName)) {
            return new ArrayList<Integer>();
        }
        try {
            port = this.convertSensorPortLetterToNumber(sensorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 408, sensorPortLetter);
            return new ArrayList<Integer>();
        }
        byte[] returnPackage = this.lsRead(functionName, port);
        if (returnPackage != null) {
            ArrayList<Integer> list = new ArrayList<Integer>();
            int count = this.getUBYTEValueFromBytes(returnPackage, 3);
            for (int i = 0; i < count; ++i) {
                int n = returnPackage[4 + i] & 0xFF;
                list.add(n);
            }
            return list;
        }
        return new ArrayList<Integer>();
    }

    @SimpleFunction(description="Get the name of currently running program on the robot.")
    public String GetCurrentProgramName() {
        String functionName = "GetCurrentProgramName";
        if (!this.checkBluetooth(functionName)) {
            return "";
        }
        byte[] command = new byte[]{0, 17};
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        int status = this.getStatus(functionName, returnPackage, command[1]);
        if (status == 0) {
            return this.getStringValueFromBytes(returnPackage, 3);
        }
        if (status == 236) {
            return "";
        }
        this.evaluateStatus(functionName, returnPackage, command[1]);
        return "";
    }

    @SimpleFunction(description="Read a message from a mailbox (1-10) on the robot.")
    public String MessageRead(int mailbox) {
        String functionName = "MessageRead";
        if (!this.checkBluetooth(functionName)) {
            return "";
        }
        if (mailbox < 1 || mailbox > 10) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 409, mailbox);
            return "";
        }
        byte[] command = new byte[5];
        command[0] = 0;
        command[1] = 19;
        this.copyUBYTEValueToBytes(0, command, 2);
        this.copyUBYTEValueToBytes(--mailbox, command, 3);
        this.copyBooleanValueToBytes(true, command, 4);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 64) {
                int mailboxEcho = this.getUBYTEValueFromBytes(returnPackage, 3);
                if (mailboxEcho != mailbox) {
                    Log.w((String)this.logTag, (String)("MessageRead: unexpected return mailbox: " + mailboxEcho + " (expected " + mailbox + ")"));
                }
                int messageLength = this.getUBYTEValueFromBytes(returnPackage, 4) - 1;
                return this.getStringValueFromBytes(returnPackage, 5, messageLength);
            }
            Log.w((String)this.logTag, (String)("MessageRead: unexpected return package length " + returnPackage.length + " (expected 64)"));
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SimpleFunction(description="Download a file to the robot.")
    public void DownloadFile(String source, String destination) {
        String functionName = "DownloadFile";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        if (source.length() == 0) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 414, new Object[0]);
            return;
        }
        if (destination.length() == 0) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 415, new Object[0]);
            return;
        }
        try {
            File tempFile = MediaUtil.copyMediaToTempFile(this.form, source);
            try {
                BufferedInputStream in = new BufferedInputStream(new FileInputStream(tempFile), 1024);
                try {
                    Integer handle;
                    long fileSize = tempFile.length();
                    Integer n = handle = destination.endsWith(".rxe") || destination.endsWith(".ric") ? this.openWriteLinear(functionName, destination, fileSize) : this.openWrite(functionName, destination, fileSize);
                    if (handle == null) {
                        return;
                    }
                    try {
                        int writtenLength;
                        byte[] buffer = new byte[32];
                        for (long sentLength = 0L; sentLength < fileSize; sentLength += (long)writtenLength) {
                            int chunkLength = (int)Math.min(32L, fileSize - sentLength);
                            ((InputStream)in).read(buffer, 0, chunkLength);
                            writtenLength = this.writeChunk(functionName, handle, buffer, chunkLength);
                        }
                    }
                    finally {
                        this.closeHandle(functionName, handle);
                    }
                }
                finally {
                    ((InputStream)in).close();
                }
            }
            finally {
                tempFile.delete();
            }
        }
        catch (IOException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 416, e.getMessage());
            return;
        }
    }

    private Integer openWrite(String functionName, String fileName, long fileSize) {
        byte[] command = new byte[26];
        command[0] = 1;
        command[1] = -127;
        this.copyStringValueToBytes(fileName, command, 2, 19);
        this.copyULONGValueToBytes(fileSize, command, 22);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 4) {
                return this.getUBYTEValueFromBytes(returnPackage, 3);
            }
            Log.w((String)this.logTag, (String)(functionName + ": unexpected return package length " + returnPackage.length + " (expected 4)"));
        }
        return null;
    }

    private int writeChunk(String functionName, int handle, byte[] buffer, int length) throws IOException {
        if (length > 32) {
            throw new IllegalArgumentException("length must be <= 32");
        }
        byte[] command = new byte[3 + length];
        command[0] = 1;
        command[1] = -125;
        this.copyUBYTEValueToBytes(handle, command, 2);
        System.arraycopy(buffer, 0, command, 3, length);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 6) {
                int writtenLength = this.getUWORDValueFromBytes(returnPackage, 4);
                if (writtenLength != length) {
                    Log.e((String)this.logTag, (String)(functionName + ": only " + writtenLength + " bytes were written " + "(expected " + length + ")"));
                    throw new IOException("Unable to write file on robot");
                }
                return writtenLength;
            }
            Log.w((String)this.logTag, (String)(functionName + ": unexpected return package length " + returnPackage.length + " (expected 6)"));
        }
        return 0;
    }

    private void closeHandle(String functionName, int handle) {
        byte[] command = new byte[3];
        command[0] = 1;
        command[1] = -124;
        this.copyUBYTEValueToBytes(handle, command, 2);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        this.evaluateStatus(functionName, returnPackage, command[1]);
    }

    @SimpleFunction(description="Delete a file on the robot.")
    public void DeleteFile(String fileName) {
        String functionName = "DeleteFile";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        if (fileName.length() == 0) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 406, new Object[0]);
            return;
        }
        byte[] command = new byte[22];
        command[0] = 1;
        command[1] = -123;
        this.copyStringValueToBytes(fileName, command, 2, 19);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        this.evaluateStatus(functionName, returnPackage, command[1]);
    }

    @SimpleFunction(description="Returns a list containing the names of matching files found on the robot.")
    public List<String> ListFiles(String wildcard) {
        String functionName = "ListFiles";
        if (!this.checkBluetooth(functionName)) {
            return new ArrayList<String>();
        }
        ArrayList<String> fileNames = new ArrayList<String>();
        if (wildcard.length() == 0) {
            wildcard = "*.*";
        }
        byte[] command = new byte[22];
        command[0] = 1;
        command[1] = -122;
        this.copyStringValueToBytes(wildcard, command, 2, 19);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        int status = this.getStatus(functionName, returnPackage, command[1]);
        while (status == 0) {
            int handle = this.getUBYTEValueFromBytes(returnPackage, 3);
            String fileName = this.getStringValueFromBytes(returnPackage, 4);
            fileNames.add(fileName);
            command = new byte[3];
            command[0] = 1;
            command[1] = -121;
            this.copyUBYTEValueToBytes(handle, command, 2);
            returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
            status = this.getStatus(functionName, returnPackage, command[1]);
        }
        return fileNames;
    }

    @SimpleFunction(description="Get the firmware and protocol version numbers for the robot as a list where the first element is the firmware version number and the second element is the protocol version number.")
    public List<String> GetFirmwareVersion() {
        String functionName = "GetFirmwareVersion";
        if (!this.checkBluetooth(functionName)) {
            return new ArrayList<String>();
        }
        byte[] command = new byte[]{1, -120};
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            ArrayList<String> versions = new ArrayList<String>();
            versions.add(returnPackage[6] + "." + returnPackage[5]);
            versions.add(returnPackage[4] + "." + returnPackage[3]);
            return versions;
        }
        return new ArrayList<String>();
    }

    private Integer openWriteLinear(String functionName, String fileName, long fileSize) {
        byte[] command = new byte[26];
        command[0] = 1;
        command[1] = -119;
        this.copyStringValueToBytes(fileName, command, 2, 19);
        this.copyULONGValueToBytes(fileSize, command, 22);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 4) {
                return this.getUBYTEValueFromBytes(returnPackage, 3);
            }
            Log.w((String)this.logTag, (String)(functionName + ": unexpected return package length " + returnPackage.length + " (expected 4)"));
        }
        return null;
    }

    @SimpleFunction(description="Set the brick name of the robot.")
    public void SetBrickName(String name) {
        String functionName = "SetBrickName";
        if (!this.checkBluetooth(functionName)) {
            return;
        }
        byte[] command = new byte[18];
        command[0] = 1;
        command[1] = -104;
        this.copyStringValueToBytes(name, command, 2, 15);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        this.evaluateStatus(functionName, returnPackage, command[1]);
    }

    @SimpleFunction(description="Get the brick name of the robot.")
    public String GetBrickName() {
        String functionName = "GetBrickName";
        if (!this.checkBluetooth(functionName)) {
            return "";
        }
        byte[] command = new byte[]{1, -101};
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            return this.getStringValueFromBytes(returnPackage, 3);
        }
        return "";
    }
}

