/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.os.Handler;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.LegoMindstormsNxtSensor;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=1, description="A component that provides a high-level interface to a color sensor on a LEGO MINDSTORMS NXT robot.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsNxt.png")
@SimpleObject
public class NxtColorSensor
extends LegoMindstormsNxtSensor
implements Deleteable {
    private static final String DEFAULT_SENSOR_PORT = "3";
    private static final int DEFAULT_BOTTOM_OF_RANGE = 256;
    private static final int DEFAULT_TOP_OF_RANGE = 767;
    static final int SENSOR_TYPE_COLOR_FULL = 13;
    static final int SENSOR_TYPE_COLOR_RED = 14;
    static final int SENSOR_TYPE_COLOR_GREEN = 15;
    static final int SENSOR_TYPE_COLOR_BLUE = 16;
    static final int SENSOR_TYPE_COLOR_NONE = 17;
    private static final Map<Integer, Integer> mapColorToSensorType = new HashMap<Integer, Integer>();
    private static final Map<Integer, Integer> mapSensorValueToColor;
    private boolean detectColor;
    private Handler handler = new Handler();
    private final Runnable sensorReader;
    private int previousColor = 0xFFFFFF;
    private boolean colorChangedEventEnabled;
    private State previousState = State.UNKNOWN;
    private int bottomOfRange;
    private int topOfRange;
    private boolean belowRangeEventEnabled;
    private boolean withinRangeEventEnabled;
    private boolean aboveRangeEventEnabled;
    private int generateColor;

    public NxtColorSensor(ComponentContainer container) {
        super(container, "NxtColorSensor");
        this.sensorReader = new Runnable(){

            public void run() {
                if (NxtColorSensor.this.bluetooth != null && NxtColorSensor.this.bluetooth.IsConnected()) {
                    if (NxtColorSensor.this.detectColor) {
                        LegoMindstormsNxtSensor.SensorValue sensorValue = NxtColorSensor.this.getColorValue("");
                        if (sensorValue.valid) {
                            int currentColor = (Integer)sensorValue.value;
                            if (currentColor != NxtColorSensor.this.previousColor) {
                                NxtColorSensor.this.ColorChanged(currentColor);
                            }
                            NxtColorSensor.this.previousColor = currentColor;
                        }
                    } else {
                        LegoMindstormsNxtSensor.SensorValue sensorValue = NxtColorSensor.this.getLightValue("");
                        if (sensorValue.valid) {
                            State currentState = (Integer)sensorValue.value < NxtColorSensor.this.bottomOfRange ? State.BELOW_RANGE : ((Integer)sensorValue.value > NxtColorSensor.this.topOfRange ? State.ABOVE_RANGE : State.WITHIN_RANGE);
                            if (currentState != NxtColorSensor.this.previousState) {
                                if (currentState == State.BELOW_RANGE && NxtColorSensor.this.belowRangeEventEnabled) {
                                    NxtColorSensor.this.BelowRange();
                                }
                                if (currentState == State.WITHIN_RANGE && NxtColorSensor.this.withinRangeEventEnabled) {
                                    NxtColorSensor.this.WithinRange();
                                }
                                if (currentState == State.ABOVE_RANGE && NxtColorSensor.this.aboveRangeEventEnabled) {
                                    NxtColorSensor.this.AboveRange();
                                }
                            }
                            NxtColorSensor.this.previousState = currentState;
                        }
                    }
                }
                if (NxtColorSensor.this.isHandlerNeeded()) {
                    NxtColorSensor.this.handler.post(NxtColorSensor.this.sensorReader);
                }
            }
        };
        this.SensorPort(DEFAULT_SENSOR_PORT);
        this.DetectColor(true);
        this.ColorChangedEventEnabled(false);
        this.BottomOfRange(256);
        this.TopOfRange(767);
        this.BelowRangeEventEnabled(false);
        this.WithinRangeEventEnabled(false);
        this.AboveRangeEventEnabled(false);
        this.GenerateColor(0xFFFFFF);
    }

    @Override
    protected void initializeSensor(String functionName) {
        int sensorType = this.detectColor ? 13 : mapColorToSensorType.get(this.generateColor);
        this.setInputMode(functionName, this.port, sensorType, 0);
        this.resetInputScaledValue(functionName, this.port);
    }

    @Override
    @DesignerProperty(editorType="lego_nxt_sensor_port", defaultValue="3")
    @SimpleProperty(userVisible=false)
    public void SensorPort(String sensorPortLetter) {
        this.setSensorPort(sensorPortLetter);
    }

    @SimpleProperty(description="Whether the sensor should detect color or light. True indicates that the sensor should detect color; False indicates that the sensor should detect light. If the DetectColor property is set to True, the BelowRange, WithinRange, and AboveRange events will not occur and the sensor will not generate color. If the DetectColor property is set to False, the ColorChanged event will not occur.", category=PropertyCategory.BEHAVIOR)
    public boolean DetectColor() {
        return this.detectColor;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void DetectColor(boolean detectColor) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.detectColor = detectColor;
        if (this.bluetooth != null && this.bluetooth.IsConnected()) {
            this.initializeSensor("DetectColor");
        }
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        this.previousColor = 0xFFFFFF;
        this.previousState = State.UNKNOWN;
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleFunction(description="Returns the current detected color, or the color None if the color can not be read or if the DetectColor property is set to False.")
    public int GetColor() {
        String functionName = "GetColor";
        if (!this.checkBluetooth(functionName)) {
            return 0xFFFFFF;
        }
        if (!this.detectColor) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 417, new Object[0]);
            return 0xFFFFFF;
        }
        LegoMindstormsNxtSensor.SensorValue<Integer> sensorValue = this.getColorValue(functionName);
        if (sensorValue.valid) {
            return (Integer)sensorValue.value;
        }
        return 0xFFFFFF;
    }

    private LegoMindstormsNxtSensor.SensorValue<Integer> getColorValue(String functionName) {
        int scaledValue;
        boolean valid;
        byte[] returnPackage = this.getInputValues(functionName, this.port);
        if (returnPackage != null && (valid = this.getBooleanValueFromBytes(returnPackage, 4)) && mapSensorValueToColor.containsKey(scaledValue = this.getSWORDValueFromBytes(returnPackage, 12))) {
            int color = mapSensorValueToColor.get(scaledValue);
            return new LegoMindstormsNxtSensor.SensorValue<Integer>(true, color);
        }
        return new LegoMindstormsNxtSensor.SensorValue<Object>(false, null);
    }

    @SimpleProperty(description="Whether the ColorChanged event should fire when the DetectColor property is set to True and the detected color changes.", category=PropertyCategory.BEHAVIOR)
    public boolean ColorChangedEventEnabled() {
        return this.colorChangedEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void ColorChangedEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.colorChangedEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousColor = 0xFFFFFF;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Detected color has changed. The ColorChanged event will not occur if the DetectColor property is set to False or if the ColorChangedEventEnabled property is set to False.")
    public void ColorChanged(int color) {
        EventDispatcher.dispatchEvent(this, "ColorChanged", color);
    }

    @SimpleFunction(description="Returns the current light level as a value between 0 and 1023, or -1 if the light level can not be read or if the DetectColor property is set to True.")
    public int GetLightLevel() {
        String functionName = "GetLightLevel";
        if (!this.checkBluetooth(functionName)) {
            return -1;
        }
        if (this.detectColor) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 418, new Object[0]);
            return -1;
        }
        LegoMindstormsNxtSensor.SensorValue<Integer> sensorValue = this.getLightValue(functionName);
        if (sensorValue.valid) {
            return (Integer)sensorValue.value;
        }
        return -1;
    }

    private LegoMindstormsNxtSensor.SensorValue<Integer> getLightValue(String functionName) {
        boolean valid;
        byte[] returnPackage = this.getInputValues(functionName, this.port);
        if (returnPackage != null && (valid = this.getBooleanValueFromBytes(returnPackage, 4))) {
            int normalizedValue = this.getUWORDValueFromBytes(returnPackage, 10);
            return new LegoMindstormsNxtSensor.SensorValue<Integer>(true, normalizedValue);
        }
        return new LegoMindstormsNxtSensor.SensorValue<Object>(false, null);
    }

    @SimpleProperty(description="The bottom of the range used for the BelowRange, WithinRange, and AboveRange events.", category=PropertyCategory.BEHAVIOR)
    public int BottomOfRange() {
        return this.bottomOfRange;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="256")
    @SimpleProperty
    public void BottomOfRange(int bottomOfRange) {
        this.bottomOfRange = bottomOfRange;
        this.previousState = State.UNKNOWN;
    }

    @SimpleProperty(description="The top of the range used for the BelowRange, WithinRange, and AboveRange events.", category=PropertyCategory.BEHAVIOR)
    public int TopOfRange() {
        return this.topOfRange;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="767")
    @SimpleProperty
    public void TopOfRange(int topOfRange) {
        this.topOfRange = topOfRange;
        this.previousState = State.UNKNOWN;
    }

    @SimpleProperty(description="Whether the BelowRange event should fire when the DetectColor property is set to False and the light level goes below the BottomOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean BelowRangeEventEnabled() {
        return this.belowRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void BelowRangeEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.belowRangeEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Light level has gone below the range. The BelowRange event will not occur if the DetectColor property is set to True or if the BelowRangeEventEnabled property is set to False.")
    public void BelowRange() {
        EventDispatcher.dispatchEvent(this, "BelowRange", new Object[0]);
    }

    @SimpleProperty(description="Whether the WithinRange event should fire when the DetectColor property is set to False and the light level goes between the BottomOfRange and the TopOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean WithinRangeEventEnabled() {
        return this.withinRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void WithinRangeEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.withinRangeEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Light level has gone within the range. The WithinRange event will not occur if the DetectColor property is set to True or if the WithinRangeEventEnabled property is set to False.")
    public void WithinRange() {
        EventDispatcher.dispatchEvent(this, "WithinRange", new Object[0]);
    }

    @SimpleProperty(description="Whether the AboveRange event should fire when the DetectColor property is set to False and the light level goes above the TopOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean AboveRangeEventEnabled() {
        return this.aboveRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void AboveRangeEventEnabled(boolean enabled) {
        boolean handlerWasNeeded = this.isHandlerNeeded();
        this.aboveRangeEventEnabled = enabled;
        boolean handlerIsNeeded = this.isHandlerNeeded();
        if (handlerWasNeeded && !handlerIsNeeded) {
            this.handler.removeCallbacks(this.sensorReader);
        }
        if (!handlerWasNeeded && handlerIsNeeded) {
            this.previousState = State.UNKNOWN;
            this.handler.post(this.sensorReader);
        }
    }

    @SimpleEvent(description="Light level has gone above the range. The AboveRange event will not occur if the DetectColor property is set to True or if the AboveRangeEventEnabled property is set to False.")
    public void AboveRange() {
        EventDispatcher.dispatchEvent(this, "AboveRange", new Object[0]);
    }

    @SimpleProperty(description="The color that should generated by the sensor. Only None, Red, Green, or Blue are valid values. The sensor will not generate color when the DetectColor property is set to True.", category=PropertyCategory.BEHAVIOR)
    public int GenerateColor() {
        return this.generateColor;
    }

    @DesignerProperty(editorType="lego_nxt_generated_color", defaultValue="&H00FFFFFF")
    @SimpleProperty
    public void GenerateColor(int generateColor) {
        String functionName = "GenerateColor";
        if (mapColorToSensorType.containsKey(generateColor)) {
            this.generateColor = generateColor;
            if (this.bluetooth != null && this.bluetooth.IsConnected()) {
                this.initializeSensor(functionName);
            }
        } else {
            this.form.dispatchErrorOccurredEvent(this, functionName, 419, new Object[0]);
        }
    }

    private boolean isHandlerNeeded() {
        if (this.detectColor) {
            return this.colorChangedEventEnabled;
        }
        return this.belowRangeEventEnabled || this.withinRangeEventEnabled || this.aboveRangeEventEnabled;
    }

    @Override
    public void onDelete() {
        this.handler.removeCallbacks(this.sensorReader);
        super.onDelete();
    }

    static {
        mapColorToSensorType.put(-65536, 14);
        mapColorToSensorType.put(-16711936, 15);
        mapColorToSensorType.put(-16776961, 16);
        mapColorToSensorType.put(0xFFFFFF, 17);
        mapSensorValueToColor = new HashMap<Integer, Integer>();
        mapSensorValueToColor.put(1, -16777216);
        mapSensorValueToColor.put(2, -16776961);
        mapSensorValueToColor.put(3, -16711936);
        mapSensorValueToColor.put(4, -256);
        mapSensorValueToColor.put(5, -65536);
        mapSensorValueToColor.put(6, -1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        UNKNOWN,
        BELOW_RANGE,
        WITHIN_RANGE,
        ABOVE_RANGE;

    }
}

