/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.nfc.NfcAdapter;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnNewIntentListener;
import com.google.appinventor.components.runtime.OnPauseListener;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import com.google.appinventor.components.runtime.util.GingerbreadUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;

@DesignerComponent(version=1, description="<p>Non-visible component to provide NFC capabilities.  For now this component supports the reading and writing of text tags only (if supported by the device)</p><p>In order to read and write text tags, the component must have its <code>ReadMode</code> property set to True or False respectively.</p><p><strong>Note:</strong> This component will only work on Screen1 of any App Inventor app.</p>", category=ComponentCategory.SENSORS, nonVisible=true, iconName="images/nearfield.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.NFC")
public class NearField
extends AndroidNonvisibleComponent
implements OnStopListener,
OnResumeListener,
OnPauseListener,
OnNewIntentListener,
Deleteable {
    private static final String TAG = "nearfield";
    private Activity activity;
    private NfcAdapter nfcAdapter;
    private boolean readMode = true;
    private int writeType;
    private String tagContent = "";
    private String textToWrite = "";
    protected int requestCode;

    public NearField(ComponentContainer container) {
        super(container.$form());
        this.activity = container.$context();
        this.writeType = 1;
        this.nfcAdapter = SdkLevel.getLevel() >= 9 ? GingerbreadUtil.newNfcAdapter((Context)this.activity) : null;
        this.form.registerForOnResume(this);
        this.form.registerForOnNewIntent(this);
        this.form.registerForOnPause(this);
        Log.d((String)TAG, (String)"Nearfield component created");
    }

    @SimpleEvent
    public void TagRead(String message) {
        Log.d((String)TAG, (String)("Tag read: got message " + message));
        this.tagContent = message;
        EventDispatcher.dispatchEvent(this, "TagRead", message);
    }

    @SimpleEvent
    public void TagWritten() {
        Log.d((String)TAG, (String)("Tag written: " + this.textToWrite));
        EventDispatcher.dispatchEvent(this, "TagWritten", new Object[0]);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String LastMessage() {
        Log.d((String)TAG, (String)"String message method stared");
        return this.tagContent;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean ReadMode() {
        Log.d((String)TAG, (String)"boolean method stared");
        return this.readMode;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String TextToWrite() {
        Log.d((String)TAG, (String)"String message method stared");
        return this.textToWrite;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public int WriteType() {
        return this.writeType;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public void ReadMode(boolean newMode) {
        Log.d((String)TAG, (String)("Read mode set to" + newMode));
        this.readMode = newMode;
        if (!this.readMode && SdkLevel.getLevel() >= 9) {
            GingerbreadUtil.enableNFCWriteMode(this.activity, this.nfcAdapter, this.textToWrite);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public void TextToWrite(String newText) {
        Log.d((String)TAG, (String)("Text to write set to" + newText));
        this.textToWrite = newText;
        if (!this.readMode && this.writeType == 1 && SdkLevel.getLevel() >= 9) {
            GingerbreadUtil.enableNFCWriteMode(this.activity, this.nfcAdapter, this.textToWrite);
        }
    }

    public void onNewIntent(Intent intent) {
        Log.d((String)TAG, (String)("Nearfield on onNewIntent.  Intent is: " + intent));
        this.resolveIntent(intent);
    }

    public void onResume() {
        Intent intent = this.activity.getIntent();
        Log.d((String)TAG, (String)("Nearfield on onResume.  Intent is: " + intent));
    }

    void resolveIntent(Intent intent) {
        Log.d((String)TAG, (String)("resolve intent. Intent is: " + intent));
        if (SdkLevel.getLevel() >= 9) {
            GingerbreadUtil.resolveNFCIntent(intent, this);
        }
    }

    public void onPause() {
        Log.d((String)TAG, (String)"OnPause method started.");
        if (this.nfcAdapter != null) {
            GingerbreadUtil.disableNFCAdapter(this.activity, this.nfcAdapter);
        }
    }

    public void onDelete() {
    }

    public void onStop() {
    }
}

