/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.os.Handler;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesLibraries;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.util.AsyncCallbackPair;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.entity.mime.content.ContentBody;
import org.apache.http.entity.mime.content.FileBody;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.http.util.EntityUtils;

@DesignerComponent(version=1, description="Non-visible component that communicates with a Web service and stores media files.", category=ComponentCategory.INTERNAL, nonVisible=true, iconName="images/mediastore.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET")
@UsesLibraries(libraries="httpcore-4.3.2.jar,httpmime-4.3.4.jar")
public final class MediaStore
extends AndroidNonvisibleComponent
implements Component {
    protected final ComponentContainer componentContainer;
    private static final String LOG_TAG_COMPONENT = "MediaStore: ";
    private String serviceURL;
    private Handler androidUIHandler;

    public MediaStore(ComponentContainer container) {
        super(container.$form());
        this.componentContainer = container;
        this.androidUIHandler = new Handler();
        this.serviceURL = "http://ai-mediaservice.appspot.com";
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String ServiceURL() {
        return this.serviceURL;
    }

    @DesignerProperty(editorType="string", defaultValue="http://ai-mediaservice.appspot.com")
    @SimpleProperty
    public void ServiceURL(String url) {
        this.serviceURL = url;
    }

    @SimpleFunction
    public void PostMedia(String mediafile) throws FileNotFoundException {
        AsyncCallbackPair<String> myCallback = new AsyncCallbackPair<String>(){

            @Override
            public void onSuccess(final String response) {
                MediaStore.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        MediaStore.this.MediaStored(response);
                    }
                });
            }

            @Override
            public void onFailure(final String message) {
                MediaStore.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        MediaStore.this.WebServiceError(message);
                    }
                });
            }
        };
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            MultipartEntityBuilder entityBuilder = MultipartEntityBuilder.create();
            entityBuilder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            String[] pathtokens = mediafile.split("/");
            String newMediaPath = pathtokens[0].equals("file:") ? new File(new URL(mediafile).toURI()).getAbsolutePath() : mediafile;
            File media = new File(newMediaPath);
            entityBuilder.addPart("file", (ContentBody)new FileBody(media));
            HttpEntity entity = entityBuilder.build();
            String uploadURL = this.getUploadUrl();
            HttpPost post = new HttpPost(uploadURL);
            post.setEntity(entity);
            HttpResponse response = client.execute((HttpUriRequest)post);
            HttpEntity httpEntity = response.getEntity();
            String result = EntityUtils.toString((HttpEntity)httpEntity);
            myCallback.onSuccess(result);
        }
        catch (Exception e) {
            e.printStackTrace();
            myCallback.onFailure(e.getMessage());
        }
    }

    private String getUploadUrl() {
        try {
            String inputLine;
            String url = this.serviceURL;
            URL obj = new URL(url);
            HttpURLConnection con = (HttpURLConnection)obj.openConnection();
            con.setRequestMethod("GET");
            String USER_AGENT = "AppInventor";
            con.setRequestProperty("User-Agent", USER_AGENT);
            con.setRequestProperty("Content-Type", "text/plain; charset=utf-8");
            BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
            StringBuilder response = new StringBuilder();
            while ((inputLine = in.readLine()) != null) {
                response.append(inputLine);
            }
            in.close();
            return response.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            return "";
        }
    }

    @SimpleEvent
    public void MediaStored(String url) {
        EventDispatcher.dispatchEvent(this, "MediaStored", url);
    }

    @SimpleEvent
    public void WebServiceError(String message) {
        EventDispatcher.dispatchEvent(this, "WebServiceError", message);
    }
}

