/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.content.Context;
import android.location.Address;
import android.location.Criteria;
import android.location.Geocoder;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.location.LocationProvider;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=3, description="Non-visible component providing location information, including longitude, latitude, altitude (if supported by the device), speed (if supported by the device), and address.  This can also perform \"geocoding\", converting a given address (not necessarily the current one) to a latitude (with the <code>LatitudeFromAddress</code> method) and a longitude (with the <code>LongitudeFromAddress</code> method).</p>\n<p>In order to function, the component must have its <code>Enabled</code> property set to True, and the device must have location sensing enabled through wireless networks or GPS satellites (if outdoors).</p>\nLocation information might not be immediately available when an app starts.  You'll have to wait a short time for a location provider to be found and used, or wait for the OnLocationChanged event", category=ComponentCategory.SENSORS, nonVisible=true, iconName="images/locationSensor.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.ACCESS_FINE_LOCATION,android.permission.ACCESS_COARSE_LOCATION,android.permission.ACCESS_MOCK_LOCATION,android.permission.ACCESS_LOCATION_EXTRA_COMMANDS")
public class LocationSensor
extends AndroidNonvisibleComponent
implements Component,
OnStopListener,
OnResumeListener,
Deleteable {
    public static final int UNKNOWN_VALUE = 0;
    private final Criteria locationCriteria;
    private final Handler handler;
    private final LocationManager locationManager;
    private boolean providerLocked = false;
    private String providerName;
    private int timeInterval;
    private int distanceInterval;
    private MyLocationListener myLocationListener;
    private LocationProvider locationProvider;
    private boolean listening = false;
    private List<String> allProviders;
    private Location lastLocation;
    private double longitude = 0.0;
    private double latitude = 0.0;
    private double altitude = 0.0;
    private float speed = 0.0f;
    private boolean hasLocationData = false;
    private boolean hasAltitude = false;
    private final Handler androidUIHandler = new Handler();
    private Geocoder geocoder;
    private boolean enabled = true;

    public LocationSensor(ComponentContainer container) {
        super(container.$form());
        this.handler = new Handler();
        this.form.registerForOnResume(this);
        this.form.registerForOnStop(this);
        this.timeInterval = 60000;
        this.distanceInterval = 5;
        Activity context = container.$context();
        this.geocoder = new Geocoder((Context)context);
        this.locationManager = (LocationManager)context.getSystemService("location");
        this.locationCriteria = new Criteria();
        this.myLocationListener = new MyLocationListener();
        this.allProviders = new ArrayList<String>();
        this.Enabled(this.enabled);
    }

    @SimpleEvent
    public void LocationChanged(double latitude, double longitude, double altitude, float speed) {
        EventDispatcher.dispatchEvent(this, "LocationChanged", latitude, longitude, altitude, Float.valueOf(speed));
    }

    @SimpleEvent
    public void StatusChanged(String provider, String status) {
        if (this.enabled) {
            EventDispatcher.dispatchEvent(this, "StatusChanged", provider, status);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String ProviderName() {
        if (this.providerName == null) {
            return "NO PROVIDER";
        }
        return this.providerName;
    }

    @SimpleProperty
    public void ProviderName(String providerName) {
        this.providerName = providerName;
        if (!this.empty(providerName) && this.startProvider(providerName)) {
            return;
        }
        this.RefreshProvider();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean ProviderLocked() {
        return this.providerLocked;
    }

    @SimpleProperty
    public void ProviderLocked(boolean lock) {
        this.providerLocked = lock;
    }

    @DesignerProperty(editorType="sensor_time_interval", defaultValue="60000")
    @SimpleProperty
    public void TimeInterval(int interval) {
        if (interval < 0 || interval > 1000000) {
            return;
        }
        this.timeInterval = interval;
        if (this.enabled) {
            this.RefreshProvider();
        }
    }

    @SimpleProperty(description="Determines the minimum time interval, in milliseconds, that the sensor will try to use for sending out location updates. However, location updates will only be received when the location of the phone actually changes, and use of the specified time interval is not guaranteed. For example, if 1000 is used as the time interval, location updates will never be fired sooner than 1000ms, but they may be fired anytime after.", category=PropertyCategory.BEHAVIOR)
    public int TimeInterval() {
        return this.timeInterval;
    }

    @DesignerProperty(editorType="sensor_dist_interval", defaultValue="5")
    @SimpleProperty
    public void DistanceInterval(int interval) {
        if (interval < 0 || interval > 1000) {
            return;
        }
        this.distanceInterval = interval;
        if (this.enabled) {
            this.RefreshProvider();
        }
    }

    @SimpleProperty(description="Determines the minimum distance interval, in meters, that the sensor will try to use for sending out location updates. For example, if this is set to 5, then the sensor will fire a LocationChanged event only after 5 meters have been traversed. However, the sensor does not guarantee that an update will be received at exactly the distance interval. It may take more than 5 meters to fire an event, for instance.", category=PropertyCategory.BEHAVIOR)
    public int DistanceInterval() {
        return this.distanceInterval;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean HasLongitudeLatitude() {
        return this.hasLocationData && this.enabled;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean HasAltitude() {
        return this.hasAltitude && this.enabled;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean HasAccuracy() {
        return this.Accuracy() != 0.0 && this.enabled;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public double Longitude() {
        return this.longitude;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public double Latitude() {
        return this.latitude;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public double Altitude() {
        return this.altitude;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public double Accuracy() {
        if (this.lastLocation != null && this.lastLocation.hasAccuracy()) {
            return this.lastLocation.getAccuracy();
        }
        if (this.locationProvider != null) {
            return this.locationProvider.getAccuracy();
        }
        return 0.0;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Enabled() {
        return this.enabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void Enabled(boolean enabled) {
        this.enabled = enabled;
        if (!enabled) {
            this.stopListening();
        } else {
            this.RefreshProvider();
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String CurrentAddress() {
        if (this.hasLocationData && this.latitude <= 90.0 && this.latitude >= -90.0 && this.longitude <= 180.0 || this.longitude >= -180.0) {
            try {
                Address address;
                List addresses = this.geocoder.getFromLocation(this.latitude, this.longitude, 1);
                if (addresses != null && addresses.size() == 1 && (address = (Address)addresses.get(0)) != null) {
                    StringBuilder sb = new StringBuilder();
                    for (int i = 0; i <= address.getMaxAddressLineIndex(); ++i) {
                        sb.append(address.getAddressLine(i));
                        sb.append("\n");
                    }
                    return sb.toString();
                }
            }
            catch (Exception e) {
                if (e instanceof IllegalArgumentException || e instanceof IOException || e instanceof IndexOutOfBoundsException) {
                    Log.e((String)"LocationSensor", (String)("Exception thrown by getting current address " + e.getMessage()));
                }
                Log.e((String)"LocationSensor", (String)("Unexpected exception thrown by getting current address " + e.getMessage()));
            }
        }
        return "No address available";
    }

    @SimpleFunction(description="Derives latitude of given address")
    public double LatitudeFromAddress(String locationName) {
        try {
            List addressObjs = this.geocoder.getFromLocationName(locationName, 1);
            Log.i((String)"LocationSensor", (String)("latitude addressObjs size is " + addressObjs.size() + " for " + locationName));
            if (addressObjs == null || addressObjs.size() == 0) {
                throw new IOException("");
            }
            return ((Address)addressObjs.get(0)).getLatitude();
        }
        catch (IOException e) {
            this.form.dispatchErrorOccurredEvent(this, "LatitudeFromAddress", 101, locationName);
            return 0.0;
        }
    }

    @SimpleFunction(description="Derives longitude of given address")
    public double LongitudeFromAddress(String locationName) {
        try {
            List addressObjs = this.geocoder.getFromLocationName(locationName, 1);
            Log.i((String)"LocationSensor", (String)("longitude addressObjs size is " + addressObjs.size() + " for " + locationName));
            if (addressObjs == null || addressObjs.size() == 0) {
                throw new IOException("");
            }
            return ((Address)addressObjs.get(0)).getLongitude();
        }
        catch (IOException e) {
            this.form.dispatchErrorOccurredEvent(this, "LongitudeFromAddress", 102, locationName);
            return 0.0;
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public List<String> AvailableProviders() {
        return this.allProviders;
    }

    public void RefreshProvider() {
        this.stopListening();
        if (this.providerLocked && !this.empty(this.providerName)) {
            this.listening = this.startProvider(this.providerName);
            return;
        }
        this.allProviders = this.locationManager.getProviders(true);
        String bProviderName = this.locationManager.getBestProvider(this.locationCriteria, true);
        if (bProviderName != null && !bProviderName.equals(this.allProviders.get(0))) {
            this.allProviders.add(0, bProviderName);
        }
        for (String providerN : this.allProviders) {
            this.listening = this.startProvider(providerN);
            if (!this.listening) continue;
            if (!this.providerLocked) {
                this.providerName = providerN;
            }
            return;
        }
    }

    private boolean startProvider(String providerName) {
        this.providerName = providerName;
        LocationProvider tLocationProvider = this.locationManager.getProvider(providerName);
        if (tLocationProvider == null) {
            Log.d((String)"LocationSensor", (String)("getProvider(" + providerName + ") returned null"));
            return false;
        }
        this.stopListening();
        this.locationProvider = tLocationProvider;
        this.locationManager.requestLocationUpdates(providerName, (long)this.timeInterval, (float)this.distanceInterval, (LocationListener)this.myLocationListener);
        this.listening = true;
        return true;
    }

    private void stopListening() {
        if (this.listening) {
            this.locationManager.removeUpdates((LocationListener)this.myLocationListener);
            this.locationProvider = null;
            this.listening = false;
        }
    }

    @Override
    public void onResume() {
        if (this.enabled) {
            this.RefreshProvider();
        }
    }

    @Override
    public void onStop() {
        this.stopListening();
    }

    @Override
    public void onDelete() {
        this.stopListening();
    }

    private boolean empty(String s) {
        return s == null || s.length() == 0;
    }

    private class MyLocationListener
    implements LocationListener {
        private MyLocationListener() {
        }

        public void onLocationChanged(Location location) {
            LocationSensor.this.lastLocation = location;
            LocationSensor.this.longitude = location.getLongitude();
            LocationSensor.this.latitude = location.getLatitude();
            LocationSensor.this.speed = location.getSpeed();
            if (location.hasAltitude()) {
                LocationSensor.this.hasAltitude = true;
                LocationSensor.this.altitude = location.getAltitude();
            }
            if (LocationSensor.this.longitude != 0.0 || LocationSensor.this.latitude != 0.0) {
                LocationSensor.this.hasLocationData = true;
                final double argLatitude = LocationSensor.this.latitude;
                final double argLongitude = LocationSensor.this.longitude;
                final double argAltitude = LocationSensor.this.altitude;
                final float argSpeed = LocationSensor.this.speed;
                LocationSensor.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        LocationSensor.this.LocationChanged(argLatitude, argLongitude, argAltitude, argSpeed);
                    }
                });
            }
        }

        public void onProviderDisabled(String provider) {
            LocationSensor.this.StatusChanged(provider, "Disabled");
            LocationSensor.this.stopListening();
            if (LocationSensor.this.enabled) {
                LocationSensor.this.RefreshProvider();
            }
        }

        public void onProviderEnabled(String provider) {
            LocationSensor.this.StatusChanged(provider, "Enabled");
            LocationSensor.this.RefreshProvider();
        }

        public void onStatusChanged(String provider, int status, Bundle extras) {
            switch (status) {
                case 1: {
                    LocationSensor.this.StatusChanged(provider, "TEMPORARILY_UNAVAILABLE");
                    break;
                }
                case 0: {
                    LocationSensor.this.StatusChanged(provider, "OUT_OF_SERVICE");
                    if (!provider.equals(LocationSensor.this.providerName)) break;
                    LocationSensor.this.stopListening();
                    LocationSensor.this.RefreshProvider();
                    break;
                }
                case 2: {
                    LocationSensor.this.StatusChanged(provider, "AVAILABLE");
                    if (provider.equals(LocationSensor.this.providerName) || LocationSensor.this.allProviders.contains(provider)) break;
                    LocationSensor.this.RefreshProvider();
                }
            }
        }
    }
}

