/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.GradientDrawable;
import android.text.Editable;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.TextWatcher;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.ForegroundColorSpan;
import android.view.View;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.LinearLayout;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.util.ElementsUtil;
import com.google.appinventor.components.runtime.util.YailList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=5, description="<p>This is a visible component that displays a list of text elements. <br> The list can be set using the ElementsFromString property or using the Elements block in the blocks editor. </p>", category=ComponentCategory.USERINTERFACE, nonVisible=false, iconName="images/listView.png")
@SimpleObject
public final class ListView
extends AndroidViewComponent
implements AdapterView.OnItemClickListener {
    private static final String LOG_TAG = "ListView";
    private final android.widget.ListView view;
    private EditText txtSearchBox;
    protected final ComponentContainer container;
    private final LinearLayout listViewLayout;
    private ArrayAdapter<Spannable> adapter;
    private ArrayAdapter<Spannable> adapterCopy;
    private YailList items;
    private int selectionIndex;
    private String selection;
    private boolean showFilter = false;
    private static final boolean DEFAULT_ENABLED = false;
    private int backgroundColor;
    private static final int DEFAULT_BACKGROUND_COLOR = -16777216;
    private int textColor;
    private static final int DEFAULT_TEXT_COLOR = -1;
    private int selectionColor;
    private static final int DEFAULT_SELECTION_COLOR = -3355444;
    private int textSize;
    private static final int DEFAULT_TEXT_SIZE = 22;

    public ListView(ComponentContainer container) {
        super(container);
        this.container = container;
        this.items = YailList.makeEmptyList();
        this.SelectionIndex(0);
        this.view = new android.widget.ListView((Context)container.$context());
        this.view.setOnItemClickListener((AdapterView.OnItemClickListener)this);
        this.view.setChoiceMode(1);
        this.view.setScrollingCacheEnabled(false);
        this.listViewLayout = new LinearLayout((Context)container.$context());
        this.listViewLayout.setOrientation(1);
        this.txtSearchBox = new EditText((Context)container.$context());
        this.txtSearchBox.setSingleLine(true);
        this.txtSearchBox.setWidth(-2);
        this.txtSearchBox.setPadding(10, 10, 10, 10);
        this.txtSearchBox.setHint((CharSequence)"Search list...");
        this.txtSearchBox.addTextChangedListener(new TextWatcher(){

            public void onTextChanged(CharSequence cs, int arg1, int arg2, int arg3) {
                ListView.this.adapter.getFilter().filter(cs);
            }

            public void beforeTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {
            }

            public void afterTextChanged(Editable arg0) {
            }
        });
        if (this.showFilter) {
            this.txtSearchBox.setVisibility(0);
        } else {
            this.txtSearchBox.setVisibility(8);
        }
        this.Width(-2);
        this.BackgroundColor(-16777216);
        this.SelectionColor(-3355444);
        this.textColor = -1;
        this.TextColor(this.textColor);
        this.textSize = 22;
        this.TextSize(this.textSize);
        this.ElementsFromString("");
        this.listViewLayout.addView((View)this.txtSearchBox);
        this.listViewLayout.addView((View)this.view);
        this.listViewLayout.requestLayout();
        container.$add(this);
    }

    @Override
    public View getView() {
        return this.listViewLayout;
    }

    @Override
    @SimpleProperty(description="Determines the height of the list on the view.", category=PropertyCategory.APPEARANCE)
    public void Height(int height) {
        if (height == -1) {
            height = -2;
        }
        super.Height(height);
    }

    @Override
    @SimpleProperty(description="Determines the width of the list on the view.", category=PropertyCategory.APPEARANCE)
    public void Width(int width) {
        if (width == -1) {
            width = -2;
        }
        super.Width(width);
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(description="Sets visibility of ShowFilterBar. True will show the bar, False will hide it.")
    public void ShowFilterBar(boolean showFilter) {
        this.showFilter = showFilter;
        if (showFilter) {
            this.txtSearchBox.setVisibility(0);
        } else {
            this.txtSearchBox.setVisibility(8);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Returns current state of ShowFilterBar for visibility.")
    public boolean ShowFilterBar() {
        return this.showFilter;
    }

    @SimpleProperty(description="List of text elements to show in the ListView.  This willsignal an error if the elements are not text strings.", category=PropertyCategory.BEHAVIOR)
    public void Elements(YailList itemsList) {
        this.items = ElementsUtil.elements(itemsList, "Listview");
        this.setAdapterData();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public YailList Elements() {
        return this.items;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty(description="The TextView elements specified as a string with the items separated by commas such as: Cheese,Fruit,Bacon,Radish. Each word before the comma will be an element in the list.", category=PropertyCategory.BEHAVIOR)
    public void ElementsFromString(String itemstring) {
        this.items = ElementsUtil.elementsFromString(itemstring);
        this.setAdapterData();
    }

    public void setAdapterData() {
        this.adapter = new ArrayAdapter((Context)this.container.$context(), 17367043, (Object[])this.itemsToColoredText());
        this.view.setAdapter(this.adapter);
        this.adapterCopy = new ArrayAdapter((Context)this.container.$context(), 17367043);
        for (int i = 0; i < this.adapter.getCount(); ++i) {
            this.adapterCopy.insert(this.adapter.getItem(i), i);
        }
    }

    public Spannable[] itemsToColoredText() {
        int size = this.items.size();
        int displayTextSize = this.textSize;
        Spannable[] objects = new Spannable[size];
        for (int i = 1; i <= size; ++i) {
            String itemString = YailList.YailListElementToString(this.items.get(i));
            SpannableString chars = new SpannableString((CharSequence)itemString);
            chars.setSpan((Object)new ForegroundColorSpan(this.textColor), 0, chars.length(), 0);
            this.container.$form();
            if (!Form.getCompatibilityMode()) {
                displayTextSize = (int)((float)this.textSize * this.container.$form().deviceDensity());
            }
            chars.setSpan((Object)new AbsoluteSizeSpan(displayTextSize), 0, chars.length(), 0);
            objects[i - 1] = chars;
        }
        return objects;
    }

    @SimpleProperty(description="The index of the currently selected item, starting at 1.  If no item is selected, the value will be 0.  If an attempt is made to set this to a number less than 1 or greater than the number of items in the ListView, SelectionIndex will be set to 0, and Selection will be set to the empty text.", category=PropertyCategory.BEHAVIOR)
    public int SelectionIndex() {
        return this.selectionIndex;
    }

    @SimpleProperty(description="Specifies the position of the selected item in the ListView. This could be used to retrievethe text at the chosen position. If an attempt is made to set this to a number less than 1 or greater than the number of items in the ListView, SelectionIndex will be set to 0, and Selection will be set to the empty text.", category=PropertyCategory.BEHAVIOR)
    public void SelectionIndex(int index) {
        this.selectionIndex = ElementsUtil.selectionIndex(index, this.items);
        this.selection = ElementsUtil.setSelectionFromIndex(index, this.items);
    }

    @SimpleProperty(description="Returns the text last selected in the ListView.", category=PropertyCategory.BEHAVIOR)
    public String Selection() {
        return this.selection;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void Selection(String value) {
        this.selection = value;
        this.selectionIndex = ElementsUtil.setSelectedIndexFromValue(value, this.items);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        Spannable item = (Spannable)parent.getAdapter().getItem(position);
        this.selection = item.toString();
        this.selectionIndex = this.adapterCopy.getPosition((Object)item) + 1;
        this.AfterPicking();
    }

    @SimpleEvent(description="Simple event to be raised after the an element has been chosen in the list. The selected element is available in the Selection property.")
    public void AfterPicking() {
        EventDispatcher.dispatchEvent(this, "AfterPicking", new Object[0]);
    }

    public void setBackgroundColor(int color) {
        this.backgroundColor = color;
        this.view.setBackgroundColor(this.backgroundColor);
        this.listViewLayout.setBackgroundColor(this.backgroundColor);
        this.view.setCacheColorHint(this.backgroundColor);
    }

    @SimpleProperty(description="The color of the listview background.", category=PropertyCategory.APPEARANCE)
    public int BackgroundColor() {
        return this.backgroundColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&HFF000000")
    @SimpleProperty
    public void BackgroundColor(int argb) {
        this.backgroundColor = argb;
        this.setBackgroundColor(this.backgroundColor);
    }

    @SimpleProperty(description="The color of the item when it is selected.")
    public int SelectionColor() {
        return this.selectionColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&HFFCCCCCC")
    @SimpleProperty
    public void SelectionColor(int argb) {
        this.selectionColor = argb;
        this.view.setSelector((Drawable)new GradientDrawable(GradientDrawable.Orientation.TOP_BOTTOM, new int[]{argb, argb}));
    }

    @SimpleProperty(description="The text color of the listview items.", category=PropertyCategory.APPEARANCE)
    public int TextColor() {
        return this.textColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&HFFFFFFFF")
    @SimpleProperty
    public void TextColor(int argb) {
        this.textColor = argb;
        this.setAdapterData();
    }

    @SimpleProperty(description="The text size of the listview items.", category=PropertyCategory.APPEARANCE)
    public int TextSize() {
        return this.textSize;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="22")
    @SimpleProperty
    public void TextSize(int fontSize) {
        this.textSize = fontSize > 1000 ? 999 : fontSize;
        this.setAdapterData();
    }
}

