/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.InputMethodManager;
import android.widget.AdapterView;
import android.widget.ArrayAdapter;
import android.widget.EditText;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.ListView;
import android.widget.TextView;
import com.google.appinventor.components.runtime.ListPicker;
import com.google.appinventor.components.runtime.util.AnimationUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListPickerActivity
extends Activity
implements AdapterView.OnItemClickListener {
    private String closeAnim = "";
    private ListView listView;
    MyAdapter adapter;
    EditText txtSearchBox;
    static int itemColor;
    static int backgroundColor;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        LinearLayout viewLayout = new LinearLayout((Context)this);
        viewLayout.setOrientation(1);
        Intent myIntent = this.getIntent();
        if (myIntent.hasExtra(ListPicker.LIST_ACTIVITY_ANIM_TYPE)) {
            this.closeAnim = myIntent.getStringExtra(ListPicker.LIST_ACTIVITY_ANIM_TYPE);
        }
        if (myIntent.hasExtra(ListPicker.LIST_ACTIVITY_ORIENTATION_TYPE)) {
            String orientation = myIntent.getStringExtra(ListPicker.LIST_ACTIVITY_ORIENTATION_TYPE).toLowerCase();
            if (orientation.equals("portrait")) {
                this.setRequestedOrientation(1);
            } else if (orientation.equals("landscape")) {
                this.setRequestedOrientation(0);
            }
        }
        if (myIntent.hasExtra(ListPicker.LIST_ACTIVITY_TITLE)) {
            String title = myIntent.getStringExtra(ListPicker.LIST_ACTIVITY_TITLE);
            this.setTitle(title);
        }
        if (myIntent.hasExtra(ListPicker.LIST_ACTIVITY_ARG_NAME)) {
            String[] items = this.getIntent().getStringArrayExtra(ListPicker.LIST_ACTIVITY_ARG_NAME);
            this.listView = new ListView((Context)this);
            this.listView.setOnItemClickListener((AdapterView.OnItemClickListener)this);
            this.listView.setScrollingCacheEnabled(false);
            itemColor = myIntent.getIntExtra(ListPicker.LIST_ACTIVITY_ITEM_TEXT_COLOR, -1);
            backgroundColor = myIntent.getIntExtra(ListPicker.LIST_ACTIVITY_BACKGROUND_COLOR, -16777216);
            viewLayout.setBackgroundColor(backgroundColor);
            this.adapter = new MyAdapter((Context)this, items);
            this.listView.setAdapter((ListAdapter)this.adapter);
            String showFilterBar = myIntent.getStringExtra(ListPicker.LIST_ACTIVITY_SHOW_SEARCH_BAR);
            this.txtSearchBox = new EditText((Context)this);
            this.txtSearchBox.setSingleLine(true);
            this.txtSearchBox.setWidth(-2);
            this.txtSearchBox.setPadding(10, 10, 10, 10);
            this.txtSearchBox.setHint((CharSequence)"Search list...");
            if (showFilterBar == null || !showFilterBar.equalsIgnoreCase("true")) {
                this.txtSearchBox.setVisibility(8);
            }
            this.txtSearchBox.addTextChangedListener(new TextWatcher(){

                public void onTextChanged(CharSequence cs, int arg1, int arg2, int arg3) {
                    ListPickerActivity.this.adapter.getFilter().filter(cs);
                }

                public void beforeTextChanged(CharSequence arg0, int arg1, int arg2, int arg3) {
                }

                public void afterTextChanged(Editable arg0) {
                }
            });
        } else {
            this.setResult(0);
            this.finish();
            AnimationUtil.ApplyCloseScreenAnimation(this, this.closeAnim);
        }
        viewLayout.addView((View)this.txtSearchBox);
        viewLayout.addView((View)this.listView);
        this.setContentView((View)viewLayout);
        viewLayout.requestLayout();
        InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
        imm.hideSoftInputFromWindow(this.getWindow().getDecorView().getWindowToken(), 0);
        this.getWindow().setSoftInputMode(3);
    }

    public void onItemClick(AdapterView<?> parent, View view, int position, long id2) {
        String selected = (String)parent.getAdapter().getItem(position);
        Intent resultIntent = new Intent();
        resultIntent.putExtra(ListPicker.LIST_ACTIVITY_RESULT_NAME, selected);
        resultIntent.putExtra(ListPicker.LIST_ACTIVITY_RESULT_INDEX, position + 1);
        this.closeAnim = selected;
        this.setResult(-1, resultIntent);
        this.finish();
        AnimationUtil.ApplyCloseScreenAnimation(this, this.closeAnim);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            boolean handled = super.onKeyDown(keyCode, event);
            AnimationUtil.ApplyCloseScreenAnimation(this, this.closeAnim);
            return handled;
        }
        return super.onKeyDown(keyCode, event);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MyAdapter
    extends ArrayAdapter<String> {
        private final Context mContext;

        public MyAdapter(Context context, String[] items) {
            super(context, 0x1090000, (Object[])items);
            this.mContext = context;
        }

        public long getItemId(int position) {
            return ((String)this.getItem(position)).hashCode();
        }

        public View getView(int position, View convertView, ViewGroup parent) {
            TextView tv = (TextView)convertView;
            if (tv == null) {
                tv = (TextView)LayoutInflater.from((Context)this.mContext).inflate(17367043, parent, false);
            }
            tv.setText((CharSequence)this.getItem(position));
            tv.setTextColor(itemColor);
            return tv;
        }
    }
}

