/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.Layout;

@SimpleObject
public final class LinearLayout
implements Layout {
    private final android.widget.LinearLayout layoutManager;

    LinearLayout(Context context, int orientation) {
        this(context, orientation, null, null);
    }

    LinearLayout(Context context, int orientation, final Integer preferredEmptyWidth, final Integer preferredEmptyHeight) {
        if (preferredEmptyWidth == null && preferredEmptyHeight != null || preferredEmptyWidth != null && preferredEmptyHeight == null) {
            throw new IllegalArgumentException("LinearLayout - preferredEmptyWidth and preferredEmptyHeight must be either both null or both not null");
        }
        this.layoutManager = new android.widget.LinearLayout(context){

            protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
                if (preferredEmptyWidth == null || preferredEmptyHeight == null) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                    return;
                }
                if (this.getChildCount() != 0) {
                    super.onMeasure(widthMeasureSpec, heightMeasureSpec);
                    return;
                }
                this.setMeasuredDimension(this.getSize(widthMeasureSpec, preferredEmptyWidth), this.getSize(heightMeasureSpec, preferredEmptyHeight));
            }

            private int getSize(int measureSpec, int preferredSize) {
                int result;
                int specMode = View.MeasureSpec.getMode((int)measureSpec);
                int specSize = View.MeasureSpec.getSize((int)measureSpec);
                if (specMode == 0x40000000) {
                    result = specSize;
                } else {
                    result = preferredSize;
                    if (specMode == Integer.MIN_VALUE) {
                        result = Math.min(result, specSize);
                    }
                }
                return result;
            }
        };
        this.layoutManager.setOrientation(orientation == 0 ? 0 : 1);
    }

    public ViewGroup getLayoutManager() {
        return this.layoutManager;
    }

    public void add(AndroidViewComponent component) {
        this.layoutManager.addView(component.getView(), (ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-2, -2, 0.0f));
    }

    public void setHorizontalGravity(int gravity) {
        this.layoutManager.setHorizontalGravity(gravity);
    }

    public void setVerticalGravity(int gravity) {
        this.layoutManager.setVerticalGravity(gravity);
    }

    public void setBaselineAligned(boolean baselineAligned) {
        this.layoutManager.setBaselineAligned(baselineAligned);
    }
}

