/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.util.Log;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.BluetoothClient;
import com.google.appinventor.components.runtime.BluetoothConnectionBase;
import com.google.appinventor.components.runtime.BluetoothConnectionListener;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

@SimpleObject
public class LegoMindstormsNxtBase
extends AndroidNonvisibleComponent
implements BluetoothConnectionListener,
Component,
Deleteable {
    private static final int TOY_ROBOT = 2052;
    private static final Map<Integer, String> ERROR_MESSAGES = new HashMap<Integer, String>();
    protected final String logTag;
    protected BluetoothClient bluetooth;

    protected LegoMindstormsNxtBase(ComponentContainer container, String logTag) {
        super(container.$form());
        this.logTag = logTag;
    }

    protected LegoMindstormsNxtBase() {
        super(null);
        this.logTag = null;
    }

    public final void Initialize() {
    }

    @SimpleProperty(description="The BluetoothClient component that should be used for communication.", category=PropertyCategory.BEHAVIOR, userVisible=false)
    public BluetoothClient BluetoothClient() {
        return this.bluetooth;
    }

    @DesignerProperty(editorType="BluetoothClient", defaultValue="")
    @SimpleProperty(userVisible=false)
    public void BluetoothClient(BluetoothClient bluetoothClient) {
        if (this.bluetooth != null) {
            this.bluetooth.removeBluetoothConnectionListener(this);
            this.bluetooth.detachComponent(this);
            this.bluetooth = null;
        }
        if (bluetoothClient != null) {
            this.bluetooth = bluetoothClient;
            this.bluetooth.attachComponent(this, Collections.singleton(2052));
            this.bluetooth.addBluetoothConnectionListener(this);
            if (this.bluetooth.IsConnected()) {
                this.afterConnect(this.bluetooth);
            }
        }
    }

    protected final void setOutputState(String functionName, int port, int power, int mode, int regulationMode, int turnRatio, int runState, long tachoLimit) {
        power = this.sanitizePower(power);
        byte[] command = new byte[12];
        command[0] = -128;
        command[1] = 4;
        this.copyUBYTEValueToBytes(port, command, 2);
        this.copySBYTEValueToBytes(power, command, 3);
        this.copyUBYTEValueToBytes(mode, command, 4);
        this.copyUBYTEValueToBytes(regulationMode, command, 5);
        this.copySBYTEValueToBytes(turnRatio, command, 6);
        this.copyUBYTEValueToBytes(runState, command, 7);
        this.copyULONGValueToBytes(tachoLimit, command, 8);
        this.sendCommand(functionName, command);
    }

    protected final void setInputMode(String functionName, int port, int sensorType, int sensorMode) {
        byte[] command = new byte[5];
        command[0] = -128;
        command[1] = 5;
        this.copyUBYTEValueToBytes(port, command, 2);
        this.copyUBYTEValueToBytes(sensorType, command, 3);
        this.copyUBYTEValueToBytes(sensorMode, command, 4);
        this.sendCommand(functionName, command);
    }

    protected final byte[] getInputValues(String functionName, int port) {
        byte[] command = new byte[3];
        command[0] = 0;
        command[1] = 7;
        this.copyUBYTEValueToBytes(port, command, 2);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 16) {
                return returnPackage;
            }
            Log.w((String)this.logTag, (String)(functionName + ": unexpected return package length " + returnPackage.length + " (expected 16)"));
        }
        return null;
    }

    protected final void resetInputScaledValue(String functionName, int port) {
        byte[] command = new byte[3];
        command[0] = -128;
        command[1] = 8;
        this.copyUBYTEValueToBytes(port, command, 2);
        this.sendCommand(functionName, command);
    }

    protected final int lsGetStatus(String functionName, int port) {
        byte[] command = new byte[3];
        command[0] = 0;
        command[1] = 14;
        this.copyUBYTEValueToBytes(port, command, 2);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 4) {
                return this.getUBYTEValueFromBytes(returnPackage, 3);
            }
            Log.w((String)this.logTag, (String)(functionName + ": unexpected return package length " + returnPackage.length + " (expected 4)"));
        }
        return 0;
    }

    protected final void lsWrite(String functionName, int port, byte[] data, int rxDataLength) {
        if (data.length > 16) {
            throw new IllegalArgumentException("length must be <= 16");
        }
        byte[] command = new byte[5 + data.length];
        command[0] = 0;
        command[1] = 15;
        this.copyUBYTEValueToBytes(port, command, 2);
        this.copyUBYTEValueToBytes(data.length, command, 3);
        this.copyUBYTEValueToBytes(rxDataLength, command, 4);
        System.arraycopy(data, 0, command, 5, data.length);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        this.evaluateStatus(functionName, returnPackage, command[1]);
    }

    protected final byte[] lsRead(String functionName, int port) {
        byte[] command = new byte[3];
        command[0] = 0;
        command[1] = 16;
        this.copyUBYTEValueToBytes(port, command, 2);
        byte[] returnPackage = this.sendCommandAndReceiveReturnPackage(functionName, command);
        if (this.evaluateStatus(functionName, returnPackage, command[1])) {
            if (returnPackage.length == 20) {
                return returnPackage;
            }
            Log.w((String)this.logTag, (String)(functionName + ": unexpected return package length " + returnPackage.length + " (expected 20)"));
        }
        return null;
    }

    protected final boolean checkBluetooth(String functionName) {
        if (this.bluetooth == null) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 401, new Object[0]);
            return false;
        }
        if (!this.bluetooth.IsConnected()) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 402, new Object[0]);
            return false;
        }
        return true;
    }

    protected final byte[] sendCommandAndReceiveReturnPackage(String functionName, byte[] command) {
        this.sendCommand(functionName, command);
        return this.receiveReturnPackage(functionName);
    }

    protected final void sendCommand(String functionName, byte[] command) {
        byte[] header = new byte[2];
        this.copyUWORDValueToBytes(command.length, header, 0);
        this.bluetooth.write(functionName, header);
        this.bluetooth.write(functionName, command);
    }

    private byte[] receiveReturnPackage(String functionName) {
        int length;
        byte[] returnPackage;
        byte[] header = this.bluetooth.read(functionName, 2);
        if (header.length == 2 && (returnPackage = this.bluetooth.read(functionName, length = this.getUWORDValueFromBytes(header, 0))).length >= 3) {
            return returnPackage;
        }
        this.form.dispatchErrorOccurredEvent(this, functionName, 403, new Object[0]);
        return new byte[0];
    }

    protected final boolean evaluateStatus(String functionName, byte[] returnPackage, byte command) {
        int status = this.getStatus(functionName, returnPackage, command);
        if (status == 0) {
            return true;
        }
        this.handleError(functionName, status);
        return false;
    }

    protected final int getStatus(String functionName, byte[] returnPackage, byte command) {
        if (returnPackage.length >= 3) {
            if (returnPackage[0] != 2) {
                Log.w((String)this.logTag, (String)(functionName + ": unexpected return package byte 0: 0x" + Integer.toHexString(returnPackage[0] & 0xFF) + " (expected 0x02)"));
            }
            if (returnPackage[1] != command) {
                Log.w((String)this.logTag, (String)(functionName + ": unexpected return package byte 1: 0x" + Integer.toHexString(returnPackage[1] & 0xFF) + " (expected 0x" + Integer.toHexString(command & 0xFF) + ")"));
            }
            return this.getUBYTEValueFromBytes(returnPackage, 2);
        }
        Log.w((String)this.logTag, (String)(functionName + ": unexpected return package length " + returnPackage.length + " (expected >= 3)"));
        return -1;
    }

    private void handleError(String functionName, int status) {
        if (status >= 0) {
            String errorMessage = ERROR_MESSAGES.get(status);
            if (errorMessage != null) {
                this.form.dispatchErrorOccurredEvent(this, functionName, 404, errorMessage);
            } else {
                this.form.dispatchErrorOccurredEvent(this, functionName, 404, "Error code 0x" + Integer.toHexString(status & 0xFF));
            }
        }
    }

    protected final void copyBooleanValueToBytes(boolean value, byte[] bytes, int offset) {
        bytes[offset] = value ? (byte)1 : 0;
    }

    protected final void copySBYTEValueToBytes(int value, byte[] bytes, int offset) {
        bytes[offset] = (byte)value;
    }

    protected final void copyUBYTEValueToBytes(int value, byte[] bytes, int offset) {
        bytes[offset] = (byte)value;
    }

    protected final void copySWORDValueToBytes(int value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value & 0xFF);
        bytes[offset + 1] = (byte)((value >>= 8) & 0xFF);
    }

    protected final void copyUWORDValueToBytes(int value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value & 0xFF);
        bytes[offset + 1] = (byte)((value >>= 8) & 0xFF);
    }

    protected final void copySLONGValueToBytes(int value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value & 0xFF);
        bytes[offset + 1] = (byte)((value >>= 8) & 0xFF);
        bytes[offset + 2] = (byte)((value >>= 8) & 0xFF);
        bytes[offset + 3] = (byte)((value >>= 8) & 0xFF);
    }

    protected final void copyULONGValueToBytes(long value, byte[] bytes, int offset) {
        bytes[offset] = (byte)(value & 0xFFL);
        bytes[offset + 1] = (byte)((value >>= 8) & 0xFFL);
        bytes[offset + 2] = (byte)((value >>= 8) & 0xFFL);
        bytes[offset + 3] = (byte)((value >>= 8) & 0xFFL);
    }

    protected final void copyStringValueToBytes(String value, byte[] bytes, int offset, int maxCount) {
        byte[] valueBytes;
        if (value.length() > maxCount) {
            value = value.substring(0, maxCount);
        }
        try {
            valueBytes = value.getBytes("ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Log.w((String)this.logTag, (String)("UnsupportedEncodingException: " + e.getMessage()));
            valueBytes = value.getBytes();
        }
        int lengthToCopy = Math.min(maxCount, valueBytes.length);
        System.arraycopy(valueBytes, 0, bytes, offset, lengthToCopy);
    }

    protected final boolean getBooleanValueFromBytes(byte[] bytes, int offset) {
        return bytes[offset] != 0;
    }

    protected final int getSBYTEValueFromBytes(byte[] bytes, int offset) {
        return bytes[offset];
    }

    protected final int getUBYTEValueFromBytes(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF;
    }

    protected final int getSWORDValueFromBytes(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | bytes[offset + 1] << 8;
    }

    protected final int getUWORDValueFromBytes(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8;
    }

    protected final int getSLONGValueFromBytes(byte[] bytes, int offset) {
        return bytes[offset] & 0xFF | (bytes[offset + 1] & 0xFF) << 8 | (bytes[offset + 2] & 0xFF) << 16 | bytes[offset + 3] << 24;
    }

    protected final long getULONGValueFromBytes(byte[] bytes, int offset) {
        return (long)bytes[offset] & 0xFFL | ((long)bytes[offset + 1] & 0xFFL) << 8 | ((long)bytes[offset + 2] & 0xFFL) << 16 | ((long)bytes[offset + 3] & 0xFFL) << 24;
    }

    protected final String getStringValueFromBytes(byte[] bytes, int offset) {
        int length = 0;
        for (int i = offset; i < bytes.length; ++i) {
            if (bytes[i] != 0) continue;
            length = i - offset;
            break;
        }
        return this.getStringValueFromBytes(bytes, offset, length);
    }

    protected final String getStringValueFromBytes(byte[] bytes, int offset, int count) {
        try {
            return new String(bytes, offset, count, "ISO-8859-1");
        }
        catch (UnsupportedEncodingException e) {
            Log.w((String)this.logTag, (String)("UnsupportedEncodingException: " + e.getMessage()));
            return new String(bytes, offset, count);
        }
    }

    protected final int convertMotorPortLetterToNumber(String motorPortLetter) {
        if (motorPortLetter.length() == 1) {
            return this.convertMotorPortLetterToNumber(motorPortLetter.charAt(0));
        }
        throw new IllegalArgumentException("Illegal motor port letter " + motorPortLetter);
    }

    protected final int convertMotorPortLetterToNumber(char motorPortLetter) {
        if (motorPortLetter == 'A' || motorPortLetter == 'a') {
            return 0;
        }
        if (motorPortLetter == 'B' || motorPortLetter == 'b') {
            return 1;
        }
        if (motorPortLetter == 'C' || motorPortLetter == 'c') {
            return 2;
        }
        throw new IllegalArgumentException("Illegal motor port letter " + motorPortLetter);
    }

    protected final int convertSensorPortLetterToNumber(String sensorPortLetter) {
        if (sensorPortLetter.length() == 1) {
            return this.convertSensorPortLetterToNumber(sensorPortLetter.charAt(0));
        }
        throw new IllegalArgumentException("Illegal sensor port letter " + sensorPortLetter);
    }

    protected final int convertSensorPortLetterToNumber(char sensorPortLetter) {
        if (sensorPortLetter == '1') {
            return 0;
        }
        if (sensorPortLetter == '2') {
            return 1;
        }
        if (sensorPortLetter == '3') {
            return 2;
        }
        if (sensorPortLetter == '4') {
            return 3;
        }
        throw new IllegalArgumentException("Illegal sensor port letter " + sensorPortLetter);
    }

    protected final int sanitizePower(int power) {
        if (power < -100) {
            Log.w((String)this.logTag, (String)("power " + power + " is invalid, using -100."));
            power = -100;
        }
        if (power > 100) {
            Log.w((String)this.logTag, (String)("power " + power + " is invalid, using 100."));
            power = 100;
        }
        return power;
    }

    protected final int sanitizeTurnRatio(int turnRatio) {
        if (turnRatio < -100) {
            Log.w((String)this.logTag, (String)("turnRatio " + turnRatio + " is invalid, using -100."));
            turnRatio = -100;
        }
        if (turnRatio > 100) {
            Log.w((String)this.logTag, (String)("turnRatio " + turnRatio + " is invalid, using 100."));
            turnRatio = 100;
        }
        return turnRatio;
    }

    public void afterConnect(BluetoothConnectionBase bluetoothConnection) {
    }

    public void beforeDisconnect(BluetoothConnectionBase bluetoothConnection) {
    }

    public void onDelete() {
        if (this.bluetooth != null) {
            this.bluetooth.removeBluetoothConnectionListener(this);
            this.bluetooth.detachComponent(this);
            this.bluetooth = null;
        }
    }

    static {
        ERROR_MESSAGES.put(32, "Pending communication transaction in progress");
        ERROR_MESSAGES.put(64, "Specified mailbox queue is empty");
        ERROR_MESSAGES.put(129, "No more handles");
        ERROR_MESSAGES.put(130, "No space");
        ERROR_MESSAGES.put(131, "No more files");
        ERROR_MESSAGES.put(132, "End of file expected");
        ERROR_MESSAGES.put(133, "End of file");
        ERROR_MESSAGES.put(134, "Not a linear file");
        ERROR_MESSAGES.put(135, "File not found");
        ERROR_MESSAGES.put(136, "Handle already closed");
        ERROR_MESSAGES.put(137, "No linear space");
        ERROR_MESSAGES.put(138, "Undefined error");
        ERROR_MESSAGES.put(139, "File is busy");
        ERROR_MESSAGES.put(140, "No write buffers");
        ERROR_MESSAGES.put(141, "Append not possible");
        ERROR_MESSAGES.put(142, "File is full");
        ERROR_MESSAGES.put(143, "File exists");
        ERROR_MESSAGES.put(144, "Module not found");
        ERROR_MESSAGES.put(145, "Out of boundary");
        ERROR_MESSAGES.put(146, "Illegal file name");
        ERROR_MESSAGES.put(147, "Illegal handle");
        ERROR_MESSAGES.put(189, "Request failed (i.e. specified file not found)");
        ERROR_MESSAGES.put(190, "Unknown command opcode");
        ERROR_MESSAGES.put(191, "Insane packet");
        ERROR_MESSAGES.put(192, "Data contains out-of-range values");
        ERROR_MESSAGES.put(221, "Communication bus error");
        ERROR_MESSAGES.put(222, "No free memory in communication buffer");
        ERROR_MESSAGES.put(223, "Specified channel/connection is not valid");
        ERROR_MESSAGES.put(224, "Specified channel/connection not configured or busy");
        ERROR_MESSAGES.put(236, "No active program");
        ERROR_MESSAGES.put(237, "Illegal size specified");
        ERROR_MESSAGES.put(238, "Illegal mailbox queue ID specified");
        ERROR_MESSAGES.put(239, "Attempted to access invalid field of a structure");
        ERROR_MESSAGES.put(240, "Bad input or output specified");
        ERROR_MESSAGES.put(251, "Insufficient memory available");
        ERROR_MESSAGES.put(255, "Bad arguments");
    }
}

