/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.LegoMindstormsEv3Base;
import com.google.appinventor.components.runtime.util.Ev3BinaryParser;

@SimpleObject
public class LegoMindstormsEv3Sensor
extends LegoMindstormsEv3Base {
    protected static final String DEFAULT_SENSOR_PORT = "1";
    protected int sensorPortNumber;

    protected LegoMindstormsEv3Sensor(ComponentContainer container, String logTag) {
        super(container, logTag);
        this.SensorPort(DEFAULT_SENSOR_PORT);
    }

    @SimpleProperty(description="The sensor port that the sensor is connected to.", category=PropertyCategory.BEHAVIOR, userVisible=false)
    public String SensorPort() {
        return this.portNumberToSensorPortLetter(this.sensorPortNumber);
    }

    @DesignerProperty(editorType="lego_ev3_sensor_port", defaultValue="1")
    @SimpleProperty
    public void SensorPort(String sensorPortLetter) {
        String functionName = "SensorPort";
        this.setSensorPort(functionName, sensorPortLetter);
    }

    protected final void setSensorPort(String functionName, String sensorPortLetter) {
        try {
            this.sensorPortNumber = this.sensorPortLetterToPortNumber(sensorPortLetter);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3105, sensorPortLetter);
            return;
        }
    }

    protected final int readInputPercentage(String functionName, int layer, int no, int type, int mode) {
        if (layer < 0 || layer > 3 || no < 0 || no > 3 || mode < -1 || mode > 7) {
            throw new IllegalArgumentException();
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-103, true, 1, 0, "ccccccg", (byte)27, (byte)layer, (byte)no, (byte)type, (byte)mode, (byte)1, (byte)0);
        byte[] reply = this.sendCommand(functionName, command, true);
        if (reply != null && reply.length == 2 && reply[0] == 2) {
            return reply[1];
        }
        return -1;
    }

    protected final double readInputSI(String functionName, int layer, int no, int type, int mode) {
        if (layer < 0 || layer > 3 || no < 0 || no > 3 || mode < -1 || mode > 7) {
            throw new IllegalArgumentException();
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-103, true, 4, 0, "ccccccg", (byte)29, (byte)layer, (byte)no, (byte)type, (byte)mode, (byte)1, (byte)0);
        byte[] reply = this.sendCommand(functionName, command, true);
        if (reply != null && reply.length == 5 && reply[0] == 2) {
            Object[] values = Ev3BinaryParser.unpack("xf", reply);
            return ((Float)values[0]).floatValue();
        }
        this.form.dispatchErrorOccurredEvent(this, functionName, 3102, new Object[0]);
        return -1.0;
    }
}

