/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.BluetoothClient;
import com.google.appinventor.components.runtime.BluetoothConnectionBase;
import com.google.appinventor.components.runtime.BluetoothConnectionListener;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.util.Ev3BinaryParser;
import java.util.Collections;

@SimpleObject
public class LegoMindstormsEv3Base
extends AndroidNonvisibleComponent
implements BluetoothConnectionListener,
Component,
Deleteable {
    private static final int TOY_ROBOT = 2052;
    protected int commandCount;
    protected final String logTag;
    protected BluetoothClient bluetooth;

    protected LegoMindstormsEv3Base(ComponentContainer container, String logTag) {
        super(container.$form());
        this.logTag = logTag;
    }

    protected LegoMindstormsEv3Base() {
        super(null);
        this.logTag = null;
    }

    @SimpleProperty(description="The BluetoothClient component that should be used for communication.", category=PropertyCategory.BEHAVIOR)
    public BluetoothClient BluetoothClient() {
        return this.bluetooth;
    }

    @DesignerProperty(editorType="BluetoothClient", defaultValue="")
    @SimpleProperty
    public void BluetoothClient(BluetoothClient bluetoothClient) {
        if (this.bluetooth != null) {
            this.bluetooth.removeBluetoothConnectionListener(this);
            this.bluetooth.detachComponent(this);
            this.bluetooth = null;
        }
        if (bluetoothClient != null) {
            this.bluetooth = bluetoothClient;
            this.bluetooth.attachComponent(this, Collections.singleton(2052));
            this.bluetooth.addBluetoothConnectionListener(this);
            if (this.bluetooth.IsConnected()) {
                this.afterConnect(this.bluetooth);
            }
        }
    }

    protected final boolean isBluetoothConnected(String functionName) {
        if (this.bluetooth == null) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3100, new Object[0]);
            return false;
        }
        if (!this.bluetooth.IsConnected()) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3101, new Object[0]);
            return false;
        }
        return true;
    }

    protected final byte[] sendCommand(String functionName, byte[] command, boolean doReceiveReply) {
        if (!this.isBluetoothConnected(functionName)) {
            return null;
        }
        byte[] header = Ev3BinaryParser.pack("hh", (short)(command.length + 2), (short)this.commandCount);
        ++this.commandCount;
        this.bluetooth.write(functionName, header);
        this.bluetooth.write(functionName, command);
        if (doReceiveReply) {
            header = this.bluetooth.read(functionName, 4);
            if (header.length == 4) {
                Object[] decodedHeader = Ev3BinaryParser.unpack("hh", header);
                int replySize = (Short)decodedHeader[0] - 2;
                short replyCount = (Short)decodedHeader[1];
                byte[] reply = this.bluetooth.read(functionName, replySize);
                if (reply.length == replySize) {
                    return reply;
                }
                this.form.dispatchErrorOccurredEvent(this, functionName, 3102, new Object[0]);
                return null;
            }
            this.form.dispatchErrorOccurredEvent(this, functionName, 3102, new Object[0]);
            return null;
        }
        return null;
    }

    protected final int sensorPortLetterToPortNumber(String letter) {
        if (letter.length() != 1) {
            throw new IllegalArgumentException("String \"" + letter + "\" is not a valid sensor port letter");
        }
        int portNumber = letter.charAt(0) - 49;
        if (portNumber < 0 || portNumber > 3) {
            throw new IllegalArgumentException("String \"" + letter + "\" is not a valid sensor port letter");
        }
        return portNumber;
    }

    protected final String portNumberToSensorPortLetter(int portNumber) {
        if (portNumber < 0 || portNumber > 3) {
            throw new IllegalArgumentException(portNumber + " is not a valid port number");
        }
        return "" + (49 + portNumber);
    }

    protected final int motorPortLettersToBitField(String letters) {
        if (letters.length() > 4) {
            throw new IllegalArgumentException("Malformed motor port letters \"" + letters + "\"");
        }
        boolean portABit = false;
        int portBBit = 0;
        int portCBit = 0;
        int portDBit = 0;
        block6: for (int i = 0; i < letters.length(); ++i) {
            switch (letters.charAt(i)) {
                case 'A': {
                    if (portABit) {
                        throw new IllegalArgumentException("Malformed motor port letters \"" + letters + "\"");
                    }
                    portABit = true;
                    continue block6;
                }
                case 'B': {
                    if (portBBit != 0) {
                        throw new IllegalArgumentException("Malformed motor port letters \"" + letters + "\"");
                    }
                    portBBit = 2;
                    continue block6;
                }
                case 'C': {
                    if (portCBit != 0) {
                        throw new IllegalArgumentException("Malformed motor port letters \"" + letters + "\"");
                    }
                    portCBit = 4;
                    continue block6;
                }
                case 'D': {
                    if (portDBit != 0) {
                        throw new IllegalArgumentException("Malformed motor port letters \"" + letters + "\"");
                    }
                    portDBit = 8;
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("Malformed motor port letters \"" + letters + "\"");
                }
            }
        }
        return portABit | portBBit | portCBit | portDBit;
    }

    protected final String bitFieldToMotorPortLetters(int bitField) {
        if (bitField < 0 || bitField > 15) {
            throw new IllegalArgumentException("Invalid bit field number " + bitField);
        }
        String portLetters = "";
        if ((bitField & 1) != 0) {
            portLetters = portLetters + "A";
        }
        if ((bitField & 2) != 0) {
            portLetters = portLetters + "B";
        }
        if ((bitField & 4) != 0) {
            portLetters = portLetters + "C";
        }
        if ((bitField & 8) != 0) {
            portLetters = portLetters + "D";
        }
        return portLetters;
    }

    public void afterConnect(BluetoothConnectionBase bluetoothConnection) {
    }

    public void beforeDisconnect(BluetoothConnectionBase bluetoothConnection) {
    }

    public void onDelete() {
        if (this.bluetooth != null) {
            this.bluetooth.removeBluetoothConnectionListener(this);
            this.bluetooth.detachComponent(this);
            this.bluetooth = null;
        }
    }
}

