/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.util.TextViewUtil;

@DesignerComponent(version=4, description="A Label displays a piece of text, which is specified through the <code>Text</code> property.  Other properties, all of which can be set in the Designer or Blocks Editor, control the appearance and placement of the text.", category=ComponentCategory.USERINTERFACE)
@SimpleObject
public final class Label
extends AndroidViewComponent {
    private static final int DEFAULT_LABEL_MARGIN = 2;
    private int defaultLabelMarginInDp = 0;
    private final TextView view;
    private final LinearLayout.LayoutParams linearLayoutParams;
    private int textAlignment;
    private int backgroundColor;
    private int fontTypeface;
    private boolean bold;
    private boolean italic;
    private boolean hasMargins;
    private int textColor;
    private boolean htmlFormat;

    public Label(ComponentContainer container) {
        super(container);
        this.view = new TextView((Context)container.$context());
        container.$add(this);
        ViewGroup.LayoutParams lp = this.view.getLayoutParams();
        if (lp instanceof LinearLayout.LayoutParams) {
            this.linearLayoutParams = (LinearLayout.LayoutParams)lp;
            this.defaultLabelMarginInDp = Label.dpToPx((View)this.view, 2);
        } else {
            this.defaultLabelMarginInDp = 0;
            this.linearLayoutParams = null;
            Log.e((String)"Label", (String)"Error: The label's view does not have linear layout parameters");
            new RuntimeException().printStackTrace();
        }
        this.TextAlignment(0);
        this.BackgroundColor(0xFFFFFF);
        this.fontTypeface = 0;
        TextViewUtil.setFontTypeface(this.view, this.fontTypeface, this.bold, this.italic);
        this.FontSize(14.0f);
        this.Text("");
        this.TextColor(-16777216);
        this.HTMLFormat(false);
        this.HasMargins(true);
    }

    private static int dpToPx(View view, int dp) {
        float density = view.getContext().getResources().getDisplayMetrics().density;
        return Math.round((float)dp * density);
    }

    public View getView() {
        return this.view;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, userVisible=false)
    public int TextAlignment() {
        return this.textAlignment;
    }

    @DesignerProperty(editorType="textalignment", defaultValue="0")
    @SimpleProperty(userVisible=false)
    public void TextAlignment(int alignment) {
        this.textAlignment = alignment;
        TextViewUtil.setAlignment(this.view, alignment, false);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public int BackgroundColor() {
        return this.backgroundColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&H00FFFFFF")
    @SimpleProperty
    public void BackgroundColor(int argb) {
        this.backgroundColor = argb;
        if (argb != 0) {
            TextViewUtil.setBackgroundColor(this.view, argb);
        } else {
            TextViewUtil.setBackgroundColor(this.view, 0xFFFFFF);
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, userVisible=false)
    public boolean FontBold() {
        return this.bold;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(userVisible=false)
    public void FontBold(boolean bold) {
        this.bold = bold;
        TextViewUtil.setFontTypeface(this.view, this.fontTypeface, bold, this.italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, userVisible=false)
    public boolean FontItalic() {
        return this.italic;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(userVisible=false)
    public void FontItalic(boolean italic) {
        this.italic = italic;
        TextViewUtil.setFontTypeface(this.view, this.fontTypeface, this.bold, italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Reports whether or not the label appears with margins.  All four margins (left, right, top, bottom) are the same.  This property has no effect in the designer, where labels are always shown with margins.", userVisible=true)
    public boolean HasMargins() {
        return this.hasMargins;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty(userVisible=true)
    public void HasMargins(boolean hasMargins) {
        this.hasMargins = hasMargins;
        this.setLabelMargins(hasMargins);
    }

    private void setLabelMargins(boolean hasMargins) {
        int m = hasMargins ? this.defaultLabelMarginInDp : 0;
        this.linearLayoutParams.setMargins(m, m, m, m);
        this.view.invalidate();
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public float FontSize() {
        return TextViewUtil.getFontSize(this.view, (Context)this.container.$context());
    }

    @DesignerProperty(editorType="non_negative_float", defaultValue="14.0")
    @SimpleProperty
    public void FontSize(float size) {
        TextViewUtil.setFontSize(this.view, size);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, userVisible=false)
    public int FontTypeface() {
        return this.fontTypeface;
    }

    @DesignerProperty(editorType="typeface", defaultValue="0")
    @SimpleProperty(userVisible=false)
    public void FontTypeface(int typeface) {
        this.fontTypeface = typeface;
        TextViewUtil.setFontTypeface(this.view, this.fontTypeface, this.bold, this.italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public String Text() {
        return TextViewUtil.getText(this.view);
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void Text(String text) {
        if (this.htmlFormat) {
            TextViewUtil.setTextHTML(this.view, text);
        } else {
            TextViewUtil.setText(this.view, text);
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="If true, then this label will show html text else it will show plain text. Note: Not all HTML is supported.")
    public boolean HTMLFormat() {
        return this.htmlFormat;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(userVisible=false)
    public void HTMLFormat(boolean fmt) {
        this.htmlFormat = fmt;
        if (this.htmlFormat) {
            String txt = TextViewUtil.getText(this.view);
            TextViewUtil.setTextHTML(this.view, txt);
        } else {
            String txt = TextViewUtil.getText(this.view);
            TextViewUtil.setText(this.view, txt);
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public int TextColor() {
        return this.textColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&HFF000000")
    @SimpleProperty
    public void TextColor(int argb) {
        this.textColor = argb;
        if (argb != 0) {
            TextViewUtil.setTextColor(this.view, argb);
        } else {
            TextViewUtil.setTextColor(this.view, -16777216);
        }
    }
}

