/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.ContentResolver;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.provider.MediaStore;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ActivityResultListener;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Picker;
import com.google.appinventor.components.runtime.util.MediaUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;

@DesignerComponent(version=5, description="A special-purpose button. When the user taps an image picker, the device's image gallery appears, and the user can choose an image. After an image is picked, it is saved, and the <code>Selected</code> property will be the name of the file where the image is stored. In order to not fill up storage, a maximum of 10 images will be stored.  Picking more images will delete previous images, in order from oldest to newest.", category=ComponentCategory.MEDIA)
@UsesPermissions(permissionNames="android.permission.WRITE_EXTERNAL_STORAGE")
@SimpleObject
public class ImagePicker
extends Picker
implements ActivityResultListener {
    private static final String LOG_TAG = "ImagePicker";
    private static final String imagePickerDirectoryName = "/Pictures/_app_inventor_image_picker";
    private static final String FILE_PREFIX = "picked_image";
    private static int maxSavedFiles = 10;
    private String selectionURI;
    private String selectionSavedImage = "";

    public ImagePicker(ComponentContainer container) {
        super(container);
    }

    @SimpleProperty(description="Path to the file containing the image that was selected.", category=PropertyCategory.BEHAVIOR)
    public String Selection() {
        return this.selectionSavedImage;
    }

    protected Intent getIntent() {
        return new Intent("android.intent.action.PICK", MediaStore.Images.Media.INTERNAL_CONTENT_URI);
    }

    public void resultReturned(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.requestCode && resultCode == -1) {
            Uri selectedImage = data.getData();
            this.selectionURI = selectedImage.toString();
            Log.i((String)LOG_TAG, (String)("selectionURI = " + this.selectionURI));
            ContentResolver cR = this.container.$context().getContentResolver();
            MimeTypeMap mime = MimeTypeMap.getSingleton();
            String extension = "." + mime.getExtensionFromMimeType(cR.getType(selectedImage));
            Log.i((String)LOG_TAG, (String)("extension = " + extension));
            this.saveSelectedImageToExternalStorage(extension);
            this.AfterPicking();
        }
    }

    private void saveSelectedImageToExternalStorage(String extension) {
        this.selectionSavedImage = "";
        File tempFile = null;
        try {
            tempFile = MediaUtil.copyMediaToTempFile(this.container.$form(), this.selectionURI);
        }
        catch (IOException e) {
            Log.i((String)LOG_TAG, (String)("copyMediaToTempFile failed: " + e.getMessage()));
            this.container.$form().dispatchErrorOccurredEvent(this, LOG_TAG, 1602, e.getMessage());
            return;
        }
        Log.i((String)LOG_TAG, (String)("temp file path is: " + tempFile.getPath()));
        this.copyToExternalStorageAndDeleteSource(tempFile, extension);
    }

    private void copyToExternalStorageAndDeleteSource(File source, String extension) {
        File dest = null;
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        String fullDirname = Environment.getExternalStorageDirectory() + imagePickerDirectoryName;
        File destDirectory = new File(fullDirname);
        try {
            int length;
            destDirectory.mkdirs();
            dest = File.createTempFile(FILE_PREFIX, extension, destDirectory);
            this.selectionSavedImage = dest.getPath();
            Log.i((String)LOG_TAG, (String)("saved file path is: " + this.selectionSavedImage));
            inStream = new FileInputStream(source);
            outStream = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                ((OutputStream)outStream).write(buffer, 0, length);
            }
            ((InputStream)inStream).close();
            ((OutputStream)outStream).close();
            Log.i((String)LOG_TAG, (String)("Image was copied to " + this.selectionSavedImage));
        }
        catch (IOException e) {
            String err = "destination is " + this.selectionSavedImage + ": " + "error is " + e.getMessage();
            Log.i((String)LOG_TAG, (String)("copyFile failed. " + err));
            this.container.$form().dispatchErrorOccurredEvent(this, "SaveImage", 1601, err);
            this.selectionSavedImage = "";
            dest.delete();
        }
        source.delete();
        this.trimDirectory(maxSavedFiles, destDirectory);
    }

    private void trimDirectory(int maxSavedFiles, File directory) {
        File[] files = directory.listFiles();
        Arrays.sort(files, new Comparator<File>(){

            @Override
            public int compare(File f1, File f2) {
                return Long.valueOf(f1.lastModified()).compareTo(f2.lastModified());
            }
        });
        int excess = files.length - maxSavedFiles;
        for (int i = 0; i < excess; ++i) {
            files[i].delete();
        }
    }
}

