/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.errors.IllegalArgumentError;
import com.google.appinventor.components.runtime.util.AnimationUtil;
import com.google.appinventor.components.runtime.util.HoneycombUtil;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.ViewUtil;
import java.io.IOException;

@DesignerComponent(version=3, category=ComponentCategory.USERINTERFACE, description="Component for displaying images.  The picture to display, and other aspects of the Image's appearance, can be specified in the Designer or in the Blocks Editor.")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET")
public final class Image
extends AndroidViewComponent {
    private final ImageView view;
    private String picturePath = "";
    private double rotationAngle = 0.0;
    private int scalingMode = 0;

    public Image(ComponentContainer container) {
        super(container);
        this.view = new ImageView((Context)container.$context()){

            public boolean verifyDrawable(Drawable dr) {
                super.verifyDrawable(dr);
                return true;
            }
        };
        this.view.setFocusable(true);
        container.$add(this);
    }

    public View getView() {
        return this.view;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public String Picture() {
        return this.picturePath;
    }

    @DesignerProperty(editorType="asset", defaultValue="")
    @SimpleProperty
    public void Picture(String path) {
        BitmapDrawable drawable2;
        this.picturePath = path == null ? "" : path;
        try {
            drawable2 = MediaUtil.getBitmapDrawable(this.container.$form(), this.picturePath);
        }
        catch (IOException ioe) {
            Log.e((String)"Image", (String)("Unable to load " + this.picturePath));
            drawable2 = null;
        }
        ViewUtil.setImage(this.view, (Drawable)drawable2);
    }

    @DesignerProperty(editorType="float", defaultValue="0.0")
    @SimpleProperty
    public void RotationAngle(double rotationAngle) {
        if (this.rotationAngle == rotationAngle) {
            return;
        }
        if (SdkLevel.getLevel() < 11) {
            this.container.$form().dispatchErrorOccurredEvent(this, "RotationAngle", 3001, new Object[0]);
            return;
        }
        HoneycombUtil.viewSetRotate((View)this.view, rotationAngle);
        this.rotationAngle = rotationAngle;
    }

    @SimpleProperty(description="The angle at which the image picture appears rotated. This rotation does not appear on the designer screen, only on the device.", category=PropertyCategory.APPEARANCE)
    public double RotationAngle() {
        return this.rotationAngle;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(description="Specifies whether the image should be resized to match the size of the ImageView.")
    public void ScalePictureToFit(boolean scale) {
        if (scale) {
            this.view.setScaleType(ImageView.ScaleType.FIT_XY);
        } else {
            this.view.setScaleType(ImageView.ScaleType.FIT_CENTER);
        }
    }

    @SimpleProperty(description="This is a limited form of animation that can attach a small number of motion types to images.  The allowable motions are ScrollRightSlow, ScrollRight, ScrollRightFast, ScrollLeftSlow, ScrollLeft, ScrollLeftFast, and Stop", category=PropertyCategory.APPEARANCE)
    public void Animation(String animation) {
        AnimationUtil.ApplyAnimation((View)this.view, animation);
    }

    @Deprecated
    @SimpleProperty(description="This property determines how the picture scales according to the Height or Width of the Image. Scale proportionally (0) preserves the picture aspect ratio. Scale to fit (1) matches the Image area, even if the aspect ratio changes.")
    public void Scaling(int mode) {
        switch (mode) {
            case 0: {
                this.view.setScaleType(ImageView.ScaleType.FIT_CENTER);
                break;
            }
            case 1: {
                this.view.setScaleType(ImageView.ScaleType.FIT_XY);
                break;
            }
            default: {
                throw new IllegalArgumentError("Illegal scaling mode: " + mode);
            }
        }
        this.scalingMode = mode;
    }

    @SimpleProperty
    public int Scaling() {
        return this.scalingMode;
    }
}

