/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.content.Context;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.HorizontalScrollView;
import android.widget.ScrollView;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.LinearLayout;
import com.google.appinventor.components.runtime.util.AlignmentUtil;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.ViewUtil;
import java.io.IOException;

@SimpleObject
public class HVArrangement
extends AndroidViewComponent
implements Component,
ComponentContainer {
    private final Activity context;
    private final int orientation;
    private final LinearLayout viewLayout;
    private ViewGroup frameContainer;
    private boolean scrollable = false;
    private AlignmentUtil alignmentSetter;
    private int horizontalAlignment;
    private int verticalAlignment;
    private int backgroundColor;
    private Drawable backgroundImageDrawable;
    private String imagePath = "";
    private Drawable defaultButtonDrawable;
    private final Handler androidUIHandler = new Handler();
    private static final String LOG_TAG = "HVArrangement";

    public HVArrangement(ComponentContainer container, int orientation, boolean scrollable) {
        super(container);
        this.context = container.$context();
        this.orientation = orientation;
        this.scrollable = scrollable;
        this.viewLayout = new LinearLayout((Context)this.context, orientation, 100, 100);
        this.viewLayout.setBaselineAligned(false);
        this.alignmentSetter = new AlignmentUtil(this.viewLayout);
        this.horizontalAlignment = 1;
        this.verticalAlignment = 1;
        this.alignmentSetter.setHorizontalAlignment(this.horizontalAlignment);
        this.alignmentSetter.setVerticalAlignment(this.verticalAlignment);
        if (scrollable) {
            switch (orientation) {
                case 1: {
                    Log.d((String)LOG_TAG, (String)"Setting up frameContainer = ScrollView()");
                    this.frameContainer = new ScrollView((Context)this.context);
                    break;
                }
                case 0: {
                    Log.d((String)LOG_TAG, (String)"Setting up frameContainer = HorizontalScrollView()");
                    this.frameContainer = new HorizontalScrollView((Context)this.context);
                }
            }
        } else {
            Log.d((String)LOG_TAG, (String)"Setting up frameContainer = FrameLayout()");
            this.frameContainer = new FrameLayout((Context)this.context);
        }
        this.frameContainer.setLayoutParams(new ViewGroup.LayoutParams(100, 100));
        this.frameContainer.addView((View)this.viewLayout.getLayoutManager(), new ViewGroup.LayoutParams(-1, -1));
        this.defaultButtonDrawable = this.getView().getBackground();
        container.$add(this);
        this.BackgroundColor(0);
    }

    public Activity $context() {
        return this.context;
    }

    public Form $form() {
        return this.container.$form();
    }

    public void $add(AndroidViewComponent component) {
        this.viewLayout.add(component);
    }

    public void setChildWidth(AndroidViewComponent component, int width) {
        this.setChildWidth(component, width, 0);
    }

    public void setChildWidth(final AndroidViewComponent component, int width, final int trycount) {
        int cWidth = this.container.$form().Width();
        if (cWidth == 0 && trycount < 2) {
            final int fWidth = width;
            this.androidUIHandler.postDelayed(new Runnable(){

                public void run() {
                    Log.d((String)HVArrangement.LOG_TAG, (String)"(HVArrangement)Width not stable yet... trying again");
                    HVArrangement.this.setChildWidth(component, fWidth, trycount + 1);
                }
            }, 100L);
        }
        if (width <= -1000) {
            Log.d((String)LOG_TAG, (String)("HVArrangement.setChildWidth(): width = " + width + " parent Width = " + cWidth + " child = " + component));
            width = cWidth * -(width - -1000) / 100;
        }
        component.setLastWidth(width);
        if (this.orientation == 0) {
            ViewUtil.setChildWidthForHorizontalLayout(component.getView(), width);
        } else {
            ViewUtil.setChildWidthForVerticalLayout(component.getView(), width);
        }
    }

    public void setChildHeight(final AndroidViewComponent component, int height) {
        int cHeight = this.container.$form().Height();
        if (cHeight == 0) {
            final int fHeight = height;
            this.androidUIHandler.postDelayed(new Runnable(){

                public void run() {
                    Log.d((String)HVArrangement.LOG_TAG, (String)"(HVArrangement)Height not stable yet... trying again");
                    HVArrangement.this.setChildHeight(component, fHeight);
                }
            }, 100L);
        }
        if (height <= -1000) {
            height = cHeight * -(height - -1000) / 100;
        }
        component.setLastHeight(height);
        if (this.orientation == 0) {
            ViewUtil.setChildHeightForHorizontalLayout(component.getView(), height);
        } else {
            ViewUtil.setChildHeightForVerticalLayout(component.getView(), height);
        }
    }

    public View getView() {
        return this.frameContainer;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="A number that encodes how contents of the arrangement are aligned  horizontally. The choices are: 1 = left aligned, 2 = right aligned,  3 = horizontally centered.  Alignment has no effect if the arrangement's width is automatic.")
    public int AlignHorizontal() {
        return this.horizontalAlignment;
    }

    @DesignerProperty(editorType="horizontal_alignment", defaultValue="1")
    @SimpleProperty
    public void AlignHorizontal(int alignment) {
        try {
            this.alignmentSetter.setHorizontalAlignment(alignment);
            this.horizontalAlignment = alignment;
        }
        catch (IllegalArgumentException e) {
            this.container.$form().dispatchErrorOccurredEvent(this, "HorizontalAlignment", 1401, alignment);
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="A number that encodes how the contents of the arrangement are aligned  vertically. The choices are: 1 = aligned at the top, 2 = vertically centered, 3 = aligned at the bottom.  Alignment has no effect if the arrangement's height is automatic.")
    public int AlignVertical() {
        return this.verticalAlignment;
    }

    @DesignerProperty(editorType="vertical_alignment", defaultValue="1")
    @SimpleProperty
    public void AlignVertical(int alignment) {
        try {
            this.alignmentSetter.setVerticalAlignment(alignment);
            this.verticalAlignment = alignment;
        }
        catch (IllegalArgumentException e) {
            this.container.$form().dispatchErrorOccurredEvent(this, "VerticalAlignment", 1402, alignment);
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Returns the component's background color")
    public int BackgroundColor() {
        return this.backgroundColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&H00000000")
    @SimpleProperty(description="Specifies the component's background color. The background color will not be visible if an Image is being displayed.")
    public void BackgroundColor(int argb) {
        this.backgroundColor = argb;
        this.updateAppearance();
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public String Image() {
        return this.imagePath;
    }

    @DesignerProperty(editorType="asset", defaultValue="")
    @SimpleProperty(description="Specifies the path of the component's image.  If there is both an Image and a BackgroundColor, only the Image will be visible.")
    public void Image(String path) {
        if (path.equals(this.imagePath) && this.backgroundImageDrawable != null) {
            return;
        }
        this.imagePath = path == null ? "" : path;
        this.backgroundImageDrawable = null;
        if (this.imagePath.length() > 0) {
            try {
                this.backgroundImageDrawable = MediaUtil.getBitmapDrawable(this.container.$form(), this.imagePath);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.updateAppearance();
    }

    private void updateAppearance() {
        if (this.backgroundImageDrawable == null) {
            if (this.backgroundColor == 0) {
                ViewUtil.setBackgroundDrawable((View)this.viewLayout.getLayoutManager(), this.defaultButtonDrawable);
            } else {
                ViewUtil.setBackgroundDrawable((View)this.viewLayout.getLayoutManager(), null);
                this.viewLayout.getLayoutManager().setBackgroundColor(this.backgroundColor);
            }
        } else {
            ViewUtil.setBackgroundImage((View)this.viewLayout.getLayoutManager(), this.backgroundImageDrawable);
        }
    }
}

