/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnPauseListener;
import com.google.appinventor.components.runtime.OnResumeListener;

@DesignerComponent(version=1, description="<p>Non-visible component that can measure angular velocity in three dimensions in units of degrees per second.</p><p>In order to function, the component must have its <code>Enabled</code> property set to True, and the device must have a gyroscope sensor.</p>", category=ComponentCategory.SENSORS, nonVisible=true, iconName="images/gyroscopesensor.png")
@SimpleObject
public class GyroscopeSensor
extends AndroidNonvisibleComponent
implements SensorEventListener,
Deleteable,
OnPauseListener,
OnResumeListener {
    private boolean enabled;
    private float xAngularVelocity;
    private float yAngularVelocity;
    private float zAngularVelocity;
    private final SensorManager sensorManager;
    private final Sensor gyroSensor;
    private boolean listening;

    public GyroscopeSensor(ComponentContainer container) {
        super(container.$form());
        this.sensorManager = (SensorManager)this.form.getSystemService("sensor");
        this.gyroSensor = this.sensorManager.getDefaultSensor(4);
        this.form.registerForOnResume(this);
        this.form.registerForOnPause(this);
        this.Enabled(true);
    }

    private void startListening() {
        if (!this.listening) {
            this.sensorManager.registerListener((SensorEventListener)this, this.gyroSensor, 0);
            this.listening = true;
        }
    }

    private void stopListening() {
        if (this.listening) {
            this.sensorManager.unregisterListener((SensorEventListener)this);
            this.listening = false;
            this.xAngularVelocity = 0.0f;
            this.yAngularVelocity = 0.0f;
            this.zAngularVelocity = 0.0f;
        }
    }

    @SimpleEvent(description="Indicates that the gyroscope sensor data has changed. The timestamp parameter is the time in nanoseconds at which the event occurred.")
    public void GyroscopeChanged(float xAngularVelocity, float yAngularVelocity, float zAngularVelocity, long timestamp) {
        EventDispatcher.dispatchEvent(this, "GyroscopeChanged", Float.valueOf(xAngularVelocity), Float.valueOf(yAngularVelocity), Float.valueOf(zAngularVelocity), timestamp);
    }

    @SimpleProperty(description="Indicates whether a gyroscope sensor is available.", category=PropertyCategory.BEHAVIOR)
    public boolean Available() {
        return this.sensorManager.getSensorList(4).size() > 0;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Enabled() {
        return this.enabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty(description="If enabled, then sensor events will be generated and XAngularVelocity, YAngularVelocity, and ZAngularVelocity properties will have meaningful values.")
    public void Enabled(boolean enabled) {
        if (this.enabled != enabled) {
            this.enabled = enabled;
            if (enabled) {
                this.startListening();
            } else {
                this.stopListening();
            }
        }
    }

    @SimpleProperty(description="The angular velocity around the X axis, in degrees per second.", category=PropertyCategory.BEHAVIOR)
    public float XAngularVelocity() {
        return this.xAngularVelocity;
    }

    @SimpleProperty(description="The angular velocity around the Y axis, in degrees per second.", category=PropertyCategory.BEHAVIOR)
    public float YAngularVelocity() {
        return this.yAngularVelocity;
    }

    @SimpleProperty(description="The angular velocity around the Z axis, in degrees per second.", category=PropertyCategory.BEHAVIOR)
    public float ZAngularVelocity() {
        return this.zAngularVelocity;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (this.enabled) {
            this.xAngularVelocity = (float)Math.toDegrees(sensorEvent.values[0]);
            this.yAngularVelocity = (float)Math.toDegrees(sensorEvent.values[1]);
            this.zAngularVelocity = (float)Math.toDegrees(sensorEvent.values[2]);
            this.GyroscopeChanged(this.xAngularVelocity, this.yAngularVelocity, this.zAngularVelocity, sensorEvent.timestamp);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public void onDelete() {
        this.stopListening();
    }

    public void onPause() {
        this.stopListening();
    }

    public void onResume() {
        if (this.enabled) {
            this.startListening();
        }
    }
}

