/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.os.Handler;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import com.google.appinventor.components.runtime.collect.Lists;
import com.google.appinventor.components.runtime.errors.YailRuntimeError;
import com.google.appinventor.components.runtime.util.AsyncCallbackPair;
import com.google.appinventor.components.runtime.util.AsynchUtil;
import com.google.appinventor.components.runtime.util.GameInstance;
import com.google.appinventor.components.runtime.util.JsonUtil;
import com.google.appinventor.components.runtime.util.PlayerListDelta;
import com.google.appinventor.components.runtime.util.WebServiceUtil;
import com.google.appinventor.components.runtime.util.YailList;
import java.util.ArrayList;
import java.util.List;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=1, description="Provides a way for applications to communicate with online game servers", category=ComponentCategory.INTERNAL, nonVisible=true, iconName="images/gameClient.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET, com.google.android.googleapps.permission.GOOGLE_AUTH")
public class GameClient
extends AndroidNonvisibleComponent
implements Component,
OnResumeListener,
OnStopListener {
    private static final String LOG_TAG = "GameClient";
    private static final String GAME_ID_KEY = "gid";
    private static final String INSTANCE_ID_KEY = "iid";
    private static final String PLAYER_ID_KEY = "pid";
    private static final String INVITEE_KEY = "inv";
    private static final String LEADER_KEY = "leader";
    private static final String COUNT_KEY = "count";
    private static final String TYPE_KEY = "type";
    private static final String INSTANCE_PUBLIC_KEY = "makepublic";
    private static final String MESSAGE_RECIPIENTS_KEY = "mrec";
    private static final String MESSAGE_CONTENT_KEY = "contents";
    private static final String MESSAGE_TIME_KEY = "mtime";
    private static final String MESSAGE_SENDER_KEY = "msender";
    private static final String COMMAND_TYPE_KEY = "command";
    private static final String COMMAND_ARGUMENTS_KEY = "args";
    private static final String SERVER_RETURN_VALUE_KEY = "response";
    private static final String MESSAGES_LIST_KEY = "messages";
    private static final String ERROR_RESPONSE_KEY = "e";
    private static final String PUBLIC_LIST_KEY = "public";
    private static final String JOINED_LIST_KEY = "joined";
    private static final String INVITED_LIST_KEY = "invited";
    private static final String PLAYERS_LIST_KEY = "players";
    private static final String GET_INSTANCE_LISTS_COMMAND = "getinstancelists";
    private static final String GET_MESSAGES_COMMAND = "messages";
    private static final String INVITE_COMMAND = "invite";
    private static final String JOIN_INSTANCE_COMMAND = "joininstance";
    private static final String LEAVE_INSTANCE_COMMAND = "leaveinstance";
    private static final String NEW_INSTANCE_COMMAND = "newinstance";
    private static final String NEW_MESSAGE_COMMAND = "newmessage";
    private static final String SERVER_COMMAND = "servercommand";
    private static final String SET_LEADER_COMMAND = "setleader";
    private String serviceUrl;
    private String gameId;
    private GameInstance instance;
    private Handler androidUIHandler = new Handler();
    private Activity activityContext;
    private String userEmailAddress = "";
    private List<String> joinedInstances;
    private List<String> invitedInstances;
    private List<String> publicInstances;

    public GameClient(ComponentContainer container) {
        super(container.$form());
        this.activityContext = container.$context();
        this.form.registerForOnResume(this);
        this.form.registerForOnStop(this);
        this.gameId = "";
        this.instance = new GameInstance("");
        this.joinedInstances = Lists.newArrayList();
        this.invitedInstances = Lists.newArrayList();
        this.publicInstances = Lists.newArrayList();
        this.serviceUrl = "http://appinvgameserver.appspot.com";
    }

    @SimpleProperty(description="The game name for this application. The same game ID can have one or more game instances.", category=PropertyCategory.BEHAVIOR)
    public String GameId() {
        return this.gameId;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    public void GameId(String id2) {
        this.gameId = id2;
    }

    @SimpleProperty(description="The game instance id.  Taken together,the game ID and the instance ID uniquely identify the game.", category=PropertyCategory.BEHAVIOR)
    public String InstanceId() {
        return this.instance.getInstanceId();
    }

    @SimpleProperty(description="The set of game instances to which this player has been invited but has not yet joined.  To ensure current values are returned, first invoke GetInstanceLists.", category=PropertyCategory.BEHAVIOR)
    public List<String> InvitedInstances() {
        return this.invitedInstances;
    }

    @SimpleProperty(description="The set of game instances in which this player is participating.  To ensure current values are returned, first invoke GetInstanceLists.", category=PropertyCategory.BEHAVIOR)
    public List<String> JoinedInstances() {
        return this.joinedInstances;
    }

    @SimpleProperty(description="The game's leader. At any time, each game instance has only one leader, but the leader may change with time.  Initially, the leader is the game instance creator. Application writers determine special properties of the leader. The leader value is updated each time a successful communication is made with the server.", category=PropertyCategory.BEHAVIOR)
    public String Leader() {
        return this.instance.getLeader();
    }

    @SimpleProperty(description="The current set of players for this game instance. Each player is designated by an email address, which is a string. The list of players is updated each time a successful communication is made with the game server.", category=PropertyCategory.BEHAVIOR)
    public List<String> Players() {
        return this.instance.getPlayers();
    }

    @SimpleProperty(description="The set of game instances that have been marked public. To ensure current values are returned, first invoke {@link #GetInstanceLists}. ", category=PropertyCategory.BEHAVIOR)
    public List<String> PublicInstances() {
        return this.publicInstances;
    }

    @SimpleProperty(description="The URL of the game server.", category=PropertyCategory.BEHAVIOR)
    public String ServiceUrl() {
        return this.serviceUrl;
    }

    @DesignerProperty(editorType="string", defaultValue="http://appinvgameserver.appspot.com")
    public void ServiceURL(String url) {
        this.serviceUrl = url.endsWith("/") ? url.substring(0, url.length() - 1) : url;
    }

    @SimpleProperty(description="The email address that is being used as the player id for this game client.   At present, users must set this manually in oder to join a game.  But this property will change in the future so that is set automatically, and users will not be able to change it.", category=PropertyCategory.BEHAVIOR)
    public String UserEmailAddress() {
        if (this.userEmailAddress.equals("")) {
            this.Info("User email address is empty.");
        }
        return this.userEmailAddress;
    }

    @SimpleProperty
    public void UserEmailAddress(String emailAddress) {
        this.userEmailAddress = emailAddress;
        this.UserEmailAddressSet(emailAddress);
    }

    @SimpleEvent(description="Indicates that a function call completed.")
    public void FunctionCompleted(final String functionName) {
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                Log.d((String)GameClient.LOG_TAG, (String)("Request completed: " + functionName));
                EventDispatcher.dispatchEvent(GameClient.this, "FunctionCompleted", functionName);
            }
        });
    }

    public void Initialize() {
        Log.d((String)LOG_TAG, (String)"Initialize");
        if (this.gameId.equals("")) {
            throw new YailRuntimeError("Game Id must not be empty.", "GameClient Configuration Error.");
        }
    }

    @SimpleEvent(description="Indicates that a new message has been received.")
    public void GotMessage(final String type, final String sender, final List<Object> contents) {
        Log.d((String)LOG_TAG, (String)("Got message of type " + type));
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent(GameClient.this, "GotMessage", type, sender, contents);
            }
        });
    }

    @SimpleEvent(description="Indicates that the InstanceId property has changed as a result of calling MakeNewInstance or SetInstance.")
    public void InstanceIdChanged(final String instanceId) {
        Log.d((String)LOG_TAG, (String)("Instance id changed to " + instanceId));
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent(GameClient.this, "InstanceIdChanged", instanceId);
            }
        });
    }

    @SimpleEvent(description="Indicates that a user has been invited to this game instance.")
    public void Invited(final String instanceId) {
        Log.d((String)LOG_TAG, (String)("Player invited to " + instanceId));
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent(GameClient.this, "Invited", instanceId);
            }
        });
    }

    @SimpleEvent(description="Indicates that this game has a new leader as specified through SetLeader")
    public void NewLeader(final String playerId) {
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                Log.d((String)GameClient.LOG_TAG, (String)("Leader change to " + playerId));
                EventDispatcher.dispatchEvent(GameClient.this, "NewLeader", playerId);
            }
        });
    }

    @SimpleEvent(description="Indicates that a new instance was successfully created after calling MakeNewInstance.")
    public void NewInstanceMade(final String instanceId) {
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                Log.d((String)GameClient.LOG_TAG, (String)("New instance made: " + instanceId));
                EventDispatcher.dispatchEvent(GameClient.this, "NewInstanceMade", instanceId);
            }
        });
    }

    @SimpleEvent(description="Indicates that a new player has joined this game instance.")
    public void PlayerJoined(final String playerId) {
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                if (!playerId.equals(GameClient.this.UserEmailAddress())) {
                    Log.d((String)GameClient.LOG_TAG, (String)("Player joined: " + playerId));
                    EventDispatcher.dispatchEvent(GameClient.this, "PlayerJoined", playerId);
                }
            }
        });
    }

    @SimpleEvent(description="Indicates that a player has left this game instance.")
    public void PlayerLeft(final String playerId) {
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                Log.d((String)GameClient.LOG_TAG, (String)("Player left: " + playerId));
                EventDispatcher.dispatchEvent(GameClient.this, "PlayerLeft", playerId);
            }
        });
    }

    @SimpleEvent(description="Indicates that a server command failed.")
    public void ServerCommandFailure(final String command, final YailList arguments) {
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                Log.d((String)GameClient.LOG_TAG, (String)("Server command failed: " + command));
                EventDispatcher.dispatchEvent(GameClient.this, "ServerCommandFailure", command, arguments);
            }
        });
    }

    @SimpleEvent(description="Indicates that a server command returned successfully.")
    public void ServerCommandSuccess(final String command, final List<Object> response) {
        Log.d((String)LOG_TAG, (String)(command + " server command returned."));
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent(GameClient.this, "ServerCommandSuccess", command, response);
            }
        });
    }

    @SimpleEvent(description="Indicates that the user email address has been set.")
    public void UserEmailAddressSet(final String emailAddress) {
        Log.d((String)LOG_TAG, (String)"Email address set.");
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent(GameClient.this, "UserEmailAddressSet", emailAddress);
            }
        });
    }

    @SimpleEvent(description="Indicates that something has occurred which the player should know about.")
    public void Info(final String message) {
        Log.d((String)LOG_TAG, (String)("Info: " + message));
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent(GameClient.this, "Info", message);
            }
        });
    }

    @SimpleEvent(description="Indicates that an error occurred while communicating with the web server.")
    public void WebServiceError(final String functionName, final String message) {
        Log.e((String)LOG_TAG, (String)("WebServiceError: " + message));
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                EventDispatcher.dispatchEvent(GameClient.this, "WebServiceError", functionName, message);
            }
        });
    }

    @SimpleFunction(description="Updates the InstancesJoined and InstancesInvited lists. This procedure can be called before setting the InstanceId.")
    public void GetInstanceLists() {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                GameClient.this.postGetInstanceLists();
            }
        });
    }

    private void postGetInstanceLists() {
        AsyncCallbackPair<JSONObject> readMessagesCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject response) {
                GameClient.this.processInstanceLists(response);
                GameClient.this.FunctionCompleted("GetInstanceLists");
            }

            @Override
            public void onFailure(String message) {
                GameClient.this.WebServiceError("GetInstanceLists", "Failed to get up to date instance lists.");
            }
        };
        this.postCommandToGameServer(GET_INSTANCE_LISTS_COMMAND, Lists.newArrayList(new BasicNameValuePair(GAME_ID_KEY, this.GameId()), new BasicNameValuePair(INSTANCE_ID_KEY, this.InstanceId()), new BasicNameValuePair(PLAYER_ID_KEY, this.UserEmailAddress())), readMessagesCallback);
    }

    private void processInstanceLists(JSONObject instanceLists) {
        try {
            this.joinedInstances = JsonUtil.getStringListFromJsonArray(instanceLists.getJSONArray(JOINED_LIST_KEY));
            this.publicInstances = JsonUtil.getStringListFromJsonArray(instanceLists.getJSONArray(PUBLIC_LIST_KEY));
            List<String> receivedInstancesInvited = JsonUtil.getStringListFromJsonArray(instanceLists.getJSONArray(INVITED_LIST_KEY));
            if (!receivedInstancesInvited.equals(this.InvitedInstances())) {
                List<String> oldList = this.invitedInstances;
                this.invitedInstances = receivedInstancesInvited;
                ArrayList<String> newInvites = new ArrayList<String>(receivedInstancesInvited);
                newInvites.removeAll(oldList);
                for (String instanceInvited : newInvites) {
                    this.Invited(instanceInvited);
                }
            }
        }
        catch (JSONException e) {
            Log.w((String)LOG_TAG, (Throwable)e);
            this.Info("Instance lists failed to parse.");
        }
    }

    @SimpleFunction(description="Retrieves messages of the specified type.")
    public void GetMessages(final String type, final int count) {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                GameClient.this.postGetMessages(type, count);
            }
        });
    }

    private void postGetMessages(final String requestedType, int count) {
        AsyncCallbackPair<JSONObject> myCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                try {
                    int count = result.getInt(GameClient.COUNT_KEY);
                    JSONArray messages = result.getJSONArray("messages");
                    for (int i = 0; i < count; ++i) {
                        JSONObject message = messages.getJSONObject(i);
                        String type = message.getString(GameClient.TYPE_KEY);
                        String sender = message.getString(GameClient.MESSAGE_SENDER_KEY);
                        String time = message.getString(GameClient.MESSAGE_TIME_KEY);
                        List<Object> contents = JsonUtil.getListFromJsonArray(message.getJSONArray(GameClient.MESSAGE_CONTENT_KEY));
                        if (requestedType.equals("")) {
                            GameClient.this.instance.putMessageTime(requestedType, time);
                        }
                        GameClient.this.instance.putMessageTime(type, time);
                        GameClient.this.GotMessage(type, sender, contents);
                    }
                }
                catch (JSONException e) {
                    Log.w((String)GameClient.LOG_TAG, (Throwable)e);
                    GameClient.this.Info("Failed to parse messages response.");
                }
                GameClient.this.FunctionCompleted("GetMessages");
            }

            @Override
            public void onFailure(String message) {
                GameClient.this.WebServiceError("GetMessages", message);
            }
        };
        if (this.InstanceId().equals("")) {
            this.Info("You must join an instance before attempting to fetch messages.");
            return;
        }
        this.postCommandToGameServer("messages", Lists.newArrayList(new BasicNameValuePair(GAME_ID_KEY, this.GameId()), new BasicNameValuePair(INSTANCE_ID_KEY, this.InstanceId()), new BasicNameValuePair(PLAYER_ID_KEY, this.UserEmailAddress()), new BasicNameValuePair(COUNT_KEY, Integer.toString(count)), new BasicNameValuePair(MESSAGE_TIME_KEY, this.instance.getMessageTime(requestedType)), new BasicNameValuePair(TYPE_KEY, requestedType)), myCallback);
    }

    @SimpleFunction(description="Invites a player to this game instance.")
    public void Invite(final String playerEmail) {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                GameClient.this.postInvite(playerEmail);
            }
        });
    }

    private void postInvite(String inviteeEmail) {
        AsyncCallbackPair<JSONObject> inviteCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject response) {
                try {
                    String invitedPlayer = response.getString(GameClient.INVITEE_KEY);
                    if (invitedPlayer.equals("")) {
                        GameClient.this.Info(invitedPlayer + " was already invited.");
                    } else {
                        GameClient.this.Info("Successfully invited " + invitedPlayer + ".");
                    }
                }
                catch (JSONException e) {
                    Log.w((String)GameClient.LOG_TAG, (Throwable)e);
                    GameClient.this.Info("Failed to parse invite player response.");
                }
                GameClient.this.FunctionCompleted("Invite");
            }

            @Override
            public void onFailure(String message) {
                GameClient.this.WebServiceError("Invite", message);
            }
        };
        if (this.InstanceId().equals("")) {
            this.Info("You must have joined an instance before you can invite new players.");
            return;
        }
        this.postCommandToGameServer(INVITE_COMMAND, Lists.newArrayList(new BasicNameValuePair(GAME_ID_KEY, this.GameId()), new BasicNameValuePair(INSTANCE_ID_KEY, this.InstanceId()), new BasicNameValuePair(PLAYER_ID_KEY, this.UserEmailAddress()), new BasicNameValuePair(INVITEE_KEY, inviteeEmail)), inviteCallback);
    }

    @SimpleFunction(description="Leaves the current instance.")
    public void LeaveInstance() {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                GameClient.this.postLeaveInstance();
            }
        });
    }

    private void postLeaveInstance() {
        AsyncCallbackPair<JSONObject> setInstanceCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject response) {
                GameClient.this.SetInstance("");
                GameClient.this.processInstanceLists(response);
                GameClient.this.FunctionCompleted("LeaveInstance");
            }

            @Override
            public void onFailure(String message) {
                GameClient.this.WebServiceError("LeaveInstance", message);
            }
        };
        this.postCommandToGameServer(LEAVE_INSTANCE_COMMAND, Lists.newArrayList(new BasicNameValuePair(GAME_ID_KEY, this.GameId()), new BasicNameValuePair(INSTANCE_ID_KEY, this.InstanceId()), new BasicNameValuePair(PLAYER_ID_KEY, this.UserEmailAddress())), setInstanceCallback);
    }

    @SimpleFunction(description="Asks the server to create a new instance of this game.")
    public void MakeNewInstance(final String instanceId, final boolean makePublic) {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                GameClient.this.postMakeNewInstance(instanceId, makePublic);
            }
        });
    }

    private void postMakeNewInstance(String requestedInstanceId, Boolean makePublic) {
        AsyncCallbackPair<JSONObject> makeNewGameCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject response) {
                GameClient.this.processInstanceLists(response);
                GameClient.this.NewInstanceMade(GameClient.this.InstanceId());
                GameClient.this.FunctionCompleted("MakeNewInstance");
            }

            @Override
            public void onFailure(String message) {
                GameClient.this.WebServiceError("MakeNewInstance", message);
            }
        };
        this.postCommandToGameServer(NEW_INSTANCE_COMMAND, Lists.newArrayList(new BasicNameValuePair(PLAYER_ID_KEY, this.UserEmailAddress()), new BasicNameValuePair(GAME_ID_KEY, this.GameId()), new BasicNameValuePair(INSTANCE_ID_KEY, requestedInstanceId), new BasicNameValuePair(INSTANCE_PUBLIC_KEY, makePublic.toString())), makeNewGameCallback, true);
    }

    @SimpleFunction(description="Sends a keyed message to all recipients in the recipients list. The message will consist of the contents list.")
    public void SendMessage(final String type, final YailList recipients, final YailList contents) {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                GameClient.this.postNewMessage(type, recipients, contents);
            }
        });
    }

    private void postNewMessage(String type, YailList recipients, YailList contents) {
        AsyncCallbackPair<JSONObject> myCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject response) {
                GameClient.this.FunctionCompleted("SendMessage");
            }

            @Override
            public void onFailure(String message) {
                GameClient.this.WebServiceError("SendMessage", message);
            }
        };
        if (this.InstanceId().equals("")) {
            this.Info("You must have joined an instance before you can send messages.");
            return;
        }
        this.postCommandToGameServer(NEW_MESSAGE_COMMAND, Lists.newArrayList(new BasicNameValuePair(GAME_ID_KEY, this.GameId()), new BasicNameValuePair(INSTANCE_ID_KEY, this.InstanceId()), new BasicNameValuePair(PLAYER_ID_KEY, this.UserEmailAddress()), new BasicNameValuePair(TYPE_KEY, type), new BasicNameValuePair(MESSAGE_RECIPIENTS_KEY, recipients.toJSONString()), new BasicNameValuePair(MESSAGE_CONTENT_KEY, contents.toJSONString()), new BasicNameValuePair(MESSAGE_TIME_KEY, this.instance.getMessageTime(type))), myCallback);
    }

    @SimpleFunction(description="Sends the specified command to the game server.")
    public void ServerCommand(final String command, final YailList arguments) {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                GameClient.this.postServerCommand(command, arguments);
            }
        });
    }

    private void postServerCommand(final String command, final YailList arguments) {
        AsyncCallbackPair<JSONObject> myCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject result) {
                try {
                    GameClient.this.ServerCommandSuccess(command, JsonUtil.getListFromJsonArray(result.getJSONArray(GameClient.MESSAGE_CONTENT_KEY)));
                }
                catch (JSONException e) {
                    Log.w((String)GameClient.LOG_TAG, (Throwable)e);
                    GameClient.this.Info("Server command response failed to parse.");
                }
                GameClient.this.FunctionCompleted("ServerCommand");
            }

            @Override
            public void onFailure(String message) {
                GameClient.this.ServerCommandFailure(command, arguments);
                GameClient.this.WebServiceError("ServerCommand", message);
            }
        };
        Log.d((String)LOG_TAG, (String)("Going to post " + command + " with args " + arguments));
        this.postCommandToGameServer(SERVER_COMMAND, Lists.newArrayList(new BasicNameValuePair(GAME_ID_KEY, this.GameId()), new BasicNameValuePair(INSTANCE_ID_KEY, this.InstanceId()), new BasicNameValuePair(PLAYER_ID_KEY, this.UserEmailAddress()), new BasicNameValuePair(COMMAND_TYPE_KEY, command), new BasicNameValuePair(COMMAND_ARGUMENTS_KEY, arguments.toJSONString())), myCallback);
    }

    @SimpleFunction(description="Sets InstanceId and joins the specified instance.")
    public void SetInstance(final String instanceId) {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                if (instanceId.equals("")) {
                    Log.d((String)GameClient.LOG_TAG, (String)"Instance id set to empty string.");
                    if (!GameClient.this.InstanceId().equals("")) {
                        GameClient.this.instance = new GameInstance("");
                        GameClient.this.InstanceIdChanged("");
                        GameClient.this.FunctionCompleted("SetInstance");
                    }
                } else {
                    GameClient.this.postSetInstance(instanceId);
                }
            }
        });
    }

    private void postSetInstance(String instanceId) {
        AsyncCallbackPair<JSONObject> setInstanceCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject response) {
                GameClient.this.processInstanceLists(response);
                GameClient.this.FunctionCompleted("SetInstance");
            }

            @Override
            public void onFailure(String message) {
                GameClient.this.WebServiceError("SetInstance", message);
            }
        };
        this.postCommandToGameServer(JOIN_INSTANCE_COMMAND, Lists.newArrayList(new BasicNameValuePair(GAME_ID_KEY, this.GameId()), new BasicNameValuePair(INSTANCE_ID_KEY, instanceId), new BasicNameValuePair(PLAYER_ID_KEY, this.UserEmailAddress())), setInstanceCallback, true);
    }

    @SimpleFunction(description="Tells the server to set the leader to playerId. Only the current leader may successfully set a new leader.")
    public void SetLeader(final String playerEmail) {
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                GameClient.this.postSetLeader(playerEmail);
            }
        });
    }

    private void postSetLeader(String newLeader) {
        AsyncCallbackPair<JSONObject> setLeaderCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject response) {
                GameClient.this.FunctionCompleted("SetLeader");
            }

            @Override
            public void onFailure(String message) {
                GameClient.this.WebServiceError("SetLeader", message);
            }
        };
        if (this.InstanceId().equals("")) {
            this.Info("You must join an instance before attempting to set a leader.");
            return;
        }
        this.postCommandToGameServer(SET_LEADER_COMMAND, Lists.newArrayList(new BasicNameValuePair(GAME_ID_KEY, this.GameId()), new BasicNameValuePair(INSTANCE_ID_KEY, this.InstanceId()), new BasicNameValuePair(PLAYER_ID_KEY, this.UserEmailAddress()), new BasicNameValuePair(LEADER_KEY, newLeader)), setLeaderCallback);
    }

    @Override
    public void onResume() {
        Log.d((String)LOG_TAG, (String)"Activity Resumed.");
    }

    @Override
    public void onStop() {
        Log.d((String)LOG_TAG, (String)"Activity Stopped.");
    }

    private void postCommandToGameServer(String commandName, List<NameValuePair> params, AsyncCallbackPair<JSONObject> callback) {
        this.postCommandToGameServer(commandName, params, callback, false);
    }

    private void postCommandToGameServer(final String commandName, final List<NameValuePair> params, final AsyncCallbackPair<JSONObject> callback, final boolean allowInstanceIdChange) {
        AsyncCallbackPair<JSONObject> thisCallback = new AsyncCallbackPair<JSONObject>(){

            @Override
            public void onSuccess(JSONObject responseObject) {
                Log.d((String)GameClient.LOG_TAG, (String)("Received response for " + commandName + ": " + responseObject.toString()));
                try {
                    if (responseObject.getBoolean(GameClient.ERROR_RESPONSE_KEY)) {
                        callback.onFailure(responseObject.getString(GameClient.SERVER_RETURN_VALUE_KEY));
                    } else {
                        String responseGameId = responseObject.getString(GameClient.GAME_ID_KEY);
                        if (!responseGameId.equals(GameClient.this.GameId())) {
                            GameClient.this.Info("Incorrect game id in response: + " + responseGameId + ".");
                            return;
                        }
                        String responseInstanceId = responseObject.getString(GameClient.INSTANCE_ID_KEY);
                        if (responseInstanceId.equals("")) {
                            callback.onSuccess(responseObject.getJSONObject(GameClient.SERVER_RETURN_VALUE_KEY));
                            return;
                        }
                        if (responseInstanceId.equals(GameClient.this.InstanceId())) {
                            GameClient.this.updateInstanceInfo(responseObject);
                        } else if (allowInstanceIdChange || GameClient.this.InstanceId().equals("")) {
                            GameClient.this.instance = new GameInstance(responseInstanceId);
                            GameClient.this.updateInstanceInfo(responseObject);
                            GameClient.this.InstanceIdChanged(responseInstanceId);
                        } else {
                            GameClient.this.Info("Ignored server response to " + commandName + " for incorrect instance " + responseInstanceId + ".");
                            return;
                        }
                        callback.onSuccess(responseObject.getJSONObject(GameClient.SERVER_RETURN_VALUE_KEY));
                    }
                }
                catch (JSONException e) {
                    Log.w((String)GameClient.LOG_TAG, (Throwable)e);
                    callback.onFailure("Failed to parse JSON response to command " + commandName);
                }
            }

            @Override
            public void onFailure(String failureMessage) {
                Log.d((String)GameClient.LOG_TAG, (String)("Posting to server failed for " + commandName + " with arguments " + params + "\n Failure message: " + failureMessage));
                callback.onFailure(failureMessage);
            }
        };
        WebServiceUtil.getInstance().postCommandReturningObject(this.ServiceUrl(), commandName, params, thisCallback);
    }

    private void updateInstanceInfo(JSONObject responseObject) throws JSONException {
        PlayerListDelta playersDelta;
        boolean newLeader = false;
        String leader = responseObject.getString(LEADER_KEY);
        List<String> receivedPlayers = JsonUtil.getStringListFromJsonArray(responseObject.getJSONArray(PLAYERS_LIST_KEY));
        if (!this.Leader().equals(leader)) {
            this.instance.setLeader(leader);
            newLeader = true;
        }
        if ((playersDelta = this.instance.setPlayers(receivedPlayers)) != PlayerListDelta.NO_CHANGE) {
            for (String player : playersDelta.getPlayersRemoved()) {
                this.PlayerLeft(player);
            }
            for (String player : playersDelta.getPlayersAdded()) {
                this.PlayerJoined(player);
            }
        }
        if (newLeader) {
            this.NewLeader(this.Leader());
        }
    }
}

