/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.app.Dialog;
import android.app.ProgressDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.graphics.PorterDuff;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.util.Log;
import android.view.KeyEvent;
import android.view.Menu;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.view.WindowManager;
import android.view.inputmethod.InputMethodManager;
import android.widget.FrameLayout;
import android.widget.ScrollView;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ActivityResultListener;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.HandlesEventDispatching;
import com.google.appinventor.components.runtime.LinearLayout;
import com.google.appinventor.components.runtime.Notifier;
import com.google.appinventor.components.runtime.OnCreateOptionsMenuListener;
import com.google.appinventor.components.runtime.OnDestroyListener;
import com.google.appinventor.components.runtime.OnNewIntentListener;
import com.google.appinventor.components.runtime.OnOptionsItemSelectedListener;
import com.google.appinventor.components.runtime.OnPauseListener;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import com.google.appinventor.components.runtime.ReplApplication;
import com.google.appinventor.components.runtime.ReplForm;
import com.google.appinventor.components.runtime.ScaledFrameLayout;
import com.google.appinventor.components.runtime.VideoPlayer;
import com.google.appinventor.components.runtime.collect.Lists;
import com.google.appinventor.components.runtime.collect.Maps;
import com.google.appinventor.components.runtime.collect.Sets;
import com.google.appinventor.components.runtime.multidex.MultiDex;
import com.google.appinventor.components.runtime.util.AlignmentUtil;
import com.google.appinventor.components.runtime.util.AnimationUtil;
import com.google.appinventor.components.runtime.util.ErrorMessages;
import com.google.appinventor.components.runtime.util.FullScreenVideoUtil;
import com.google.appinventor.components.runtime.util.JsonUtil;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.OnInitializeListener;
import com.google.appinventor.components.runtime.util.ScreenDensityUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.ViewUtil;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;

@DesignerComponent(version=19, category=ComponentCategory.LAYOUT, description="Top-level component containing all other components in the program", showOnPalette=false)
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET,android.permission.ACCESS_WIFI_STATE,android.permission.ACCESS_NETWORK_STATE")
public class Form
extends Activity
implements Component,
ComponentContainer,
HandlesEventDispatching,
ViewTreeObserver.OnGlobalLayoutListener {
    private static final String LOG_TAG = "Form";
    private static final String RESULT_NAME = "APP_INVENTOR_RESULT";
    private static final String ARGUMENT_NAME = "APP_INVENTOR_START";
    public static final String APPINVENTOR_URL_SCHEME = "appinventor";
    protected static Form activeForm;
    private float deviceDensity;
    private float compatScalingFactor;
    private static boolean applicationIsBeingClosed;
    private final Handler androidUIHandler = new Handler();
    protected String formName;
    private boolean screenInitialized;
    private static final int SWITCH_FORM_REQUEST_CODE = 1;
    private static int nextRequestCode;
    private int backgroundColor;
    private String aboutScreen;
    private boolean showStatusBar = true;
    private boolean showTitle = true;
    private String backgroundImagePath = "";
    private Drawable backgroundDrawable;
    private LinearLayout viewLayout;
    private AlignmentUtil alignmentSetter;
    private int horizontalAlignment;
    private int verticalAlignment;
    private String openAnimType;
    private String closeAnimType;
    private FrameLayout frameLayout;
    private boolean scrollable;
    private ScaledFrameLayout scaleLayout;
    private static boolean sCompatibilityMode;
    private final HashMap<Integer, ActivityResultListener> activityResultMap = Maps.newHashMap();
    private final Set<OnStopListener> onStopListeners = Sets.newHashSet();
    private final Set<OnNewIntentListener> onNewIntentListeners = Sets.newHashSet();
    private final Set<OnResumeListener> onResumeListeners = Sets.newHashSet();
    private final Set<OnPauseListener> onPauseListeners = Sets.newHashSet();
    private final Set<OnDestroyListener> onDestroyListeners = Sets.newHashSet();
    private final Set<OnInitializeListener> onInitializeListeners = Sets.newHashSet();
    private final Set<OnCreateOptionsMenuListener> onCreateOptionsMenuListeners = Sets.newHashSet();
    private final Set<OnOptionsItemSelectedListener> onOptionsItemSelectedListeners = Sets.newHashSet();
    protected String startupValue = "";
    private static long minimumToastWait;
    private long lastToastTime = System.nanoTime() - minimumToastWait;
    private String nextFormName;
    private FullScreenVideoUtil fullScreenVideoUtil;
    private int formWidth;
    private int formHeight;
    private boolean keyboardShown = false;
    private ProgressDialog progress;
    private static boolean _initialized;
    private ArrayList<PercentStorageRecord> dimChanges = new ArrayList();
    private String yandexTranslateTagline = "";

    public void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        String className = this.getClass().getName();
        int lastDot = className.lastIndexOf(46);
        this.formName = className.substring(lastDot + 1);
        Log.d((String)LOG_TAG, (String)("Form " + this.formName + " got onCreate"));
        activeForm = this;
        Log.i((String)LOG_TAG, (String)("activeForm is now " + Form.activeForm.formName));
        this.deviceDensity = this.getResources().getDisplayMetrics().density;
        Log.d((String)LOG_TAG, (String)("deviceDensity = " + this.deviceDensity));
        this.compatScalingFactor = ScreenDensityUtil.computeCompatibleScaling((Context)this);
        Log.i((String)LOG_TAG, (String)("compatScalingFactor = " + this.compatScalingFactor));
        this.viewLayout = new LinearLayout((Context)this, 1);
        this.alignmentSetter = new AlignmentUtil(this.viewLayout);
        this.progress = null;
        if (!_initialized && this.formName.equals("Screen1")) {
            Log.d((String)LOG_TAG, (String)("MULTI: _initialized = " + _initialized + " formName = " + this.formName));
            _initialized = true;
            if (ReplApplication.installed) {
                Log.d((String)LOG_TAG, (String)"MultiDex already installed.");
                this.onCreateFinish();
            } else {
                this.progress = ProgressDialog.show((Context)this, (CharSequence)"Please Wait...", (CharSequence)"Installation Finishing");
                this.progress.show();
                new MultiDexInstaller().execute(new Form[]{this});
            }
        } else {
            Log.d((String)LOG_TAG, (String)("NO MULTI: _initialized = " + _initialized + " formName = " + this.formName));
            _initialized = true;
            this.onCreateFinish();
        }
    }

    void onCreateFinish() {
        Log.d((String)LOG_TAG, (String)("onCreateFinish called " + System.currentTimeMillis()));
        if (this.progress != null) {
            this.progress.dismiss();
        }
        this.defaultPropertyValues();
        Intent startIntent = this.getIntent();
        if (startIntent != null && startIntent.hasExtra(ARGUMENT_NAME)) {
            this.startupValue = startIntent.getStringExtra(ARGUMENT_NAME);
        }
        this.fullScreenVideoUtil = new FullScreenVideoUtil(this, this.androidUIHandler);
        WindowManager.LayoutParams params = this.getWindow().getAttributes();
        int softInputMode = params.softInputMode;
        this.getWindow().setSoftInputMode(softInputMode | 0x10);
        this.$define();
        this.Initialize();
    }

    private void defaultPropertyValues() {
        this.Scrollable(false);
        this.Sizing("Fixed");
        this.BackgroundImage("");
        this.AboutScreen("");
        this.BackgroundImage("");
        this.BackgroundColor(-1);
        this.AlignHorizontal(1);
        this.AlignVertical(1);
        this.Title("");
        this.ShowStatusBar(true);
        this.TitleVisible(true);
    }

    public void onConfigurationChanged(Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        Log.d((String)LOG_TAG, (String)"onConfigurationChanged() called");
        final int newOrientation = newConfig.orientation;
        if (newOrientation == 2 || newOrientation == 1) {
            this.androidUIHandler.post(new Runnable(){

                public void run() {
                    boolean dispatchEventNow = false;
                    if (Form.this.frameLayout != null) {
                        if (newOrientation == 2) {
                            if (Form.this.frameLayout.getWidth() >= Form.this.frameLayout.getHeight()) {
                                dispatchEventNow = true;
                            }
                        } else if (Form.this.frameLayout.getHeight() >= Form.this.frameLayout.getWidth()) {
                            dispatchEventNow = true;
                        }
                    }
                    if (dispatchEventNow) {
                        Form.this.recomputeLayout();
                        FrameLayout savedLayout = Form.this.frameLayout;
                        Form.this.androidUIHandler.postDelayed(new Runnable(){

                            public void run() {
                                if (Form.this.frameLayout != null) {
                                    Form.this.frameLayout.invalidate();
                                }
                            }
                        }, 100L);
                        Form.this.ScreenOrientationChanged();
                    } else {
                        Form.this.androidUIHandler.post((Runnable)this);
                    }
                }
            });
        }
    }

    public void onGlobalLayout() {
        int heightDiff = this.scaleLayout.getRootView().getHeight() - this.scaleLayout.getHeight();
        int contentViewTop = this.getWindow().findViewById(0x1020002).getTop();
        Log.d((String)LOG_TAG, (String)("onGlobalLayout(): heightdiff = " + heightDiff + " contentViewTop = " + contentViewTop));
        if (heightDiff <= contentViewTop) {
            Log.d((String)LOG_TAG, (String)"keyboard hidden!");
            if (this.keyboardShown) {
                this.keyboardShown = false;
                if (sCompatibilityMode) {
                    this.scaleLayout.setScale(this.compatScalingFactor);
                    this.scaleLayout.invalidate();
                }
            }
        } else {
            int keyboardHeight = heightDiff - contentViewTop;
            Log.d((String)LOG_TAG, (String)"keyboard shown!");
            this.keyboardShown = true;
            if (this.scaleLayout != null) {
                this.scaleLayout.setScale(1.0f);
                this.scaleLayout.invalidate();
            }
        }
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (keyCode == 4) {
            if (!this.BackPressed()) {
                boolean handled = super.onKeyDown(keyCode, event);
                AnimationUtil.ApplyCloseScreenAnimation(this, this.closeAnimType);
                return handled;
            }
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    @SimpleEvent(description="Device back button pressed.")
    public boolean BackPressed() {
        return EventDispatcher.dispatchEvent(this, "BackPressed", new Object[0]);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        Log.i((String)LOG_TAG, (String)("Form " + this.formName + " got onActivityResult, requestCode = " + requestCode + ", resultCode = " + resultCode));
        if (requestCode == 1) {
            String resultString = data != null && data.hasExtra(RESULT_NAME) ? data.getStringExtra(RESULT_NAME) : "";
            Object decodedResult = Form.decodeJSONStringForForm(resultString, "other screen closed");
            this.OtherScreenClosed(this.nextFormName, decodedResult);
        } else {
            ActivityResultListener component = this.activityResultMap.get(requestCode);
            if (component != null) {
                component.resultReturned(requestCode, resultCode, data);
            }
        }
    }

    private static Object decodeJSONStringForForm(String jsonString, String functionName) {
        Log.i((String)LOG_TAG, (String)("decodeJSONStringForForm -- decoding JSON representation:" + jsonString));
        Object valueFromJSON = "";
        try {
            valueFromJSON = JsonUtil.getObjectFromJson(jsonString);
            Log.i((String)LOG_TAG, (String)("decodeJSONStringForForm -- got decoded JSON:" + valueFromJSON.toString()));
        }
        catch (JSONException e) {
            activeForm.dispatchErrorOccurredEvent(activeForm, functionName, 903, jsonString);
        }
        return valueFromJSON;
    }

    public int registerForActivityResult(ActivityResultListener listener) {
        int requestCode = Form.generateNewRequestCode();
        this.activityResultMap.put(requestCode, listener);
        return requestCode;
    }

    public void unregisterForActivityResult(ActivityResultListener listener) {
        ArrayList<Integer> keysToDelete = Lists.newArrayList();
        for (Map.Entry<Integer, ActivityResultListener> mapEntry : this.activityResultMap.entrySet()) {
            if (!listener.equals(mapEntry.getValue())) continue;
            keysToDelete.add(mapEntry.getKey());
        }
        for (Integer key : keysToDelete) {
            this.activityResultMap.remove(key);
        }
    }

    void ReplayFormOrientation() {
        Log.d((String)LOG_TAG, (String)"ReplayFormOrientation()");
        ArrayList temp = (ArrayList)this.dimChanges.clone();
        this.dimChanges.clear();
        for (int i = 0; i < temp.size(); ++i) {
            PercentStorageRecord r = (PercentStorageRecord)temp.get(i);
            if (r.dim == PercentStorageRecord.Dim.HEIGHT) {
                r.component.Height(r.length);
                continue;
            }
            r.component.Width(r.length);
        }
    }

    public void registerPercentLength(AndroidViewComponent component, int length, PercentStorageRecord.Dim dim) {
        this.dimChanges.add(new PercentStorageRecord(component, length, dim));
    }

    private static int generateNewRequestCode() {
        return nextRequestCode++;
    }

    protected void onResume() {
        super.onResume();
        Log.i((String)LOG_TAG, (String)("Form " + this.formName + " got onResume"));
        activeForm = this;
        if (applicationIsBeingClosed) {
            this.closeApplication();
            return;
        }
        for (OnResumeListener onResumeListener : this.onResumeListeners) {
            onResumeListener.onResume();
        }
    }

    public void registerForOnResume(OnResumeListener component) {
        this.onResumeListeners.add(component);
    }

    public void registerForOnInitialize(OnInitializeListener component) {
        this.onInitializeListeners.add(component);
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        Log.d((String)LOG_TAG, (String)("Form " + this.formName + " got onNewIntent " + intent));
        for (OnNewIntentListener onNewIntentListener : this.onNewIntentListeners) {
            onNewIntentListener.onNewIntent(intent);
        }
    }

    public void registerForOnNewIntent(OnNewIntentListener component) {
        this.onNewIntentListeners.add(component);
    }

    protected void onPause() {
        super.onPause();
        Log.i((String)LOG_TAG, (String)("Form " + this.formName + " got onPause"));
        for (OnPauseListener onPauseListener : this.onPauseListeners) {
            onPauseListener.onPause();
        }
    }

    public void registerForOnPause(OnPauseListener component) {
        this.onPauseListeners.add(component);
    }

    protected void onStop() {
        super.onStop();
        Log.i((String)LOG_TAG, (String)("Form " + this.formName + " got onStop"));
        for (OnStopListener onStopListener : this.onStopListeners) {
            onStopListener.onStop();
        }
    }

    public void registerForOnStop(OnStopListener component) {
        this.onStopListeners.add(component);
    }

    protected void onDestroy() {
        super.onDestroy();
        Log.i((String)LOG_TAG, (String)("Form " + this.formName + " got onDestroy"));
        EventDispatcher.removeDispatchDelegate(this);
        for (OnDestroyListener onDestroyListener : this.onDestroyListeners) {
            onDestroyListener.onDestroy();
        }
    }

    public void registerForOnDestroy(OnDestroyListener component) {
        this.onDestroyListeners.add(component);
    }

    public void registerForOnCreateOptionsMenu(OnCreateOptionsMenuListener component) {
        this.onCreateOptionsMenuListeners.add(component);
    }

    public void registerForOnOptionsItemSelected(OnOptionsItemSelectedListener component) {
        this.onOptionsItemSelectedListeners.add(component);
    }

    public Dialog onCreateDialog(int id2) {
        switch (id2) {
            case 189: {
                return this.fullScreenVideoUtil.createFullScreenVideoDialog();
            }
        }
        return super.onCreateDialog(id2);
    }

    public void onPrepareDialog(int id2, Dialog dialog) {
        switch (id2) {
            case 189: {
                this.fullScreenVideoUtil.prepareFullScreenVideoDialog(dialog);
                break;
            }
            default: {
                super.onPrepareDialog(id2, dialog);
            }
        }
    }

    protected void $define() {
        throw new UnsupportedOperationException();
    }

    public boolean canDispatchEvent(Component component, String eventName) {
        boolean canDispatch;
        boolean bl = canDispatch = this.screenInitialized || component == this && eventName.equals("Initialize");
        if (canDispatch) {
            activeForm = this;
        }
        return canDispatch;
    }

    public boolean dispatchEvent(Component component, String componentName, String eventName, Object[] args) {
        throw new UnsupportedOperationException();
    }

    @SimpleEvent(description="Screen starting")
    public void Initialize() {
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                if (Form.this.frameLayout != null && Form.this.frameLayout.getWidth() != 0 && Form.this.frameLayout.getHeight() != 0) {
                    EventDispatcher.dispatchEvent(Form.this, "Initialize", new Object[0]);
                    if (sCompatibilityMode) {
                        Form.this.Sizing("Fixed");
                    } else {
                        Form.this.Sizing("Responsive");
                    }
                    Form.this.screenInitialized = true;
                    for (OnInitializeListener onInitializeListener : Form.this.onInitializeListeners) {
                        onInitializeListener.onInitialize();
                    }
                    if (activeForm instanceof ReplForm) {
                        ((ReplForm)activeForm).HandleReturnValues();
                    }
                } else {
                    Form.this.androidUIHandler.post((Runnable)this);
                }
            }
        });
    }

    @SimpleEvent(description="Screen orientation changed")
    public void ScreenOrientationChanged() {
        EventDispatcher.dispatchEvent(this, "ScreenOrientationChanged", new Object[0]);
    }

    @SimpleEvent(description="Event raised when an error occurs. Only some errors will raise this condition.  For those errors, the system will show a notification by default.  You can use this event handler to prescribe an error behavior different than the default.")
    public void ErrorOccurred(Component component, String functionName, int errorNumber, String message) {
        String componentType = component.getClass().getName();
        componentType = componentType.substring(componentType.lastIndexOf(".") + 1);
        Log.e((String)LOG_TAG, (String)("Form " + this.formName + " ErrorOccurred, errorNumber = " + errorNumber + ", componentType = " + componentType + ", functionName = " + functionName + ", messages = " + message));
        if (!EventDispatcher.dispatchEvent(this, "ErrorOccurred", component, functionName, errorNumber, message) && this.screenInitialized) {
            new Notifier((ComponentContainer)this).ShowAlert("Error " + errorNumber + ": " + message);
        }
    }

    public void ErrorOccurredDialog(Component component, String functionName, int errorNumber, String message, String title, String buttonText) {
        String componentType = component.getClass().getName();
        componentType = componentType.substring(componentType.lastIndexOf(".") + 1);
        Log.e((String)LOG_TAG, (String)("Form " + this.formName + " ErrorOccurred, errorNumber = " + errorNumber + ", componentType = " + componentType + ", functionName = " + functionName + ", messages = " + message));
        if (!EventDispatcher.dispatchEvent(this, "ErrorOccurred", component, functionName, errorNumber, message) && this.screenInitialized) {
            new Notifier((ComponentContainer)this).ShowMessageDialog("Error " + errorNumber + ": " + message, title, buttonText);
        }
    }

    public void dispatchErrorOccurredEvent(final Component component, final String functionName, final int errorNumber, final Object ... messageArgs) {
        this.runOnUiThread(new Runnable(){

            public void run() {
                String message = ErrorMessages.formatMessage(errorNumber, messageArgs);
                Form.this.ErrorOccurred(component, functionName, errorNumber, message);
            }
        });
    }

    public void dispatchErrorOccurredEventDialog(final Component component, final String functionName, final int errorNumber, final Object ... messageArgs) {
        this.runOnUiThread(new Runnable(){

            public void run() {
                String message = ErrorMessages.formatMessage(errorNumber, messageArgs);
                Form.this.ErrorOccurredDialog(component, functionName, errorNumber, message, "Error in " + functionName, "Dismiss");
            }
        });
    }

    public void runtimeFormErrorOccurredEvent(String functionName, int errorNumber, String message) {
        Log.d((String)"FORM_RUNTIME_ERROR", (String)("functionName is " + functionName));
        Log.d((String)"FORM_RUNTIME_ERROR", (String)("errorNumber is " + errorNumber));
        Log.d((String)"FORM_RUNTIME_ERROR", (String)("message is " + message));
        this.dispatchErrorOccurredEvent(activeForm, functionName, errorNumber, message);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="When checked, there will be a vertical scrollbar on the screen, and the height of the application can exceed the physical height of the device. When unchecked, the application height is constrained to the height of the device.")
    public boolean Scrollable() {
        return this.scrollable;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void Scrollable(boolean scrollable) {
        if (this.scrollable == scrollable && this.frameLayout != null) {
            return;
        }
        this.scrollable = scrollable;
        this.recomputeLayout();
    }

    private void recomputeLayout() {
        Log.d((String)LOG_TAG, (String)"recomputeLayout called");
        if (this.frameLayout != null) {
            this.frameLayout.removeAllViews();
        }
        this.frameLayout = this.scrollable ? new ScrollView((Context)this) : new FrameLayout((Context)this);
        this.frameLayout.addView((View)this.viewLayout.getLayoutManager(), new ViewGroup.LayoutParams(-1, -1));
        this.setBackground((View)this.frameLayout);
        Log.d((String)LOG_TAG, (String)"About to create a new ScaledFrameLayout");
        this.scaleLayout = new ScaledFrameLayout((Context)this);
        this.scaleLayout.addView((View)this.frameLayout, new ViewGroup.LayoutParams(-1, -1));
        this.setContentView((View)this.scaleLayout);
        this.frameLayout.getViewTreeObserver().addOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
        this.scaleLayout.requestLayout();
        this.androidUIHandler.post(new Runnable(){

            public void run() {
                if (Form.this.frameLayout != null && Form.this.frameLayout.getWidth() != 0 && Form.this.frameLayout.getHeight() != 0) {
                    if (sCompatibilityMode) {
                        Form.this.Sizing("Fixed");
                    } else {
                        Form.this.Sizing("Responsive");
                    }
                    Form.this.ReplayFormOrientation();
                    Form.this.frameLayout.requestLayout();
                } else {
                    Form.this.androidUIHandler.post((Runnable)this);
                }
            }
        });
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public int BackgroundColor() {
        return this.backgroundColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&HFFFFFFFF")
    @SimpleProperty
    public void BackgroundColor(int argb) {
        this.backgroundColor = argb;
        this.setBackground((View)this.frameLayout);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The screen background image.")
    public String BackgroundImage() {
        return this.backgroundImagePath;
    }

    @DesignerProperty(editorType="asset", defaultValue="")
    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The screen background image.")
    public void BackgroundImage(String path) {
        this.backgroundImagePath = path == null ? "" : path;
        try {
            this.backgroundDrawable = MediaUtil.getBitmapDrawable(this, this.backgroundImagePath);
        }
        catch (IOException ioe) {
            Log.e((String)LOG_TAG, (String)("Unable to load " + this.backgroundImagePath));
            this.backgroundDrawable = null;
        }
        this.setBackground((View)this.frameLayout);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The caption for the form, which apears in the title bar")
    public String Title() {
        return this.getTitle().toString();
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void Title(String title) {
        this.setTitle(title);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Information about the screen.  It appears when \"About this Application\" is selected from the system menu. Use it to inform people about your app.  In multiple screen apps, each screen has its own AboutScreen info.")
    public String AboutScreen() {
        return this.aboutScreen;
    }

    @DesignerProperty(editorType="textArea", defaultValue="")
    @SimpleProperty
    public void AboutScreen(String aboutScreen) {
        this.aboutScreen = aboutScreen;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The title bar is the top gray bar on the screen. This property reports whether the title bar is visible.")
    public boolean TitleVisible() {
        return this.showTitle;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public void TitleVisible(boolean show) {
        View v;
        if (show != this.showTitle && (v = (View)this.findViewById(16908310).getParent()) != null) {
            if (show) {
                v.setVisibility(0);
            } else {
                v.setVisibility(8);
            }
            this.showTitle = show;
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The status bar is the topmost bar on the screen. This property reports whether the status bar is visible.")
    public boolean ShowStatusBar() {
        return this.showStatusBar;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public void ShowStatusBar(boolean show) {
        if (show != this.showStatusBar) {
            if (show) {
                this.getWindow().addFlags(2048);
                this.getWindow().clearFlags(1024);
            } else {
                this.getWindow().addFlags(1024);
                this.getWindow().clearFlags(2048);
            }
            this.showStatusBar = show;
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The requested screen orientation, specified as a text value.  Commonly used values are landscape, portrait, sensor, user and unspecified.  See the Android developer documentation for ActivityInfo.Screen_Orientation for the complete list of possible settings.")
    public String ScreenOrientation() {
        switch (this.getRequestedOrientation()) {
            case 3: {
                return "behind";
            }
            case 0: {
                return "landscape";
            }
            case 5: {
                return "nosensor";
            }
            case 1: {
                return "portrait";
            }
            case 4: {
                return "sensor";
            }
            case -1: {
                return "unspecified";
            }
            case 2: {
                return "user";
            }
            case 10: {
                return "fullSensor";
            }
            case 8: {
                return "reverseLandscape";
            }
            case 9: {
                return "reversePortrait";
            }
            case 6: {
                return "sensorLandscape";
            }
            case 7: {
                return "sensorPortrait";
            }
        }
        return "unspecified";
    }

    @DesignerProperty(editorType="screen_orientation", defaultValue="unspecified")
    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public void ScreenOrientation(String screenOrientation) {
        if (screenOrientation.equalsIgnoreCase("behind")) {
            this.setRequestedOrientation(3);
        } else if (screenOrientation.equalsIgnoreCase("landscape")) {
            this.setRequestedOrientation(0);
        } else if (screenOrientation.equalsIgnoreCase("nosensor")) {
            this.setRequestedOrientation(5);
        } else if (screenOrientation.equalsIgnoreCase("portrait")) {
            this.setRequestedOrientation(1);
        } else if (screenOrientation.equalsIgnoreCase("sensor")) {
            this.setRequestedOrientation(4);
        } else if (screenOrientation.equalsIgnoreCase("unspecified")) {
            this.setRequestedOrientation(-1);
        } else if (screenOrientation.equalsIgnoreCase("user")) {
            this.setRequestedOrientation(2);
        } else if (SdkLevel.getLevel() >= 9) {
            if (screenOrientation.equalsIgnoreCase("fullSensor")) {
                this.setRequestedOrientation(10);
            } else if (screenOrientation.equalsIgnoreCase("reverseLandscape")) {
                this.setRequestedOrientation(8);
            } else if (screenOrientation.equalsIgnoreCase("reversePortrait")) {
                this.setRequestedOrientation(9);
            } else if (screenOrientation.equalsIgnoreCase("sensorLandscape")) {
                this.setRequestedOrientation(6);
            } else if (screenOrientation.equalsIgnoreCase("sensorPortrait")) {
                this.setRequestedOrientation(7);
            } else {
                this.dispatchErrorOccurredEvent(this, "ScreenOrientation", 901, screenOrientation);
            }
        } else {
            this.dispatchErrorOccurredEvent(this, "ScreenOrientation", 901, screenOrientation);
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="A number that encodes how contents of the screen are aligned  horizontally. The choices are: 1 = left aligned, 2 = horizontally centered,  3 = right aligned.")
    public int AlignHorizontal() {
        return this.horizontalAlignment;
    }

    @DesignerProperty(editorType="horizontal_alignment", defaultValue="1")
    @SimpleProperty
    public void AlignHorizontal(int alignment) {
        try {
            this.alignmentSetter.setHorizontalAlignment(alignment);
            this.horizontalAlignment = alignment;
        }
        catch (IllegalArgumentException e) {
            this.dispatchErrorOccurredEvent(this, "HorizontalAlignment", 1401, alignment);
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="A number that encodes how the contents of the arrangement are aligned vertically. The choices are: 1 = aligned at the top, 2 = vertically centered, 3 = aligned at the bottom. Vertical alignment has no effect if the screen is scrollable.")
    public int AlignVertical() {
        return this.verticalAlignment;
    }

    @DesignerProperty(editorType="vertical_alignment", defaultValue="1")
    @SimpleProperty
    public void AlignVertical(int alignment) {
        try {
            this.alignmentSetter.setVerticalAlignment(alignment);
            this.verticalAlignment = alignment;
        }
        catch (IllegalArgumentException e) {
            this.dispatchErrorOccurredEvent(this, "VerticalAlignment", 1402, alignment);
        }
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The animation for switching to another screen. Valid options are default, fade, zoom, slidehorizontal, slidevertical, and none")
    public String OpenScreenAnimation() {
        return this.openAnimType;
    }

    @DesignerProperty(editorType="screen_animation", defaultValue="default")
    @SimpleProperty
    public void OpenScreenAnimation(String animType) {
        if (animType != "default" && animType != "fade" && animType != "zoom" && animType != "slidehorizontal" && animType != "slidevertical" && animType != "none") {
            this.dispatchErrorOccurredEvent(this, "Screen", 905, animType);
            return;
        }
        this.openAnimType = animType;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="The animation for closing current screen and returning  to the previous screen. Valid options are default, fade, zoom, slidehorizontal, slidevertical, and none")
    public String CloseScreenAnimation() {
        return this.closeAnimType;
    }

    @DesignerProperty(editorType="screen_animation", defaultValue="default")
    @SimpleProperty
    public void CloseScreenAnimation(String animType) {
        if (animType != "default" && animType != "fade" && animType != "zoom" && animType != "slidehorizontal" && animType != "slidevertical" && animType != "none") {
            this.dispatchErrorOccurredEvent(this, "Screen", 905, animType);
            return;
        }
        this.closeAnimType = animType;
    }

    public String getOpenAnimType() {
        return this.openAnimType;
    }

    @DesignerProperty(editorType="asset", defaultValue="")
    @SimpleProperty(userVisible=false)
    public void Icon(String name) {
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="1")
    @SimpleProperty(userVisible=false, description="An integer value which must be incremented each time a new Android Application Package File (APK) is created for the Google Play Store.")
    public void VersionCode(int vCode) {
    }

    @DesignerProperty(editorType="string", defaultValue="1.0")
    @SimpleProperty(userVisible=false, description="A string which can be changed to allow Google Play Store users to distinguish between different versions of the App.")
    public void VersionName(String vName) {
    }

    @DesignerProperty(editorType="sizing", defaultValue="Fixed")
    @SimpleProperty(userVisible=false, description="If set to fixed,  screen layouts will be created for a single fixed-size screen and autoscaled. If set to responsive, screen layouts will use the actual resolution of the device.  See the documentation on responsive design in App Inventor for more information. This property appears on Screen1 only and controls the sizing for all screens in the app.")
    public void Sizing(String value) {
        Log.d((String)LOG_TAG, (String)("Sizing(" + value + ")"));
        this.formWidth = (int)((float)this.getResources().getDisplayMetrics().widthPixels / this.deviceDensity);
        this.formHeight = (int)((float)this.getResources().getDisplayMetrics().heightPixels / this.deviceDensity);
        if (value.equals("Fixed")) {
            sCompatibilityMode = true;
            this.formWidth = (int)((float)this.formWidth / this.compatScalingFactor);
            this.formHeight = (int)((float)this.formHeight / this.compatScalingFactor);
        } else {
            sCompatibilityMode = false;
        }
        this.scaleLayout.setScale(sCompatibilityMode ? this.compatScalingFactor : 1.0f);
        if (this.frameLayout != null) {
            this.frameLayout.invalidate();
        }
        Log.d((String)LOG_TAG, (String)("formWidth = " + this.formWidth + " formHeight = " + this.formHeight));
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty(userVisible=false, description="This is the display name of the installed application in the phone.If the AppName is blank, it will be set to the name of the project when the project is built.")
    public void AppName(String aName) {
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Screen width (x-size).")
    public int Width() {
        Log.d((String)LOG_TAG, (String)("Form.Width = " + this.formWidth));
        return this.formWidth;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Screen height (y-size).")
    public int Height() {
        Log.d((String)LOG_TAG, (String)("Form.Height = " + this.formHeight));
        return this.formHeight;
    }

    public static void switchForm(String nextFormName) {
        if (activeForm == null) {
            throw new IllegalStateException("activeForm is null");
        }
        activeForm.startNewForm(nextFormName, null);
    }

    public static void switchFormWithStartValue(String nextFormName, Object startValue) {
        Log.i((String)LOG_TAG, (String)("Open another screen with start value:" + nextFormName));
        if (activeForm == null) {
            throw new IllegalStateException("activeForm is null");
        }
        activeForm.startNewForm(nextFormName, startValue);
    }

    protected void startNewForm(String nextFormName, Object startupValue) {
        String jValue;
        String functionName;
        Log.i((String)LOG_TAG, (String)("startNewForm:" + nextFormName));
        Intent activityIntent = new Intent();
        activityIntent.setClassName((Context)this, this.getPackageName() + "." + nextFormName);
        String string2 = functionName = startupValue == null ? "open another screen" : "open another screen with start value";
        if (startupValue != null) {
            Log.i((String)LOG_TAG, (String)("StartNewForm about to JSON encode:" + startupValue));
            jValue = Form.jsonEncodeForForm(startupValue, functionName);
            Log.i((String)LOG_TAG, (String)("StartNewForm got JSON encoding:" + jValue));
        } else {
            jValue = "";
        }
        activityIntent.putExtra(ARGUMENT_NAME, jValue);
        this.nextFormName = nextFormName;
        Log.i((String)LOG_TAG, (String)("about to start new form" + nextFormName));
        try {
            Log.i((String)LOG_TAG, (String)("startNewForm starting activity:" + activityIntent));
            this.startActivityForResult(activityIntent, 1);
            AnimationUtil.ApplyOpenScreenAnimation(this, this.openAnimType);
        }
        catch (ActivityNotFoundException e) {
            this.dispatchErrorOccurredEvent(this, functionName, 902, nextFormName);
        }
    }

    protected static String jsonEncodeForForm(Object value, String functionName) {
        String jsonResult = "";
        Log.i((String)LOG_TAG, (String)("jsonEncodeForForm -- creating JSON representation:" + value.toString()));
        try {
            jsonResult = JsonUtil.getJsonRepresentation(value);
            Log.i((String)LOG_TAG, (String)("jsonEncodeForForm -- got JSON representation:" + jsonResult));
        }
        catch (JSONException e) {
            activeForm.dispatchErrorOccurredEvent(activeForm, functionName, 904, value.toString());
        }
        return jsonResult;
    }

    @SimpleEvent(description="Event raised when another screen has closed and control has returned to this screen.")
    public void OtherScreenClosed(String otherScreenName, Object result) {
        Log.i((String)LOG_TAG, (String)("Form " + this.formName + " OtherScreenClosed, otherScreenName = " + otherScreenName + ", result = " + result.toString()));
        EventDispatcher.dispatchEvent(this, "OtherScreenClosed", otherScreenName, result);
    }

    public HandlesEventDispatching getDispatchDelegate() {
        return this;
    }

    public Activity $context() {
        return this;
    }

    public Form $form() {
        return this;
    }

    public void $add(AndroidViewComponent component) {
        this.viewLayout.add(component);
    }

    public float deviceDensity() {
        return this.deviceDensity;
    }

    public float compatScalingFactor() {
        return this.compatScalingFactor;
    }

    public void setChildWidth(final AndroidViewComponent component, int width) {
        int cWidth = this.Width();
        if (cWidth == 0) {
            final int fWidth = width;
            this.androidUIHandler.postDelayed(new Runnable(){

                public void run() {
                    System.err.println("(Form)Width not stable yet... trying again");
                    Form.this.setChildWidth(component, fWidth);
                }
            }, 100L);
        }
        System.err.println("Form.setChildWidth(): width = " + width + " parent Width = " + cWidth + " child = " + component);
        if (width <= -1000) {
            width = cWidth * -(width - -1000) / 100;
        }
        component.setLastWidth(width);
        ViewUtil.setChildWidthForVerticalLayout(component.getView(), width);
    }

    public void setChildHeight(final AndroidViewComponent component, int height) {
        int cHeight = this.Height();
        if (cHeight == 0) {
            final int fHeight = height;
            this.androidUIHandler.postDelayed(new Runnable(){

                public void run() {
                    System.err.println("(Form)Height not stable yet... trying again");
                    Form.this.setChildHeight(component, fHeight);
                }
            }, 100L);
        }
        if (height <= -1000) {
            height = this.Height() * -(height - -1000) / 100;
        }
        component.setLastHeight(height);
        ViewUtil.setChildHeightForVerticalLayout(component.getView(), height);
    }

    public static Form getActiveForm() {
        return activeForm;
    }

    public static String getStartText() {
        if (activeForm != null) {
            return Form.activeForm.startupValue;
        }
        throw new IllegalStateException("activeForm is null");
    }

    public static Object getStartValue() {
        if (activeForm != null) {
            return Form.decodeJSONStringForForm(Form.activeForm.startupValue, "get start value");
        }
        throw new IllegalStateException("activeForm is null");
    }

    public static void finishActivity() {
        if (activeForm == null) {
            throw new IllegalStateException("activeForm is null");
        }
        activeForm.closeForm(null);
    }

    public static void finishActivityWithResult(Object result) {
        if (activeForm != null) {
            if (activeForm instanceof ReplForm) {
                ((ReplForm)activeForm).setResult(result);
                activeForm.closeForm(null);
            } else {
                String jString = Form.jsonEncodeForForm(result, "close screen with value");
                Intent resultIntent = new Intent();
                resultIntent.putExtra(RESULT_NAME, jString);
                activeForm.closeForm(resultIntent);
            }
        } else {
            throw new IllegalStateException("activeForm is null");
        }
    }

    public static void finishActivityWithTextResult(String result) {
        if (activeForm == null) {
            throw new IllegalStateException("activeForm is null");
        }
        Intent resultIntent = new Intent();
        resultIntent.putExtra(RESULT_NAME, result);
        activeForm.closeForm(resultIntent);
    }

    protected void closeForm(Intent resultIntent) {
        if (resultIntent != null) {
            this.setResult(-1, resultIntent);
        }
        this.finish();
        AnimationUtil.ApplyCloseScreenAnimation(this, this.closeAnimType);
    }

    public static void finishApplication() {
        if (activeForm == null) {
            throw new IllegalStateException("activeForm is null");
        }
        activeForm.closeApplicationFromBlocks();
    }

    protected void closeApplicationFromBlocks() {
        this.closeApplication();
    }

    private void closeApplicationFromMenu() {
        this.closeApplication();
    }

    private void closeApplication() {
        applicationIsBeingClosed = true;
        this.finish();
        if (this.formName.equals("Screen1")) {
            System.exit(0);
        }
    }

    public boolean onCreateOptionsMenu(Menu menu) {
        super.onCreateOptionsMenu(menu);
        this.addExitButtonToMenu(menu);
        this.addAboutInfoToMenu(menu);
        for (OnCreateOptionsMenuListener onCreateOptionsMenuListener : this.onCreateOptionsMenuListeners) {
            onCreateOptionsMenuListener.onCreateOptionsMenu(menu);
        }
        return true;
    }

    public void addExitButtonToMenu(Menu menu) {
        MenuItem stopApplicationItem = menu.add(0, 0, 1, (CharSequence)"Stop this application").setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                Form.this.showExitApplicationNotification();
                return true;
            }
        });
        stopApplicationItem.setIcon(17301594);
    }

    public void addAboutInfoToMenu(Menu menu) {
        MenuItem aboutAppItem = menu.add(0, 0, 2, (CharSequence)"About this application").setOnMenuItemClickListener(new MenuItem.OnMenuItemClickListener(){

            public boolean onMenuItemClick(MenuItem item) {
                Form.this.showAboutApplicationNotification();
                return true;
            }
        });
        aboutAppItem.setIcon(17301651);
    }

    public boolean onOptionsItemSelected(MenuItem item) {
        for (OnOptionsItemSelectedListener onOptionsItemSelectedListener : this.onOptionsItemSelectedListeners) {
            if (!onOptionsItemSelectedListener.onOptionsItemSelected(item)) continue;
            return true;
        }
        return false;
    }

    private void showExitApplicationNotification() {
        String title = "Stop application?";
        String message = "Stop this application and exit? You'll need to relaunch the application to use it again.";
        String positiveButton = "Stop and exit";
        String negativeButton = "Don't stop";
        Runnable stopApplication = new Runnable(){

            public void run() {
                Form.this.closeApplicationFromMenu();
            }
        };
        Runnable doNothing = new Runnable(){

            public void run() {
            }
        };
        Notifier.twoButtonDialog(this, message, title, positiveButton, negativeButton, false, stopApplication, doNothing, doNothing);
    }

    void setYandexTranslateTagline() {
        this.yandexTranslateTagline = "<p><small>Language translation powered by Yandex.Translate</small></p>";
    }

    private void showAboutApplicationNotification() {
        String title = "About this app";
        String MITtagline = "<p><small><em>Invented with MIT App Inventor<br>appinventor.mit.edu</em></small></p>";
        String message = this.aboutScreen + MITtagline + this.yandexTranslateTagline;
        message = message.replaceAll("\\n", "<br>");
        String buttonText = "Got it";
        Notifier.oneButtonAlert(this, message, title, buttonText);
    }

    public void clear() {
        this.viewLayout.getLayoutManager().removeAllViews();
        this.frameLayout.removeAllViews();
        this.frameLayout = null;
        this.defaultPropertyValues();
        this.onStopListeners.clear();
        this.onNewIntentListeners.clear();
        this.onResumeListeners.clear();
        this.onPauseListeners.clear();
        this.onDestroyListeners.clear();
        this.onInitializeListeners.clear();
        this.onCreateOptionsMenuListeners.clear();
        this.onOptionsItemSelectedListeners.clear();
        this.screenInitialized = false;
        System.err.println("Form.clear() About to do moby GC!");
        System.gc();
        this.dimChanges.clear();
    }

    public void deleteComponent(Object component) {
        OnOptionsItemSelectedListener onOptionsItemSelectedListener;
        OnCreateOptionsMenuListener onCreateOptionsMenuListener;
        OnInitializeListener onInitializeListener;
        OnDestroyListener onDestroyListener;
        OnPauseListener onPauseListener;
        OnResumeListener onResumeListener;
        OnNewIntentListener onNewIntentListener;
        OnStopListener onStopListener;
        if (component instanceof OnStopListener && this.onStopListeners.contains(onStopListener = (OnStopListener)component)) {
            this.onStopListeners.remove(onStopListener);
        }
        if (component instanceof OnNewIntentListener && this.onNewIntentListeners.contains(onNewIntentListener = (OnNewIntentListener)component)) {
            this.onNewIntentListeners.remove(onNewIntentListener);
        }
        if (component instanceof OnResumeListener && this.onResumeListeners.contains(onResumeListener = (OnResumeListener)component)) {
            this.onResumeListeners.remove(onResumeListener);
        }
        if (component instanceof OnPauseListener && this.onPauseListeners.contains(onPauseListener = (OnPauseListener)component)) {
            this.onPauseListeners.remove(onPauseListener);
        }
        if (component instanceof OnDestroyListener && this.onDestroyListeners.contains(onDestroyListener = (OnDestroyListener)component)) {
            this.onDestroyListeners.remove(onDestroyListener);
        }
        if (component instanceof OnInitializeListener && this.onInitializeListeners.contains(onInitializeListener = (OnInitializeListener)component)) {
            this.onInitializeListeners.remove(onInitializeListener);
        }
        if (component instanceof OnCreateOptionsMenuListener && this.onCreateOptionsMenuListeners.contains(onCreateOptionsMenuListener = (OnCreateOptionsMenuListener)component)) {
            this.onCreateOptionsMenuListeners.remove(onCreateOptionsMenuListener);
        }
        if (component instanceof OnOptionsItemSelectedListener && this.onOptionsItemSelectedListeners.contains(onOptionsItemSelectedListener = (OnOptionsItemSelectedListener)component)) {
            this.onOptionsItemSelectedListeners.remove(onOptionsItemSelectedListener);
        }
        if (component instanceof Deleteable) {
            ((Deleteable)component).onDelete();
        }
    }

    public void dontGrabTouchEventsForComponent() {
        this.frameLayout.requestDisallowInterceptTouchEvent(true);
    }

    protected boolean toastAllowed() {
        long now = System.nanoTime();
        if (now > this.lastToastTime + minimumToastWait) {
            this.lastToastTime = now;
            return true;
        }
        return false;
    }

    public void callInitialize(Object component) throws Throwable {
        Method method;
        try {
            method = component.getClass().getMethod("Initialize", null);
        }
        catch (SecurityException e) {
            Log.i((String)LOG_TAG, (String)("Security exception " + e.getMessage()));
            return;
        }
        catch (NoSuchMethodException e) {
            return;
        }
        try {
            Log.i((String)LOG_TAG, (String)("calling Initialize method for Object " + component.toString()));
            method.invoke(component, (Object[])null);
        }
        catch (InvocationTargetException e) {
            Log.i((String)LOG_TAG, (String)("invoke exception: " + e.getMessage()));
            throw e.getTargetException();
        }
    }

    public synchronized Bundle fullScreenVideoAction(int action, VideoPlayer source, Object data) {
        return this.fullScreenVideoUtil.performAction(action, source, data);
    }

    private void setBackground(View bgview) {
        Drawable setDraw = this.backgroundDrawable;
        if (this.backgroundImagePath != "" && setDraw != null) {
            setDraw = this.backgroundDrawable.getConstantState().newDrawable();
            setDraw.setColorFilter(this.backgroundColor != 0 ? this.backgroundColor : -1, PorterDuff.Mode.DST_OVER);
        } else {
            setDraw = new ColorDrawable(this.backgroundColor != 0 ? this.backgroundColor : -1);
        }
        ViewUtil.setBackgroundImage(bgview, setDraw);
        bgview.invalidate();
    }

    public static boolean getCompatibilityMode() {
        return sCompatibilityMode;
    }

    @SimpleFunction(description="Hide the onscreen soft keyboard.")
    public void HideKeyboard() {
        View view = this.getCurrentFocus();
        if (view != null) {
            InputMethodManager imm = (InputMethodManager)this.getSystemService("input_method");
            imm.hideSoftInputFromWindow(view.getWindowToken(), 0);
        } else {
            this.dispatchErrorOccurredEvent(this, "HideKeyboard", 906, new Object[0]);
        }
    }

    static {
        nextRequestCode = 2;
        minimumToastWait = 10000000000L;
        _initialized = false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class MultiDexInstaller
    extends AsyncTask<Form, Void, Boolean> {
        Form ourForm;

        private MultiDexInstaller() {
        }

        protected Boolean doInBackground(Form ... form) {
            this.ourForm = form[0];
            Log.d((String)Form.LOG_TAG, (String)"Doing Full MultiDex Install");
            MultiDex.install((Context)this.ourForm, true);
            return true;
        }

        protected void onPostExecute(Boolean v) {
            this.ourForm.onCreateFinish();
        }
    }

    public static class PercentStorageRecord {
        AndroidViewComponent component;
        int length;
        Dim dim;

        public PercentStorageRecord(AndroidViewComponent component, int length, Dim dim) {
            this.component = component;
            this.length = length;
            this.dim = dim;
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum Dim {
            HEIGHT,
            WIDTH;

        }
    }
}

