/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.util.Log;
import com.firebase.client.AuthData;
import com.firebase.client.ChildEventListener;
import com.firebase.client.Config;
import com.firebase.client.DataSnapshot;
import com.firebase.client.Firebase;
import com.firebase.client.FirebaseError;
import com.firebase.client.MutableData;
import com.firebase.client.Transaction;
import com.firebase.client.ValueEventListener;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesLibraries;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.Notifier;
import com.google.appinventor.components.runtime.errors.YailRuntimeError;
import com.google.appinventor.components.runtime.util.JsonUtil;
import com.google.appinventor.components.runtime.util.SdkLevel;
import com.google.appinventor.components.runtime.util.YailList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.json.JSONException;

@DesignerComponent(version=3, description="Non-visible component that communicates with Firebase to store and retrieve information.", designerHelpDescription="Non-visible component that communicates with a Firebase to store and retrieve information.", category=ComponentCategory.EXPERIMENTAL, nonVisible=true, iconName="images/firebaseDB.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET")
@UsesLibraries(libraries="firebase.jar")
public class FirebaseDB
extends AndroidNonvisibleComponent
implements Component {
    private static final String LOG_TAG = "Firebase";
    private String firebaseURL = null;
    private String defaultURL = null;
    private boolean useDefault = true;
    private String developerBucket;
    private String projectBucket;
    private String firebaseToken;
    private static boolean isInitialized = false;
    private static boolean persist = false;
    private Handler androidUIHandler = new Handler();
    private final Activity activity;
    private Firebase myFirebase;
    private ChildEventListener childListener;
    private Firebase.AuthStateListener authListener;

    public FirebaseDB(ComponentContainer container) {
        super(container.$form());
        this.activity = container.$context();
        Firebase.setAndroidContext((Context)this.activity);
        this.developerBucket = "";
        this.projectBucket = "";
        this.firebaseToken = "";
        this.childListener = new ChildEventListener(){

            public void onChildAdded(final DataSnapshot snapshot, String previousChildKey) {
                FirebaseDB.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        FirebaseDB.this.DataChanged(snapshot.getKey(), snapshot.getValue());
                    }
                });
            }

            public void onCancelled(final FirebaseError error) {
                FirebaseDB.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        FirebaseDB.this.FirebaseError(error.getMessage());
                    }
                });
            }

            public void onChildChanged(final DataSnapshot snapshot, String previousChildKey) {
                FirebaseDB.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        FirebaseDB.this.DataChanged(snapshot.getKey(), snapshot.getValue());
                    }
                });
            }

            public void onChildMoved(DataSnapshot snapshot, String previousChildKey) {
            }

            public void onChildRemoved(DataSnapshot snapshot) {
                Log.i((String)FirebaseDB.LOG_TAG, (String)("onChildRemoved: " + snapshot.getKey() + " removed."));
            }
        };
        this.authListener = new Firebase.AuthStateListener(){

            public void onAuthStateChanged(AuthData data) {
                Log.i((String)FirebaseDB.LOG_TAG, (String)("onAuthStateChanged: data = " + data));
                if (data == null) {
                    FirebaseDB.this.myFirebase.authWithCustomToken(FirebaseDB.this.firebaseToken, new Firebase.AuthResultHandler(){

                        public void onAuthenticated(AuthData authData) {
                            Log.i((String)FirebaseDB.LOG_TAG, (String)"Auth Successful.");
                        }

                        public void onAuthenticationError(FirebaseError error) {
                            Log.e((String)FirebaseDB.LOG_TAG, (String)("Auth Failed: " + error.getMessage()));
                        }
                    });
                }
            }
        };
    }

    public void Initialize() {
        Log.i((String)LOG_TAG, (String)"Initalize called!");
        isInitialized = true;
        this.resetListener();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Gets the URL for this FirebaseDB.", userVisible=false)
    public String FirebaseURL() {
        if (this.useDefault) {
            return "DEFAULT";
        }
        return this.firebaseURL;
    }

    @DesignerProperty(editorType="FirbaseURL", defaultValue="DEFAULT")
    @SimpleProperty(description="Sets the URL for this FirebaseDB.")
    public void FirebaseURL(String url) {
        if (url.equals("DEFAULT")) {
            if (!this.useDefault) {
                this.useDefault = true;
                if (this.defaultURL == null) {
                    Log.d((String)LOG_TAG, (String)"FirebaseURL called before DefaultURL (should not happen!)");
                } else {
                    this.firebaseURL = this.defaultURL;
                    this.resetListener();
                }
            } else {
                this.firebaseURL = this.defaultURL;
            }
        } else {
            this.useDefault = false;
            if (this.firebaseURL.equals(url = url + (url.endsWith("/") ? "" : "/"))) {
                return;
            }
            this.firebaseURL = url;
            this.useDefault = false;
            this.resetListener();
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, userVisible=false)
    public String DeveloperBucket() {
        return this.developerBucket;
    }

    @DesignerProperty(editorType="string")
    @SimpleProperty
    public void DeveloperBucket(String bucket) {
        this.developerBucket = bucket;
        this.resetListener();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Gets the ProjectBucket for this FirebaseDB.")
    public String ProjectBucket() {
        return this.projectBucket;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty(description="Sets the ProjectBucket for this FirebaseDB.")
    public void ProjectBucket(String bucket) {
        if (!this.projectBucket.equals(bucket)) {
            this.projectBucket = bucket;
            this.resetListener();
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, userVisible=false)
    public String FirebaseToken() {
        return this.firebaseToken;
    }

    @DesignerProperty(editorType="string")
    @SimpleProperty
    public void FirebaseToken(String JWT) {
        this.firebaseToken = JWT;
        this.resetListener();
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(userVisible=false, description="If true, variables will retain their values when off-line and the App exits. Values will be uploaded to Firebase the next time the App is run while connected to the network. This is useful for applications which will gather data while not connected to the network. Note: AppendValue and RemoveFirst will not work correctly when off-line, they require a network connection.<br/><br/> <i>Note</i>: If you set Persist on any Firebase component, on any screen, it makes all Firebase components on all screens persistent. This is a limitation of the low level Firebase library. Also be aware that if you want to set persist to true, you should do so before connecting the Companion for incremental development.")
    public void Persist(boolean value) {
        Log.i((String)LOG_TAG, (String)("Persist Called: Value = " + value));
        if (persist != value) {
            if (isInitialized) {
                throw new RuntimeException("You cannot change the Persist value of Firebase after Application Initialization, this includes the Companion");
            }
            Config config = Firebase.getDefaultConfig();
            config.setPersistenceEnabled(value);
            Firebase.setDefaultConfig((Config)config);
            persist = value;
            this.resetListener();
        }
    }

    private void resetListener() {
        if (!isInitialized) {
            return;
        }
        if (this.myFirebase != null) {
            this.myFirebase.removeEventListener(this.childListener);
            this.myFirebase.removeAuthStateListener(this.authListener);
        }
        this.myFirebase = null;
        this.connectFirebase();
    }

    @SimpleFunction(description="Remove the tag from Firebase")
    public void ClearTag(String tag) {
        this.myFirebase.child(tag).removeValue();
    }

    @SimpleFunction
    public void StoreValue(String tag, Object valueToStore) {
        try {
            if (valueToStore != null) {
                valueToStore = JsonUtil.getJsonRepresentation(valueToStore);
            }
        }
        catch (JSONException e) {
            throw new YailRuntimeError("Value failed to convert to JSON.", "JSON Creation Error.");
        }
        this.myFirebase.child(tag).setValue(valueToStore);
    }

    @SimpleFunction
    public void GetValue(final String tag, final Object valueIfTagNotThere) {
        this.myFirebase.child(tag).addListenerForSingleValueEvent(new ValueEventListener(){

            public void onDataChange(DataSnapshot snapshot) {
                final AtomicReference<Object> value = new AtomicReference<Object>();
                try {
                    if (snapshot.exists()) {
                        value.set(snapshot.getValue());
                    } else {
                        value.set(JsonUtil.getJsonRepresentation(valueIfTagNotThere));
                    }
                }
                catch (JSONException e) {
                    throw new YailRuntimeError("Value failed to convert to JSON.", "JSON Creation Error.");
                }
                FirebaseDB.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        FirebaseDB.this.GotValue(tag, value.get());
                    }
                });
            }

            public void onCancelled(final FirebaseError error) {
                FirebaseDB.this.androidUIHandler.post(new Runnable(){

                    public void run() {
                        FirebaseDB.this.FirebaseError(error.getMessage());
                    }
                });
            }
        });
    }

    @SimpleEvent
    public void GotValue(String tag, Object value) {
        try {
            if (value != null && value instanceof String) {
                value = JsonUtil.getObjectFromJson((String)value);
            }
        }
        catch (JSONException e) {
            throw new YailRuntimeError("Value failed to convert from JSON.", "JSON Retrieval Error.");
        }
        EventDispatcher.dispatchEvent(this, "GotValue", tag, value);
    }

    @SimpleEvent
    public void DataChanged(String tag, Object value) {
        try {
            if (value != null && value instanceof String) {
                value = JsonUtil.getObjectFromJson((String)value);
            }
        }
        catch (JSONException e) {
            throw new YailRuntimeError("Value failed to convert from JSON.", "JSON Retrieval Error.");
        }
        EventDispatcher.dispatchEvent(this, "DataChanged", tag, value);
    }

    @SimpleEvent
    public void FirebaseError(String message) {
        Log.e((String)LOG_TAG, (String)message);
        boolean dispatched = EventDispatcher.dispatchEvent(this, "FirebaseError", message);
        if (!dispatched) {
            Notifier.oneButtonAlert(this.form, message, "FirebaseError", "Continue");
        }
    }

    private void connectFirebase() {
        if (SdkLevel.getLevel() < 10) {
            Notifier.oneButtonAlert(this.activity, "The version of Android on this device is too old to use Firebase.", "Android Too Old", "OK");
            return;
        }
        this.myFirebase = this.useDefault ? new Firebase(this.firebaseURL + "developers/" + this.developerBucket + this.projectBucket) : new Firebase(this.firebaseURL + this.projectBucket);
        this.myFirebase.addChildEventListener(this.childListener);
        this.myFirebase.addAuthStateListener(this.authListener);
    }

    @SimpleFunction(description="If you are having difficulty with the Companion and you are switching between different Firebase accounts, you may need to use this function to clear internal Firebase caches. You can just use the \"Do It\" function on this block in the blocks editor. Note: You should not normally need to use this block as part of an application.")
    public void Unauthenticate() {
        if (this.myFirebase == null) {
            this.connectFirebase();
        }
        this.myFirebase.unauth();
    }

    @DesignerProperty(editorType="string")
    @SimpleProperty(category=PropertyCategory.BEHAVIOR, userVisible=false)
    public void DefaultURL(String url) {
        this.defaultURL = url;
        if (this.useDefault) {
            this.firebaseURL = this.defaultURL;
            this.resetListener();
        }
    }

    @SimpleFunction(description="Return the first element of a list and atomically remove it. If two devices use this function simultaneously, one will get the first element and the the other will get the second element, or an error if there is no available element. When the element is available, the \"FirstRemoved\" event will be triggered.")
    public void RemoveFirst(String tag) {
        final ReturnVal result = new ReturnVal();
        Firebase firebaseChild = this.myFirebase.child(tag);
        Transactional toRun = new Transactional(null, null, result){

            Transaction.Result run(MutableData currentData) {
                Object value = currentData.getValue();
                if (value == null) {
                    result.err = "Previous value was empty.";
                    return Transaction.abort();
                }
                try {
                    if (!(value instanceof String)) {
                        result.err = "Invalid JSON object in database (shouldn't happen!)";
                        return Transaction.abort();
                    }
                    value = JsonUtil.getObjectFromJson((String)value);
                }
                catch (JSONException e) {
                    result.err = "Invalid JSON object in database (shouldn't happen!)";
                    return Transaction.abort();
                }
                if (value instanceof List) {
                    if (((List)value).isEmpty()) {
                        result.err = "The list was empty";
                        return Transaction.abort();
                    }
                    result.retval = ((List)value).remove(0);
                    try {
                        value = JsonUtil.getJsonRepresentation(YailList.makeList((List)value));
                    }
                    catch (JSONException e) {
                        result.err = "Could not convert value to JSON.";
                        return Transaction.abort();
                    }
                    currentData.setValue(value);
                    return Transaction.success((MutableData)currentData);
                }
                result.err = "You can only remove elements from a list.";
                return Transaction.abort();
            }
        };
        this.firebaseTransaction(toRun, firebaseChild, new Runnable(){

            public void run() {
                FirebaseDB.this.FirstRemoved(result.getRetval());
            }
        });
    }

    @SimpleFunction(description="Get the list of tags for this application. When complete a \"TagList\" event will be triggered with the list of known tags.")
    public void GetTagList() {
        Firebase zFireBase = this.myFirebase.child("");
        zFireBase.addListenerForSingleValueEvent(new ValueEventListener(){

            public void onDataChange(DataSnapshot data) {
                ArrayList value = data.getValue();
                if (value instanceof HashMap) {
                    value = new ArrayList(((HashMap)((Object)value)).keySet());
                    final List listValue = value;
                    FirebaseDB.this.androidUIHandler.post(new Runnable(){

                        public void run() {
                            FirebaseDB.this.TagList(listValue);
                        }
                    });
                }
            }

            public void onCancelled(FirebaseError error) {
            }
        });
    }

    @SimpleEvent(description="Event triggered when we have received the list of known tags. Used with the \"GetTagList\" Function.")
    public void TagList(List value) {
        EventDispatcher.dispatchEvent(this, "TagList", value);
    }

    @SimpleEvent(description="Event triggered by the \"RemoveFirst\" function. The argument \"value\" is the object that was the first in the list, and which is now removed.")
    public void FirstRemoved(Object value) {
        EventDispatcher.dispatchEvent(this, "FirstRemoved", value);
    }

    @SimpleFunction(description="Append a value to the end of a list atomically. If two devices use this function simultaneously, both will be appended and no data lost.")
    public void AppendValue(String tag, final Object valueToAdd) {
        final ReturnVal result = new ReturnVal();
        Firebase firebaseChild = this.myFirebase.child(tag);
        Transactional toRun = new Transactional(null, null, result){

            Transaction.Result run(MutableData currentData) {
                Object value = currentData.getValue();
                if (value == null) {
                    result.err = "Previous value was empty.";
                    return Transaction.abort();
                }
                try {
                    if (!(value instanceof String)) {
                        result.err = "Invalid JSON object in database (shouldn't happen!)";
                        return Transaction.abort();
                    }
                    value = JsonUtil.getObjectFromJson((String)value);
                }
                catch (JSONException e) {
                    result.err = "Invalid JSON object in database (shouldn't happen!)";
                    return Transaction.abort();
                }
                if (value instanceof List) {
                    ((List)value).add(valueToAdd);
                    try {
                        value = JsonUtil.getJsonRepresentation(YailList.makeList((List)value));
                    }
                    catch (JSONException e) {
                        result.err = "Could not convert value to JSON.";
                        return Transaction.abort();
                    }
                    currentData.setValue(value);
                    return Transaction.success((MutableData)currentData);
                }
                result.err = "You can only append to a list.";
                return Transaction.abort();
            }
        };
        this.firebaseTransaction(toRun, firebaseChild, null);
    }

    private void firebaseTransaction(final Transactional toRun, Firebase firebase, final Runnable whenDone) {
        final ReturnVal result = toRun.getResult();
        firebase.runTransaction(new Transaction.Handler(){

            public Transaction.Result doTransaction(MutableData currentData) {
                return toRun.run(currentData);
            }

            public void onComplete(final FirebaseError firebaseError, boolean committed, DataSnapshot currentData) {
                if (firebaseError != null) {
                    FirebaseDB.this.androidUIHandler.post(new Runnable(){

                        public void run() {
                            Log.i((String)FirebaseDB.LOG_TAG, (String)("AppendValue(onComplete): firebase: " + firebaseError.getMessage()));
                            Log.i((String)FirebaseDB.LOG_TAG, (String)("AppendValue(onComplete): result.err: " + result.err));
                            FirebaseDB.this.FirebaseError(firebaseError.getMessage());
                        }
                    });
                    return;
                }
                if (!committed) {
                    FirebaseDB.this.androidUIHandler.post(new Runnable(){

                        public void run() {
                            Log.i((String)FirebaseDB.LOG_TAG, (String)("AppendValue(!committed): result.err: " + result.err));
                            FirebaseDB.this.FirebaseError(result.err);
                        }
                    });
                } else if (whenDone != null) {
                    FirebaseDB.this.androidUIHandler.post(whenDone);
                }
            }
        });
    }

    private static abstract class Transactional {
        final Object arg1;
        final Object arg2;
        final ReturnVal retv;

        Transactional(Object arg1, Object arg2, ReturnVal retv) {
            this.arg1 = arg1;
            this.arg2 = arg2;
            this.retv = retv;
        }

        abstract Transaction.Result run(MutableData var1);

        ReturnVal getResult() {
            return this.retv;
        }
    }

    private static class ReturnVal {
        String err;
        Object retval;

        private ReturnVal() {
        }

        Object getRetval() {
            return this.retval;
        }
    }
}

