/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.os.Environment;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.ReplForm;
import com.google.appinventor.components.runtime.util.AsynchUtil;
import com.google.appinventor.components.runtime.util.FileUtil;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.StringWriter;

@DesignerComponent(version=2, description="Non-visible component for storing and retrieving files. Use this component to write or read files on your device. The default behaviour is to write files to the private data directory associated with your App. The Companion is special cased to write files to /sdcard/AppInventor/data to facilitate debugging. If the file path starts with a slash (/), then the file is created relative to /sdcard. For example writing a file to /myFile.txt will write the file in /sdcard/myFile.txt.", category=ComponentCategory.STORAGE, nonVisible=true, iconName="images/file.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.WRITE_EXTERNAL_STORAGE, android.permission.READ_EXTERNAL_STORAGE")
public class File
extends AndroidNonvisibleComponent
implements Component {
    public static final String NO_ASSETS = "No_Assets";
    private final Activity activity;
    private boolean isRepl = false;
    private final int BUFFER_LENGTH = 4096;
    private static final String LOG_TAG = "FileComponent";

    public File(ComponentContainer container) {
        super(container.$form());
        if (this.form instanceof ReplForm) {
            this.isRepl = true;
        }
        this.activity = container.$context();
    }

    @SimpleFunction(description="Saves text to a file. If the filename begins with a slash (/) the file is written to the sdcard. For example writing to /myFile.txt will write the file to /sdcard/myFile.txt. If the filename does not start with a slash, it will be written in the programs private data directory where it will not be accessible to other programs on the phone. There is a special exception for the AI Companion where these files are written to /sdcard/AppInventor/data to facilitate debugging. Note that this block will overwrite a file if it already exists.\n\nIf you want to add content to a file use the append block.")
    public void SaveFile(String text, String fileName) {
        if (fileName.startsWith("/")) {
            FileUtil.checkExternalStorageWriteable();
        }
        this.Write(fileName, text, false);
    }

    @SimpleFunction(description="Appends text to the end of a file storage, creating the file if it does not exist. See the help text under SaveFile for information about where files are written.")
    public void AppendToFile(String text, String fileName) {
        if (fileName.startsWith("/")) {
            FileUtil.checkExternalStorageWriteable();
        }
        this.Write(fileName, text, true);
    }

    @SimpleFunction(description="Reads text from a file in storage. Prefix the filename with / to read from a specific file on the SD card. for instance /myFile.txt will read the file /sdcard/myFile.txt. To read assets packaged with an application (also works for the Companion) start the filename with // (two slashes). If a filename does not start with a slash, it will be read from the applications private storage (for packaged apps) and from /sdcard/AppInventor/data for the Companion.")
    public void ReadFrom(final String fileName) {
        try {
            InputStream inputStream;
            if (fileName.startsWith("//")) {
                inputStream = this.isRepl ? new FileInputStream(Environment.getExternalStorageDirectory().getPath() + "/AppInventor/assets/" + fileName) : this.form.getAssets().open(fileName.substring(2));
            } else {
                String filepath = this.AbsoluteFileName(fileName);
                Log.d((String)LOG_TAG, (String)("filepath = " + filepath));
                inputStream = new FileInputStream(filepath);
            }
            final InputStream asyncInputStream = inputStream;
            AsynchUtil.runAsynchronously(new Runnable(){

                public void run() {
                    File.this.AsyncRead(asyncInputStream, fileName);
                }
            });
        }
        catch (FileNotFoundException e) {
            Log.e((String)LOG_TAG, (String)"FileNotFoundException", (Throwable)e);
            this.form.dispatchErrorOccurredEvent(this, "ReadFrom", 2101, fileName);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"IOException", (Throwable)e);
            this.form.dispatchErrorOccurredEvent(this, "ReadFrom", 2101, fileName);
        }
    }

    @SimpleFunction(description="Deletes a file from storage. Prefix the filename with / to delete a specific file in the SD card, for instance /myFile.txt. will delete the file /sdcard/myFile.txt. If the file does not begin with a /, then the file located in the programs private storage will be deleted. Starting the file with // is an error because assets files cannot be deleted.")
    public void Delete(String fileName) {
        if (fileName.startsWith("//")) {
            this.form.dispatchErrorOccurredEvent(this, "DeleteFile", 2105, fileName);
            return;
        }
        String filepath = this.AbsoluteFileName(fileName);
        java.io.File file = new java.io.File(filepath);
        file.delete();
    }

    private void Write(final String filename, final String text, final boolean append) {
        if (filename.startsWith("//")) {
            if (append) {
                this.form.dispatchErrorOccurredEvent(this, "AppendTo", 2106, filename);
            } else {
                this.form.dispatchErrorOccurredEvent(this, "SaveFile", 2106, filename);
            }
            return;
        }
        AsynchUtil.runAsynchronously(new Runnable(){

            public void run() {
                String filepath = File.this.AbsoluteFileName(filename);
                java.io.File file = new java.io.File(filepath);
                if (!file.exists()) {
                    try {
                        file.createNewFile();
                    }
                    catch (IOException e) {
                        if (append) {
                            File.this.form.dispatchErrorOccurredEvent(File.this, "AppendTo", 2103, filepath);
                        } else {
                            File.this.form.dispatchErrorOccurredEvent(File.this, "SaveFile", 2103, filepath);
                        }
                        return;
                    }
                }
                try {
                    FileOutputStream fileWriter = new FileOutputStream(file, append);
                    OutputStreamWriter out = new OutputStreamWriter(fileWriter);
                    out.write(text);
                    out.flush();
                    out.close();
                    fileWriter.close();
                    File.this.activity.runOnUiThread(new Runnable(){

                        public void run() {
                            File.this.AfterFileSaved(filename);
                        }
                    });
                }
                catch (IOException e) {
                    if (append) {
                        File.this.form.dispatchErrorOccurredEvent(File.this, "AppendTo", 2104, filepath);
                    }
                    File.this.form.dispatchErrorOccurredEvent(File.this, "SaveFile", 2104, filepath);
                }
            }
        });
    }

    private String normalizeNewLines(String s) {
        return s.replaceAll("\r\n", "\n");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void AsyncRead(InputStream fileInput, String fileName) {
        InputStreamReader input = null;
        try {
            input = new InputStreamReader(fileInput);
            StringWriter output = new StringWriter();
            char[] buffer = new char[4096];
            int offset = 0;
            int length = 0;
            while ((length = input.read(buffer, offset, 4096)) > 0) {
                output.write(buffer, 0, length);
            }
            final String text = this.normalizeNewLines(output.toString());
            this.activity.runOnUiThread(new Runnable(){

                public void run() {
                    File.this.GotText(text);
                }
            });
        }
        catch (FileNotFoundException e) {
            Log.e((String)LOG_TAG, (String)"FileNotFoundException", (Throwable)e);
            this.form.dispatchErrorOccurredEvent(this, "ReadFrom", 2101, fileName);
        }
        catch (IOException e) {
            Log.e((String)LOG_TAG, (String)"IOException", (Throwable)e);
            this.form.dispatchErrorOccurredEvent(this, "ReadFrom", 2102, fileName);
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {}
            }
        }
    }

    @SimpleEvent(description="Event indicating that the contents from the file have been read.")
    public void GotText(String text) {
        EventDispatcher.dispatchEvent(this, "GotText", text);
    }

    @SimpleEvent(description="Event indicating that the contents of the file have been written.")
    public void AfterFileSaved(String fileName) {
        EventDispatcher.dispatchEvent(this, "AfterFileSaved", fileName);
    }

    private String AbsoluteFileName(String filename) {
        String path;
        if (filename.startsWith("/")) {
            return Environment.getExternalStorageDirectory().getPath() + filename;
        }
        java.io.File dirPath = this.activity.getFilesDir();
        if (this.isRepl && !(dirPath = new java.io.File(path = Environment.getExternalStorageDirectory().getPath() + "/AppInventor/data/")).exists()) {
            dirPath.mkdirs();
        }
        return dirPath.getPath() + "/" + filename;
    }
}

