/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.os.Handler;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.LegoMindstormsEv3Sensor;

@DesignerComponent(version=1, description="A component that provides a high-level interface to an ultrasonic sensor on a LEGO MINDSTORMS EV3 robot.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsEv3.png")
@SimpleObject
public class Ev3UltrasonicSensor
extends LegoMindstormsEv3Sensor
implements Deleteable {
    private static final int SENSOR_TYPE = 30;
    private static final int SENSOR_MODE_CM = 0;
    private static final int SENSOR_MODE_INCH = 1;
    private static final String SENSOR_MODE_CM_STRING = "cm";
    private static final String SENSOR_MODE_INCH_STRING = "inch";
    private static final int DEFAULT_BOTTOM_OF_RANGE = 30;
    private static final int DEFAULT_TOP_OF_RANGE = 90;
    private static final String DEFAULT_SENSOR_MODE_STRING = "cm";
    private static final int DELAY_MILLISECONDS = 50;
    private String modeString = "cm";
    private int mode = 0;
    private Handler eventHandler = new Handler();
    private final Runnable sensorValueChecker = new Runnable(){

        public void run() {
            String functionName = "";
            if (Ev3UltrasonicSensor.this.bluetooth != null && Ev3UltrasonicSensor.this.bluetooth.IsConnected()) {
                double currentDistance = Ev3UltrasonicSensor.this.getDistance(functionName);
                if (Ev3UltrasonicSensor.this.previousDistance < 0.0) {
                    Ev3UltrasonicSensor.this.previousDistance = currentDistance;
                    Ev3UltrasonicSensor.this.eventHandler.postDelayed((Runnable)this, 50L);
                    return;
                }
                if (currentDistance < (double)Ev3UltrasonicSensor.this.bottomOfRange) {
                    if (Ev3UltrasonicSensor.this.belowRangeEventEnabled && Ev3UltrasonicSensor.this.previousDistance >= (double)Ev3UltrasonicSensor.this.bottomOfRange) {
                        Ev3UltrasonicSensor.this.BelowRange();
                    }
                } else if (currentDistance > (double)Ev3UltrasonicSensor.this.topOfRange) {
                    if (Ev3UltrasonicSensor.this.aboveRangeEventEnabled && Ev3UltrasonicSensor.this.previousDistance <= (double)Ev3UltrasonicSensor.this.topOfRange) {
                        Ev3UltrasonicSensor.this.AboveRange();
                    }
                } else if (Ev3UltrasonicSensor.this.withinRangeEventEnabled && (Ev3UltrasonicSensor.this.previousDistance < (double)Ev3UltrasonicSensor.this.bottomOfRange || Ev3UltrasonicSensor.this.previousDistance > (double)Ev3UltrasonicSensor.this.topOfRange)) {
                    Ev3UltrasonicSensor.this.WithinRange();
                }
                Ev3UltrasonicSensor.this.previousDistance = currentDistance;
            }
            Ev3UltrasonicSensor.this.eventHandler.postDelayed((Runnable)this, 50L);
        }
    };
    private double previousDistance = -1.0;
    private int bottomOfRange;
    private int topOfRange;
    private boolean belowRangeEventEnabled;
    private boolean withinRangeEventEnabled;
    private boolean aboveRangeEventEnabled;

    public Ev3UltrasonicSensor(ComponentContainer container) {
        super(container, "Ev3UltrasonicSensor");
        this.eventHandler.post(this.sensorValueChecker);
        this.TopOfRange(90);
        this.BottomOfRange(30);
        this.BelowRangeEventEnabled(false);
        this.AboveRangeEventEnabled(false);
        this.WithinRangeEventEnabled(false);
        this.Unit("cm");
    }

    @SimpleFunction(description="Returns the current distance in centimeters as a value between 0 and 254, or -1 if the distance can not be read.")
    public double GetDistance() {
        String functionName = "GetDistance";
        return this.getDistance(functionName);
    }

    private double getDistance(String functionName) {
        double distance = this.readInputSI(functionName, 0, this.sensorPortNumber, 30, this.mode);
        return distance == 255.0 ? -1.0 : distance;
    }

    @SimpleProperty(description="The bottom of the range used for the BelowRange, WithinRange, and AboveRange events.", category=PropertyCategory.BEHAVIOR)
    public int BottomOfRange() {
        return this.bottomOfRange;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="30")
    @SimpleProperty
    public void BottomOfRange(int bottomOfRange) {
        this.bottomOfRange = bottomOfRange;
    }

    @SimpleProperty(description="The top of the range used for the BelowRange, WithinRange, and AboveRange events.", category=PropertyCategory.BEHAVIOR)
    public int TopOfRange() {
        return this.topOfRange;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="90")
    @SimpleProperty
    public void TopOfRange(int topOfRange) {
        this.topOfRange = topOfRange;
    }

    @SimpleProperty(description="Whether the BelowRange event should fire when the distance goes below the BottomOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean BelowRangeEventEnabled() {
        return this.belowRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void BelowRangeEventEnabled(boolean enabled) {
        this.belowRangeEventEnabled = enabled;
    }

    @SimpleEvent(description="Called when the detected distance has gone below the range.")
    public void BelowRange() {
        EventDispatcher.dispatchEvent(this, "BelowRange", new Object[0]);
    }

    @SimpleProperty(description="Whether the WithinRange event should fire when the distance goes between the BottomOfRange and the TopOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean WithinRangeEventEnabled() {
        return this.withinRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void WithinRangeEventEnabled(boolean enabled) {
        this.withinRangeEventEnabled = enabled;
    }

    @SimpleEvent(description="Called when the detected distance has gone within the range.")
    public void WithinRange() {
        EventDispatcher.dispatchEvent(this, "WithinRange", new Object[0]);
    }

    @SimpleProperty(description="Whether the AboveRange event should fire when the distance goes above the TopOfRange.", category=PropertyCategory.BEHAVIOR)
    public boolean AboveRangeEventEnabled() {
        return this.aboveRangeEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void AboveRangeEventEnabled(boolean enabled) {
        this.aboveRangeEventEnabled = enabled;
    }

    @SimpleEvent(description="Called when the detected distance has gone above the range.")
    public void AboveRange() {
        EventDispatcher.dispatchEvent(this, "AboveRange", new Object[0]);
    }

    @DesignerProperty(editorType="lego_ev3_ultrasonic_sensor_mode", defaultValue="cm")
    @SimpleProperty
    public void Unit(String unitName) {
        String functionName = "Unit";
        try {
            this.setMode(unitName);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleProperty(description="The distance unit, which can be either \"cm\" or \"inch\".", category=PropertyCategory.BEHAVIOR)
    public String Unit() {
        return this.modeString;
    }

    @SimpleFunction(description="Measure the distance in centimeters.")
    public void SetCmUnit() {
        String functionName = "SetCmUnit";
        try {
            this.setMode("cm");
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Measure the distance in inches.")
    public void SetInchUnit() {
        String functionName = "SetInchUnit";
        try {
            this.setMode(SENSOR_MODE_INCH_STRING);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    private void setMode(String newModeString) {
        this.previousDistance = -1.0;
        if ("cm".equals(newModeString)) {
            this.mode = 0;
        } else if (SENSOR_MODE_INCH_STRING.equals(newModeString)) {
            this.mode = 1;
        } else {
            throw new IllegalArgumentException();
        }
        this.modeString = newModeString;
    }

    public void onDelete() {
        this.eventHandler.removeCallbacks(this.sensorValueChecker);
        super.onDelete();
    }
}

