/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.LegoMindstormsEv3Base;
import com.google.appinventor.components.runtime.util.Ev3BinaryParser;

@DesignerComponent(version=1, description="A component that provides a high-level interface to a LEGO MINDSTORMS EV3 robot, with functions to draw graphs on EV3 screen.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsEv3.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET,android.permission.WRITE_EXTERNAL_STORAGE,android.permission.READ_EXTERNAL_STORAGE")
public class Ev3UI
extends LegoMindstormsEv3Base {
    public Ev3UI(ComponentContainer container) {
        super(container, "Ev3UI");
    }

    @SimpleFunction(description="Draw a point on the screen.")
    public void DrawPoint(int color, int x, int y) {
        String functionName = "DrawPoint";
        if (color != 0 && color != 1) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
            return;
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "cccc", (byte)2, (byte)color, (short)x, (short)y);
        this.sendCommand(functionName, command, false);
        command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "c", (byte)0);
        this.sendCommand(functionName, command, false);
    }

    @SimpleFunction(description="Draw a built-in icon on screen.")
    public void DrawIcon(int color, int x, int y, int type, int no) {
        String functionName = "DrawIcon";
        if (color != 0 && color != 1) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
            return;
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "cccccc", (byte)6, (byte)color, (short)x, (short)y, type, no);
        this.sendCommand(functionName, command, false);
        command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "c", (byte)0);
        this.sendCommand(functionName, command, false);
    }

    @SimpleFunction(description="Draw a line on the screen.")
    public void DrawLine(int color, int x1, int y1, int x2, int y2) {
        String functionName = "DrawLine";
        if (color != 0 && color != 1) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
            return;
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "cccccc", (byte)3, (byte)color, (short)x1, (short)y1, (short)x2, (short)y2);
        this.sendCommand(functionName, command, false);
        command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "c", (byte)0);
        this.sendCommand(functionName, command, false);
    }

    @SimpleFunction(description="Draw a rectangle on the screen.")
    public void DrawRect(int color, int x, int y, int width, int height, boolean fill) {
        String functionName = "DrawRect";
        if (color != 0 && color != 1) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
            return;
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "cccccc", fill ? (byte)9 : 10, (byte)color, (short)x, (short)y, (short)width, (short)height);
        this.sendCommand(functionName, command, false);
        command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "c", (byte)0);
        this.sendCommand(functionName, command, false);
    }

    @SimpleFunction(description="Draw a circle on the screen.")
    public void DrawCircle(int color, int x, int y, int radius, boolean fill) {
        String functionName = "DrawCircle";
        if (color != 0 && color != 1 || radius < 0) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
            return;
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "ccccc", fill ? (byte)24 : 4, (byte)color, (short)x, (short)y, (short)radius);
        this.sendCommand(functionName, command, false);
        command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "c", (byte)0);
        this.sendCommand(functionName, command, false);
    }

    @SimpleFunction(description="Fill the screen with a color.")
    public void FillScreen(int color) {
        String functionName = "FillScreen";
        if (color != 0 && color != 1) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
            return;
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "cccc", (byte)19, (byte)color, (short)0, (short)0);
        this.sendCommand(functionName, command, false);
        command = Ev3BinaryParser.encodeDirectCommand((byte)-124, false, 0, 0, "c", (byte)0);
        this.sendCommand(functionName, command, false);
    }
}

