/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.os.Handler;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.BluetoothConnectionBase;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.LegoMindstormsEv3Base;
import com.google.appinventor.components.runtime.util.Ev3BinaryParser;

@DesignerComponent(version=1, description="A component that provides both high- and low-level interfaces to a LEGO MINDSTORMS EV3 robot, with functions that can control the motors.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsEv3.png")
@SimpleObject
public class Ev3Motors
extends LegoMindstormsEv3Base {
    private static final int DELAY_MILLISECONDS = 50;
    private static final String DEFAULT_MOTOR_PORTS = "ABC";
    private static final double DEFAULT_WHEEL_DIAMETER = 4.32;
    private int motorPortBitField = 1;
    private double wheelDiameter = 4.32;
    private boolean directionReversed = false;
    private boolean regulationEnabled = true;
    private boolean stopBeforeDisconnect = true;
    private boolean tachoCountChangedEventEnabled = false;
    private final Runnable sensorValueChecker;
    private Handler eventHandler = new Handler();
    private int previousValue = 0;
    private boolean ifReset = false;

    public Ev3Motors(ComponentContainer container) {
        super(container, "Ev3Motors");
        this.sensorValueChecker = new Runnable(){

            public void run() {
                String functionName = "";
                if (Ev3Motors.this.bluetooth != null && Ev3Motors.this.bluetooth.IsConnected()) {
                    int sensorValue = Ev3Motors.this.getOutputCount(functionName, 0, Ev3Motors.this.motorPortBitField);
                    if (!Ev3Motors.this.ifReset) {
                        if (sensorValue != Ev3Motors.this.previousValue && Ev3Motors.this.tachoCountChangedEventEnabled) {
                            Ev3Motors.this.TachoCountChanged(sensorValue);
                        }
                    } else {
                        Ev3Motors.this.ifReset = false;
                    }
                    Ev3Motors.this.previousValue = sensorValue;
                }
                Ev3Motors.this.eventHandler.postDelayed((Runnable)this, 50L);
            }
        };
        this.eventHandler.post(this.sensorValueChecker);
        this.MotorPorts(DEFAULT_MOTOR_PORTS);
        this.StopBeforeDisconnect(true);
        this.EnableSpeedRegulation(true);
        this.ReverseDirection(false);
        this.WheelDiameter(4.32);
        this.TachoCountChangedEventEnabled(false);
    }

    @SimpleProperty(description="The motor ports that the motors are connected to. The ports are specified by a sequence of port letters.", category=PropertyCategory.BEHAVIOR, userVisible=false)
    public String MotorPorts() {
        return this.bitFieldToMotorPortLetters(this.motorPortBitField);
    }

    @DesignerProperty(editorType="string", defaultValue="ABC")
    @SimpleProperty
    public void MotorPorts(String motorPortLetters) {
        String functionName = "MotorPorts";
        try {
            this.motorPortBitField = this.motorPortLettersToBitField(motorPortLetters);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3104, motorPortLetters);
        }
    }

    @DesignerProperty(editorType="float", defaultValue="4.32")
    @SimpleProperty
    public void WheelDiameter(double diameter) {
        this.wheelDiameter = diameter;
    }

    @SimpleProperty(description="The diameter of the wheels attached on the motors in centimeters.", category=PropertyCategory.BEHAVIOR, userVisible=false)
    public double WheelDiameter() {
        return this.wheelDiameter;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void ReverseDirection(boolean reversed) {
        String functionName = "ReverseDirection";
        try {
            this.setOutputDirection(functionName, 0, this.motorPortBitField, reversed ? -1 : 1);
            this.directionReversed = reversed;
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleProperty(description="It specifies if the direction of the motors is reversed.", category=PropertyCategory.BEHAVIOR)
    public boolean ReverseDirection() {
        return this.directionReversed;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void EnableSpeedRegulation(boolean enabled) {
        this.regulationEnabled = enabled;
    }

    @SimpleProperty(description="The robot adjusts the power to maintain the speed if speed regulation is enabled.", category=PropertyCategory.BEHAVIOR)
    public boolean EnableSpeedRegulation() {
        return this.regulationEnabled;
    }

    @SimpleProperty(description="Whether to stop the motor before disconnecting.", category=PropertyCategory.BEHAVIOR)
    public boolean StopBeforeDisconnect() {
        return this.stopBeforeDisconnect;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void StopBeforeDisconnect(boolean stopBeforeDisconnect) {
        this.stopBeforeDisconnect = stopBeforeDisconnect;
    }

    @SimpleProperty(description="Whether the TachoCountChanged event should fire when the angle is changed.", category=PropertyCategory.BEHAVIOR)
    public boolean TachoCountChangedEventEnabled() {
        return this.tachoCountChangedEventEnabled;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void TachoCountChangedEventEnabled(boolean enabled) {
        this.tachoCountChangedEventEnabled = enabled;
    }

    @SimpleFunction(description="Start to rotate the motors.")
    public void RotateIndefinitely(int power) {
        String functionName = "RotateIndefinitely";
        try {
            if (this.regulationEnabled) {
                this.setOutputPower(functionName, 0, this.motorPortBitField, power);
            } else {
                this.setOutputSpeed(functionName, 0, this.motorPortBitField, power);
            }
            this.startOutput(functionName, 0, this.motorPortBitField);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Rotate the motors in a number of tacho counts.")
    public void RotateInTachoCounts(int power, int tachoCounts, boolean useBrake) {
        String functionName = "RotateInTachoCounts";
        try {
            if (this.regulationEnabled) {
                this.outputStepSpeed(functionName, 0, this.motorPortBitField, power, 0, tachoCounts, 0, useBrake);
            } else {
                this.outputStepPower(functionName, 0, this.motorPortBitField, power, 0, tachoCounts, 0, useBrake);
            }
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Rotate the motors in a period of time.")
    public void RotateInDuration(int power, int milliseconds, boolean useBrake) {
        String functionName = "RotateInDuration";
        try {
            if (this.regulationEnabled) {
                this.outputTimeSpeed(functionName, 0, this.motorPortBitField, power, 0, milliseconds, 0, useBrake);
            } else {
                this.outputTimePower(functionName, 0, this.motorPortBitField, power, 0, milliseconds, 0, useBrake);
            }
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Rotate the motors in a distance.")
    public void RotateInDistance(int power, double distance, boolean useBrake) {
        String functionName = "RotateInDistance";
        int tachoCounts = (int)(distance * 360.0 / this.wheelDiameter / Math.PI);
        try {
            if (this.regulationEnabled) {
                this.outputStepSpeed(functionName, 0, this.motorPortBitField, power, 0, tachoCounts, 0, useBrake);
            } else {
                this.outputStepPower(functionName, 0, this.motorPortBitField, power, 0, tachoCounts, 0, useBrake);
            }
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Start to rotate the motors at the same speed.")
    public void RotateSyncIndefinitely(int power, int turnRatio) {
        String functionName = "RotateSyncIndefinitely";
        try {
            if (this.motorPortBitField != 0) {
                if (this.isOneShotInteger(this.motorPortBitField)) {
                    this.setOutputSpeed(functionName, 0, this.motorPortBitField, power);
                } else {
                    this.outputStepSync(functionName, 0, this.motorPortBitField, power, turnRatio, 0, true);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Rotate the motors at the same speed for a distance in cm.")
    public void RotateSyncInDistance(int power, int distance, int turnRatio, boolean useBrake) {
        String functionName = "RotateSyncInDuration";
        int tachoCounts = (int)((double)distance * 360.0 / this.wheelDiameter / Math.PI);
        try {
            if (this.motorPortBitField != 0) {
                if (this.isOneShotInteger(this.motorPortBitField)) {
                    this.outputStepSpeed(functionName, 0, this.motorPortBitField, power, 0, tachoCounts, 0, useBrake);
                } else {
                    this.outputStepSync(functionName, 0, this.motorPortBitField, power, turnRatio, tachoCounts, useBrake);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Rotate the motors at the same speed in a period of time.")
    public void RotateSyncInDuration(int power, int milliseconds, int turnRatio, boolean useBrake) {
        String functionName = "RotateSyncInDuration";
        try {
            if (this.motorPortBitField != 0) {
                if (this.isOneShotInteger(this.motorPortBitField)) {
                    this.outputTimeSpeed(functionName, 0, this.motorPortBitField, power, 0, milliseconds, 0, useBrake);
                } else {
                    this.outputTimeSync(functionName, 0, this.motorPortBitField, power, turnRatio, milliseconds, useBrake);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Rotate the motors at the same speed in a number of tacho counts.")
    public void RotateSyncInTachoCounts(int power, int tachoCounts, int turnRatio, boolean useBrake) {
        String functionName = "RotateSyncInTachoCounts";
        try {
            if (this.motorPortBitField != 0) {
                if (this.isOneShotInteger(this.motorPortBitField)) {
                    this.outputStepSpeed(functionName, 0, this.motorPortBitField, power, 0, tachoCounts, 0, useBrake);
                } else {
                    this.outputStepSync(functionName, 0, this.motorPortBitField, power, turnRatio, tachoCounts, useBrake);
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Stop the motors of the robot.")
    public void Stop(boolean useBrake) {
        String functionName = "Stop";
        try {
            this.stopOutput(functionName, 0, this.motorPortBitField, useBrake);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Toggle the direction of motors.")
    public void ToggleDirection() {
        String functionName = "ToggleDirection";
        try {
            this.setOutputDirection(functionName, 0, this.motorPortBitField, 0);
            this.directionReversed = !this.directionReversed;
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Set the current tacho count to zero.")
    public void ResetTachoCount() {
        String functionName = "ResetTachoCount";
        try {
            this.clearOutputCount(functionName, 0, this.motorPortBitField);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
        }
    }

    @SimpleFunction(description="Get the current tacho count.")
    public int GetTachoCount() {
        String functionName = "GetTachoCount";
        try {
            return this.getOutputCount(functionName, 0, this.motorPortBitField);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
            return 0;
        }
    }

    @SimpleEvent(description="Called when the tacho count has changed.")
    public void TachoCountChanged(int tachoCount) {
        EventDispatcher.dispatchEvent(this, "TachoCountChanged", tachoCount);
    }

    private int roundValue(int value, int minimum, int maximum) {
        return value < minimum ? minimum : (value > maximum ? maximum : value);
    }

    private boolean isOneShotInteger(int value) {
        return value != 0 && (value & ~(value ^ value - 1)) == 0;
    }

    private void resetOutput(String functionName, int layer, int nos) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15) {
            throw new IllegalArgumentException();
        }
        this.ifReset = true;
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-94, false, 0, 0, "cc", (byte)layer, (byte)nos);
        this.sendCommand(functionName, command, false);
    }

    private void startOutput(String functionName, int layer, int nos) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15) {
            throw new IllegalArgumentException();
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-90, false, 0, 0, "cc", (byte)layer, (byte)nos);
        this.sendCommand(functionName, command, false);
    }

    private void stopOutput(String functionName, int layer, int nos, boolean useBrake) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15) {
            throw new IllegalArgumentException();
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-93, false, 0, 0, "ccc", (byte)layer, (byte)nos, useBrake ? (byte)1 : 0);
        this.sendCommand(functionName, command, false);
    }

    private void outputStepPower(String functionName, int layer, int nos, int power, int step1, int step2, int step3, boolean brake) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15 || step1 < 0 || step2 < 0 || step3 < 0) {
            throw new IllegalArgumentException();
        }
        power = this.roundValue(power, -100, 100);
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-84, false, 0, 0, "ccccccc", (byte)layer, (byte)nos, (byte)power, step1, step2, step3, (byte)(brake ? 1 : 0));
        this.sendCommand(functionName, command, false);
    }

    private void outputStepSpeed(String functionName, int layer, int nos, int speed, int step1, int step2, int step3, boolean brake) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15 || step1 < 0 || step2 < 0 || step3 < 0) {
            throw new IllegalArgumentException();
        }
        speed = this.roundValue(speed, -100, 100);
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-82, false, 0, 0, "ccccccc", (byte)layer, (byte)nos, (byte)speed, step1, step2, step3, (byte)(brake ? 1 : 0));
        this.sendCommand(functionName, command, false);
    }

    private void outputStepSync(String functionName, int layer, int nos, int speed, int turnRatio, int tachoCounts, boolean brake) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15 || turnRatio < -200 || turnRatio > 200) {
            throw new IllegalArgumentException();
        }
        speed = this.roundValue(speed, -100, 100);
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-80, false, 0, 0, "cccccc", (byte)layer, (byte)nos, (byte)speed, (short)turnRatio, tachoCounts, (byte)(brake ? 1 : 0));
        this.sendCommand(functionName, command, false);
    }

    private void outputTimePower(String functionName, int layer, int nos, int power, int step1, int step2, int step3, boolean brake) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15 || step1 < 0 || step2 < 0 || step3 < 0) {
            throw new IllegalArgumentException();
        }
        power = this.roundValue(power, -100, 100);
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-83, false, 0, 0, "ccccccc", (byte)layer, (byte)nos, (byte)power, step1, step2, step3, (byte)(brake ? 1 : 0));
        this.sendCommand(functionName, command, false);
    }

    private void outputTimeSpeed(String functionName, int layer, int nos, int speed, int step1, int step2, int step3, boolean brake) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15 || step1 < 0 || step2 < 0 || step3 < 0) {
            throw new IllegalArgumentException();
        }
        speed = this.roundValue(speed, -100, 100);
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-81, false, 0, 0, "ccccccc", (byte)layer, (byte)nos, (byte)speed, step1, step2, step3, (byte)(brake ? 1 : 0));
        this.sendCommand(functionName, command, false);
    }

    private void outputTimeSync(String functionName, int layer, int nos, int speed, int turnRatio, int milliseconds, boolean brake) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15 || milliseconds < 0) {
            throw new IllegalArgumentException();
        }
        speed = this.roundValue(speed, -100, 100);
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-79, false, 0, 0, "cccccc", (byte)layer, (byte)nos, (byte)speed, (short)turnRatio, milliseconds, (byte)(brake ? 1 : 0));
        this.sendCommand(functionName, command, false);
    }

    private void setOutputDirection(String functionName, int layer, int nos, int direction) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15 || direction < -1 || direction > 1) {
            throw new IllegalArgumentException();
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-89, false, 0, 0, "ccc", (byte)layer, (byte)nos, (byte)direction);
        this.sendCommand(functionName, command, false);
    }

    private void setOutputSpeed(String functionName, int layer, int nos, int speed) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15) {
            throw new IllegalArgumentException();
        }
        speed = this.roundValue(speed, -100, 100);
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-91, false, 0, 0, "ccc", (byte)layer, (byte)nos, (byte)speed);
        this.sendCommand(functionName, command, false);
    }

    private void setOutputPower(String functionName, int layer, int nos, int power) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15) {
            throw new IllegalArgumentException();
        }
        power = this.roundValue(power, -100, 100);
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-92, false, 0, 0, "ccc", (byte)layer, (byte)nos, (byte)power);
        this.sendCommand(functionName, command, false);
    }

    private int getOutputCount(String functionName, int layer, int nos) {
        int portNumber;
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15) {
            throw new IllegalArgumentException();
        }
        nos = (nos ^ nos - 1) + 1 >>> 1;
        switch (nos) {
            case 1: {
                portNumber = 0;
                break;
            }
            case 2: {
                portNumber = 1;
                break;
            }
            case 4: {
                portNumber = 2;
                break;
            }
            case 8: {
                portNumber = 3;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-77, true, 4, 0, "ccg", (byte)layer, (byte)portNumber, (byte)0);
        byte[] reply = this.sendCommand(functionName, command, true);
        if (reply != null && reply.length == 5 && reply[0] == 2) {
            Object[] values = Ev3BinaryParser.unpack("xi", reply);
            return (Integer)values[0];
        }
        return 0;
    }

    private void clearOutputCount(String functionName, int layer, int nos) {
        if (layer < 0 || layer > 3 || nos < 0 || nos > 15) {
            throw new IllegalArgumentException();
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-78, false, 0, 0, "cc", (byte)layer, (byte)nos);
        this.sendCommand(functionName, command, false);
    }

    public void beforeDisconnect(BluetoothConnectionBase bluetoothConnection) {
        String functionName = "beforeDisconnect";
        if (this.stopBeforeDisconnect) {
            try {
                this.stopOutput(functionName, 0, this.motorPortBitField, true);
            }
            catch (IllegalArgumentException e) {
                this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
            }
        }
    }
}

