/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.LegoMindstormsEv3Base;
import com.google.appinventor.components.runtime.util.Ev3BinaryParser;

@DesignerComponent(version=1, description="A component that provides a low-level interface to a LEGO MINDSTORMS EV3 robot, with functions to send system or direct commands to EV3 robots.", category=ComponentCategory.LEGOMINDSTORMS, nonVisible=true, iconName="images/legoMindstormsEv3.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET,android.permission.WRITE_EXTERNAL_STORAGE,android.permission.READ_EXTERNAL_STORAGE")
public class Ev3Commands
extends LegoMindstormsEv3Base {
    public Ev3Commands(ComponentContainer container) {
        super(container, "Ev3Commands");
    }

    @SimpleFunction(description="Keep the EV3 brick from shutdown for a period of time.")
    public void KeepAlive(int minutes) {
        String functionName = Thread.currentThread().getStackTrace()[1].getMethodName();
        if (minutes < 0 || minutes > 255) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 3103, functionName);
            return;
        }
        byte[] command = Ev3BinaryParser.encodeDirectCommand((byte)-112, false, 0, 0, "c", (byte)minutes);
        this.sendCommand(functionName, command, false);
    }

    @SimpleFunction(description="Get the battery voltage.")
    public double GetBatteryVoltage() {
        byte[] command;
        String functionName = Thread.currentThread().getStackTrace()[1].getMethodName();
        byte[] reply = this.sendCommand(functionName, command = Ev3BinaryParser.encodeDirectCommand((byte)-127, true, 4, 0, "cg", (byte)1, (byte)0), true);
        if (reply != null && reply.length == 5 && reply[0] == 2) {
            Object[] values = Ev3BinaryParser.unpack("xf", reply);
            return ((Float)values[0]).floatValue();
        }
        return -1.0;
    }

    @SimpleFunction(description="Get the battery current.")
    public double GetBatteryCurrent() {
        byte[] command;
        String functionName = Thread.currentThread().getStackTrace()[1].getMethodName();
        byte[] reply = this.sendCommand(functionName, command = Ev3BinaryParser.encodeDirectCommand((byte)-127, true, 4, 0, "cg", (byte)2, (byte)0), true);
        if (reply != null && reply.length == 5 && reply[0] == 2) {
            Object[] values = Ev3BinaryParser.unpack("xf", reply);
            return ((Float)values[0]).floatValue();
        }
        return -1.0;
    }

    @SimpleFunction(description="Get the OS version on EV3.")
    public String GetOSVersion() {
        byte[] command;
        String functionName = Thread.currentThread().getStackTrace()[1].getMethodName();
        byte[] reply = this.sendCommand(functionName, command = Ev3BinaryParser.encodeDirectCommand((byte)-127, true, 100, 0, "ccg", (byte)3, (short)100, (byte)0), true);
        if (reply != null && reply[0] == 2) {
            Object[] value = Ev3BinaryParser.unpack("xS", reply);
            return String.valueOf(value[0]);
        }
        this.form.dispatchErrorOccurredEvent(this, functionName, 3102, new Object[0]);
        return null;
    }

    @SimpleFunction(description="Get the OS build on EV3.")
    public String GetOSBuild() {
        byte[] command;
        String functionName = Thread.currentThread().getStackTrace()[1].getMethodName();
        byte[] reply = this.sendCommand(functionName, command = Ev3BinaryParser.encodeDirectCommand((byte)3, true, 100, 0, "ccg", (byte)12, (short)100, (byte)0), true);
        if (reply != null && reply[0] == 2) {
            Object[] value = Ev3BinaryParser.unpack("xS", reply);
            return String.valueOf(value[0]);
        }
        this.form.dispatchErrorOccurredEvent(this, functionName, 3102, new Object[0]);
        return null;
    }

    @SimpleFunction(description="Get the firmware version on EV3.")
    public String GetFirmwareVersion() {
        byte[] command;
        String functionName = Thread.currentThread().getStackTrace()[1].getMethodName();
        byte[] reply = this.sendCommand(functionName, command = Ev3BinaryParser.encodeDirectCommand((byte)-127, true, 100, 0, "ccg", (byte)10, (short)100, (byte)0), true);
        if (reply != null && reply[0] == 2) {
            Object[] value = Ev3BinaryParser.unpack("xS", reply);
            return String.valueOf(value[0]);
        }
        this.form.dispatchErrorOccurredEvent(this, functionName, 3102, new Object[0]);
        return null;
    }

    @SimpleFunction(description="Get the firmware build on EV3.")
    public String GetFirmwareBuild() {
        byte[] command;
        String functionName = Thread.currentThread().getStackTrace()[1].getMethodName();
        byte[] reply = this.sendCommand(functionName, command = Ev3BinaryParser.encodeDirectCommand((byte)-127, true, 100, 0, "cg", (byte)127, (byte)0), true);
        if (reply != null && reply[0] == 2) {
            Object[] value = Ev3BinaryParser.unpack("xS", reply);
            return String.valueOf(value[0]);
        }
        this.form.dispatchErrorOccurredEvent(this, functionName, 3102, new Object[0]);
        return null;
    }

    @SimpleFunction(description="Get the hardware version of EV3.")
    public String GetHardwareVersion() {
        byte[] command;
        String functionName = Thread.currentThread().getStackTrace()[1].getMethodName();
        byte[] reply = this.sendCommand(functionName, command = Ev3BinaryParser.encodeDirectCommand((byte)-127, true, 100, 0, "ccg", (byte)9, (short)100, (byte)0), true);
        if (reply != null && reply[0] == 2) {
            Object[] value = Ev3BinaryParser.unpack("xS", reply);
            return String.valueOf(value[0]);
        }
        this.form.dispatchErrorOccurredEvent(this, functionName, 3102, new Object[0]);
        return null;
    }
}

