/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.provider.Contacts;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ActivityResultListener;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Picker;
import com.google.appinventor.components.runtime.util.HoneycombMR1Util;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@DesignerComponent(version=6, description="A button that, when clicked on, displays a list of the contacts to choose among. After the user has made a selection, the following properties will be set to information about the chosen contact: <ul>\n<li> <code>ContactName</code>: the contact's name </li>\n <li> <code>EmailAddress</code>: the contact's primary email address </li>\n <li> <code>ContactUri</code>: the contact's URI on the device </li>\n<li> <code>EmailAddressList</code>: a list of the contact's email addresses </li>\n <li> <code>PhoneNumber</code>: the contact's primary phone number (on Later Android Verisons)</li>\n <li> <code>PhoneNumberList</code>: a list of the contact's phone numbers (on Later Android Versions)</li>\n <li> <code>Picture</code>: the name of the file containing the contact's image, which can be used as a <code>Picture</code> property value for the <code>Image</code> or <code>ImageSprite</code> component.</li></ul>\n</p><p>Other properties affect the appearance of the button (<code>TextAlignment</code>, <code>BackgroundColor</code>, etc.) and whether it can be clicked on (<code>Enabled</code>).\n</p><p>The ContactPicker component might not work on all phones. For example, on Android systems before system 3.0, it cannot pick phone numbers, and the list of email addresses will contain only one email.", category=ComponentCategory.SOCIAL)
@SimpleObject
@UsesPermissions(permissionNames="android.permission.READ_CONTACTS")
public class ContactPicker
extends Picker
implements ActivityResultListener {
    private static String[] CONTACT_PROJECTION;
    private static String[] DATA_PROJECTION;
    private static final String[] PROJECTION;
    private static final int NAME_INDEX = 0;
    private static final int EMAIL_INDEX = 1;
    private static final int PHONE_INDEX = 2;
    protected final Activity activityContext;
    private final Uri intentUri;
    protected String contactName;
    protected String emailAddress;
    protected String contactUri;
    protected String contactPictureUri;
    protected String phoneNumber;
    protected List emailAddressList;
    protected List phoneNumberList;

    public ContactPicker(ComponentContainer container) {
        this(container, Contacts.People.CONTENT_URI);
    }

    protected ContactPicker(ComponentContainer container, Uri intentUri) {
        super(container);
        this.activityContext = container.$context();
        this.intentUri = SdkLevel.getLevel() >= 12 && intentUri.equals((Object)Contacts.People.CONTENT_URI) ? HoneycombMR1Util.getContentUri() : (SdkLevel.getLevel() >= 12 && intentUri.equals((Object)Contacts.Phones.CONTENT_URI) ? HoneycombMR1Util.getPhoneContentUri() : intentUri);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String Picture() {
        return this.ensureNotNull(this.contactPictureUri);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String ContactName() {
        return this.ensureNotNull(this.contactName);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String EmailAddress() {
        return this.ensureNotNull(this.emailAddress);
    }

    @SimpleProperty(description="URI that specifies the location of the contact on the device.", category=PropertyCategory.BEHAVIOR)
    public String ContactUri() {
        return this.ensureNotNull(this.contactUri);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public List EmailAddressList() {
        return this.ensureNotNull(this.emailAddressList);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String PhoneNumber() {
        return this.ensureNotNull(this.phoneNumber);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public List PhoneNumberList() {
        return this.ensureNotNull(this.phoneNumberList);
    }

    @SimpleFunction(description="view a contact via its URI")
    public void ViewContact(String uri) {
        Intent intent;
        if (this.contactUri != null && (intent = new Intent("android.intent.action.VIEW", Uri.parse((String)uri))).resolveActivity(this.activityContext.getPackageManager()) != null) {
            this.activityContext.startActivity(intent);
        }
    }

    protected Intent getIntent() {
        return new Intent("android.intent.action.PICK", this.intentUri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultReturned(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.requestCode && resultCode == -1) {
            Log.i((String)"ContactPicker", (String)("received intent is " + data));
            Uri receivedContactUri = data.getData();
            String desiredContactUri = "";
            desiredContactUri = SdkLevel.getLevel() >= 12 ? "//com.android.contacts/contact" : "//contacts/people";
            if (this.checkContactUri(receivedContactUri, desiredContactUri)) {
                Cursor contactCursor = null;
                Cursor dataCursor = null;
                try {
                    if (SdkLevel.getLevel() >= 12) {
                        CONTACT_PROJECTION = HoneycombMR1Util.getContactProjection();
                        contactCursor = this.activityContext.getContentResolver().query(receivedContactUri, CONTACT_PROJECTION, null, null, null);
                        String id2 = this.postHoneycombGetContactNameAndPicture(contactCursor);
                        DATA_PROJECTION = HoneycombMR1Util.getDataProjection();
                        dataCursor = HoneycombMR1Util.getDataCursor(id2, this.activityContext, DATA_PROJECTION);
                        this.postHoneycombGetContactEmailAndPhone(dataCursor);
                        this.contactUri = receivedContactUri.toString();
                    } else {
                        contactCursor = this.activityContext.getContentResolver().query(receivedContactUri, PROJECTION, null, null, null);
                        this.preHoneycombGetContactInfo(contactCursor, receivedContactUri);
                    }
                    Log.i((String)"ContactPicker", (String)("Contact name = " + this.contactName + ", email address = " + this.emailAddress + ",contact Uri = " + this.contactUri + ", phone number = " + this.phoneNumber + ", contactPhotoUri = " + this.contactPictureUri));
                }
                catch (Exception e) {
                    Log.i((String)"ContactPicker", (String)"checkContactUri failed: D");
                    this.puntContactSelection(1107);
                }
                finally {
                    if (contactCursor != null) {
                        contactCursor.close();
                    }
                    if (dataCursor != null) {
                        dataCursor.close();
                    }
                }
            }
            this.AfterPicking();
        }
    }

    public void preHoneycombGetContactInfo(Cursor contactCursor, Uri theContactUri) {
        if (contactCursor.moveToFirst()) {
            this.contactName = this.guardCursorGetString(contactCursor, 0);
            String emailId = this.guardCursorGetString(contactCursor, 1);
            this.emailAddress = this.getEmailAddress(emailId);
            this.contactUri = theContactUri.toString();
            this.contactPictureUri = theContactUri.toString();
            this.emailAddressList = this.emailAddress.equals("") ? new ArrayList() : Arrays.asList(this.emailAddress);
        }
    }

    public String postHoneycombGetContactNameAndPicture(Cursor contactCursor) {
        String id2 = "";
        if (contactCursor.moveToFirst()) {
            int ID_INDEX = HoneycombMR1Util.getIdIndex(contactCursor);
            int NAME_INDEX = HoneycombMR1Util.getNameIndex(contactCursor);
            int THUMBNAIL_INDEX = HoneycombMR1Util.getThumbnailIndex(contactCursor);
            int PHOTO_INDEX = HoneycombMR1Util.getPhotoIndex(contactCursor);
            id2 = this.guardCursorGetString(contactCursor, ID_INDEX);
            this.contactName = this.guardCursorGetString(contactCursor, NAME_INDEX);
            this.contactPictureUri = this.guardCursorGetString(contactCursor, THUMBNAIL_INDEX);
            Log.i((String)"ContactPicker", (String)("photo_uri=" + this.guardCursorGetString(contactCursor, PHOTO_INDEX)));
        }
        return id2;
    }

    public void postHoneycombGetContactEmailAndPhone(Cursor dataCursor) {
        this.phoneNumber = "";
        this.emailAddress = "";
        ArrayList<String> phoneListToStore = new ArrayList<String>();
        ArrayList<String> emailListToStore = new ArrayList<String>();
        if (dataCursor.moveToFirst()) {
            int PHONE_INDEX = HoneycombMR1Util.getPhoneIndex(dataCursor);
            int EMAIL_INDEX = HoneycombMR1Util.getEmailIndex(dataCursor);
            int MIME_INDEX = HoneycombMR1Util.getMimeIndex(dataCursor);
            String phoneType = HoneycombMR1Util.getPhoneType();
            String emailType = HoneycombMR1Util.getEmailType();
            while (!dataCursor.isAfterLast()) {
                String type = this.guardCursorGetString(dataCursor, MIME_INDEX);
                if (type.contains(phoneType)) {
                    phoneListToStore.add(this.guardCursorGetString(dataCursor, PHONE_INDEX));
                } else if (type.contains(emailType)) {
                    emailListToStore.add(this.guardCursorGetString(dataCursor, EMAIL_INDEX));
                } else {
                    Log.i((String)"ContactPicker", (String)("Type mismatch: " + type + " not " + phoneType + " or " + emailType));
                }
                dataCursor.moveToNext();
            }
        }
        if (!phoneListToStore.isEmpty()) {
            this.phoneNumber = (String)phoneListToStore.get(0);
        }
        if (!emailListToStore.isEmpty()) {
            this.emailAddress = (String)emailListToStore.get(0);
        }
        this.phoneNumberList = phoneListToStore;
        this.emailAddressList = emailListToStore;
    }

    protected boolean checkContactUri(Uri suspectUri, String requiredPattern) {
        Log.i((String)"ContactPicker", (String)("contactUri is " + suspectUri));
        if (suspectUri == null || !"content".equals(suspectUri.getScheme())) {
            Log.i((String)"ContactPicker", (String)"checkContactUri failed: A");
            this.puntContactSelection(1107);
            return false;
        }
        String UriSpecific = suspectUri.getSchemeSpecificPart();
        if (!UriSpecific.startsWith(requiredPattern)) {
            Log.i((String)"ContactPicker", (String)"checkContactUri failed: C");
            Log.i((String)"ContactPicker", (String)suspectUri.getPath());
            this.puntContactSelection(1107);
            return false;
        }
        return true;
    }

    protected void puntContactSelection(int errorNumber) {
        this.contactName = "";
        this.emailAddress = "";
        this.contactPictureUri = "";
        this.container.$form().dispatchErrorOccurredEvent(this, "", errorNumber, new Object[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getEmailAddress(String emailId) {
        int id2;
        try {
            id2 = Integer.parseInt(emailId);
        }
        catch (NumberFormatException e) {
            return "";
        }
        String data = "";
        String where = "contact_methods._id = " + id2;
        String[] projection = new String[]{"data"};
        Cursor cursor = this.activityContext.getContentResolver().query(Contacts.ContactMethods.CONTENT_EMAIL_URI, projection, where, null, null);
        try {
            if (cursor.moveToFirst()) {
                data = this.guardCursorGetString(cursor, 0);
            }
        }
        finally {
            cursor.close();
        }
        return this.ensureNotNull(data);
    }

    protected String guardCursorGetString(Cursor cursor, int index) {
        String result;
        try {
            result = cursor.getString(index);
        }
        catch (Exception e) {
            result = "";
        }
        return this.ensureNotNull(result);
    }

    protected String ensureNotNull(String value) {
        if (value == null) {
            return "";
        }
        return value;
    }

    protected List ensureNotNull(List value) {
        if (value == null) {
            return new ArrayList();
        }
        return value;
    }

    static {
        PROJECTION = new String[]{"name", "primary_email"};
    }
}

