/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.view.View;
import android.widget.CompoundButton;
import android.widget.TextView;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.util.TextViewUtil;

@DesignerComponent(version=2, description="Checkbox that raises an event when the user clicks on it. There are many properties affecting its appearance that can be set in the Designer or Blocks Editor.", category=ComponentCategory.USERINTERFACE)
@SimpleObject
public final class CheckBox
extends AndroidViewComponent
implements CompoundButton.OnCheckedChangeListener,
View.OnFocusChangeListener {
    private final android.widget.CheckBox view;
    private int backgroundColor;
    private int fontTypeface;
    private boolean bold;
    private boolean italic;
    private int textColor;

    public CheckBox(ComponentContainer container) {
        super(container);
        this.view = new android.widget.CheckBox((Context)container.$context());
        this.view.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.view.setOnCheckedChangeListener((CompoundButton.OnCheckedChangeListener)this);
        container.$add(this);
        this.BackgroundColor(0xFFFFFF);
        this.Enabled(true);
        this.fontTypeface = 0;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, this.bold, this.italic);
        this.FontSize(14.0f);
        this.Text("");
        this.TextColor(-16777216);
        this.Checked(false);
    }

    public View getView() {
        return this.view;
    }

    @SimpleEvent
    public void Changed() {
        EventDispatcher.dispatchEvent(this, "Changed", new Object[0]);
    }

    @SimpleEvent
    public void GotFocus() {
        EventDispatcher.dispatchEvent(this, "GotFocus", new Object[0]);
    }

    @SimpleEvent
    public void LostFocus() {
        EventDispatcher.dispatchEvent(this, "LostFocus", new Object[0]);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public int BackgroundColor() {
        return this.backgroundColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&H00FFFFFF")
    @SimpleProperty
    public void BackgroundColor(int argb) {
        this.backgroundColor = argb;
        if (argb != 0) {
            TextViewUtil.setBackgroundColor((TextView)this.view, argb);
        } else {
            TextViewUtil.setBackgroundColor((TextView)this.view, 0xFFFFFF);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Enabled() {
        return this.view.isEnabled();
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void Enabled(boolean enabled) {
        TextViewUtil.setEnabled((TextView)this.view, enabled);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, userVisible=false)
    public boolean FontBold() {
        return this.bold;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(userVisible=false)
    public void FontBold(boolean bold) {
        this.bold = bold;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, bold, this.italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, userVisible=false)
    public boolean FontItalic() {
        return this.italic;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(userVisible=false)
    public void FontItalic(boolean italic) {
        this.italic = italic;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, this.bold, italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public float FontSize() {
        return TextViewUtil.getFontSize((TextView)this.view, (Context)this.container.$context());
    }

    @DesignerProperty(editorType="non_negative_float", defaultValue="14.0")
    @SimpleProperty
    public void FontSize(float size) {
        TextViewUtil.setFontSize((TextView)this.view, size);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, userVisible=false)
    public int FontTypeface() {
        return this.fontTypeface;
    }

    @DesignerProperty(editorType="typeface", defaultValue="0")
    @SimpleProperty(userVisible=false)
    public void FontTypeface(int typeface) {
        this.fontTypeface = typeface;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, this.bold, this.italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public String Text() {
        return TextViewUtil.getText((TextView)this.view);
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void Text(String text) {
        TextViewUtil.setText((TextView)this.view, text);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public int TextColor() {
        return this.textColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&HFF000000")
    @SimpleProperty
    public void TextColor(int argb) {
        this.textColor = argb;
        if (argb != 0) {
            TextViewUtil.setTextColor((TextView)this.view, argb);
        } else {
            TextViewUtil.setTextColor((TextView)this.view, -16777216);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Checked() {
        return this.view.isChecked();
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void Checked(boolean value) {
        this.view.setChecked(value);
        this.view.invalidate();
    }

    public void onCheckedChanged(CompoundButton buttonView, boolean isChecked) {
        this.Changed();
    }

    public void onFocusChange(View previouslyFocused, boolean gainFocus) {
        if (gainFocus) {
            this.GotFocus();
        } else {
            this.LostFocus();
        }
    }
}

