/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.text.TextUtils;
import android.util.Log;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.Sprite;
import com.google.appinventor.components.runtime.collect.Sets;
import com.google.appinventor.components.runtime.util.BoundingBox;
import com.google.appinventor.components.runtime.util.FileUtil;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.PaintUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

@DesignerComponent(version=10, description="<p>A two-dimensional touch-sensitive rectangular panel on which drawing can be done and sprites can be moved.</p> <p>The <code>BackgroundColor</code>, <code>PaintColor</code>, <code>BackgroundImage</code>, <code>Width</code>, and <code>Height</code> of the Canvas can be set in either the Designer or in the Blocks Editor.  The <code>Width</code> and <code>Height</code> are measured in pixels and must be positive.</p><p>Any location on the Canvas can be specified as a pair of (X, Y) values, where <ul> <li>X is the number of pixels away from the left edge of the Canvas</li><li>Y is the number of pixels away from the top edge of the Canvas</li></ul>.</p> <p>There are events to tell when and where a Canvas has been touched or a <code>Sprite</code> (<code>ImageSprite</code> or <code>Ball</code>) has been dragged.  There are also methods for drawing points, lines, and circles.</p>", category=ComponentCategory.ANIMATION)
@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET,android.permission.WRITE_EXTERNAL_STORAGE")
public final class Canvas
extends AndroidViewComponent
implements ComponentContainer {
    private static final String LOG_TAG = "Canvas";
    private final Activity context;
    private final CanvasView view;
    private boolean drawn;
    private int paintColor;
    private final Paint paint;
    private int backgroundColor;
    private String backgroundImagePath = "";
    private int textAlignment;
    private static final int MIN_WIDTH_HEIGHT = 1;
    private static final float DEFAULT_LINE_WIDTH = 2.0f;
    private static final int DEFAULT_PAINT_COLOR = -16777216;
    private static final int DEFAULT_BACKGROUND_COLOR = -1;
    private static final int DEFAULT_TEXTALIGNMENT = 1;
    private static final int FLING_INTERVAL = 1000;
    private final List<Sprite> sprites;
    private final MotionEventParser motionEventParser;
    private final GestureDetector mGestureDetector;
    private final Set<ExtensionGestureDetector> extensionGestureDetectors = Sets.newHashSet();

    public Canvas(ComponentContainer container) {
        super(container);
        this.context = container.$context();
        this.view = new CanvasView((Context)this.context);
        container.$add(this);
        this.paint = new Paint();
        this.paint.setFlags(1);
        this.paint.setStrokeWidth(2.0f);
        this.PaintColor(-16777216);
        this.BackgroundColor(-1);
        this.TextAlignment(1);
        this.FontSize(14.0f);
        this.sprites = new LinkedList<Sprite>();
        this.motionEventParser = new MotionEventParser();
        this.mGestureDetector = new GestureDetector((Context)this.context, (GestureDetector.OnGestureListener)new FlingGestureListener());
    }

    public View getView() {
        return this.view;
    }

    public Activity getContext() {
        return this.context;
    }

    public void registerCustomGestureDetector(ExtensionGestureDetector detector) {
        this.extensionGestureDetectors.add(detector);
    }

    public void removeCustomGestureDetector(Object detector) {
        this.extensionGestureDetectors.remove(detector);
    }

    public boolean ready() {
        return this.drawn;
    }

    void addSprite(Sprite sprite) {
        for (int i = 0; i < this.sprites.size(); ++i) {
            if (!(this.sprites.get(i).Z() > sprite.Z())) continue;
            this.sprites.add(i, sprite);
            return;
        }
        this.sprites.add(sprite);
    }

    void removeSprite(Sprite sprite) {
        this.sprites.remove(sprite);
    }

    void changeSpriteLayer(Sprite sprite) {
        this.removeSprite(sprite);
        this.addSprite(sprite);
        this.view.invalidate();
    }

    public Activity $context() {
        return this.context;
    }

    public Form $form() {
        return this.container.$form();
    }

    public void $add(AndroidViewComponent component) {
        throw new UnsupportedOperationException("Canvas.$add() called");
    }

    public void setChildWidth(AndroidViewComponent component, int width) {
        throw new UnsupportedOperationException("Canvas.setChildWidth() called");
    }

    public void setChildHeight(AndroidViewComponent component, int height) {
        throw new UnsupportedOperationException("Canvas.setChildHeight() called");
    }

    void registerChange(Sprite sprite) {
        this.view.invalidate();
        this.findSpriteCollisions(sprite);
    }

    protected void findSpriteCollisions(Sprite movedSprite) {
        for (Sprite sprite : this.sprites) {
            if (sprite == movedSprite) continue;
            if (movedSprite.CollidingWith(sprite)) {
                if (movedSprite.Visible() && movedSprite.Enabled() && sprite.Visible() && sprite.Enabled() && Sprite.colliding(sprite, movedSprite)) continue;
                movedSprite.NoLongerCollidingWith(sprite);
                sprite.NoLongerCollidingWith(movedSprite);
                continue;
            }
            if (!movedSprite.Visible() || !movedSprite.Enabled() || !sprite.Visible() || !sprite.Enabled() || !Sprite.colliding(sprite, movedSprite)) continue;
            movedSprite.CollidedWith(sprite);
            sprite.CollidedWith(movedSprite);
        }
    }

    @SimpleProperty
    public void Width(int width) {
        if (width > 0 || width == -2 || width == -1 || width <= -1000) {
            super.Width(width);
        } else {
            this.container.$form().dispatchErrorOccurredEvent(this, "Width", 1002, new Object[0]);
        }
    }

    @SimpleProperty
    public void Height(int height) {
        if (height > 0 || height == -2 || height == -1 || height <= -1000) {
            super.Height(height);
        } else {
            this.container.$form().dispatchErrorOccurredEvent(this, "Height", 1003, new Object[0]);
        }
    }

    @SimpleProperty(description="The color of the canvas background.", category=PropertyCategory.APPEARANCE)
    public int BackgroundColor() {
        return this.backgroundColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&HFFFFFFFF")
    @SimpleProperty
    public void BackgroundColor(int argb) {
        this.view.setBackgroundColor(argb);
    }

    @SimpleProperty(description="The name of a file containing the background image for the canvas", category=PropertyCategory.APPEARANCE)
    public String BackgroundImage() {
        return this.backgroundImagePath;
    }

    @DesignerProperty(editorType="asset", defaultValue="")
    @SimpleProperty
    public void BackgroundImage(String path) {
        this.view.setBackgroundImage(path);
    }

    @SimpleProperty(description="The color in which lines are drawn", category=PropertyCategory.APPEARANCE)
    public int PaintColor() {
        return this.paintColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&HFF000000")
    @SimpleProperty
    public void PaintColor(int argb) {
        this.paintColor = argb;
        this.changePaint(this.paint, argb);
    }

    private void changePaint(Paint paint, int argb) {
        if (argb == 0) {
            PaintUtil.changePaint(paint, -16777216);
        } else if (argb == 0xFFFFFF) {
            PaintUtil.changePaintTransparent(paint);
        } else {
            PaintUtil.changePaint(paint, argb);
        }
    }

    @SimpleProperty(description="The font size of text drawn on the canvas.", category=PropertyCategory.APPEARANCE)
    public float FontSize() {
        float scale = this.$form().deviceDensity();
        return this.paint.getTextSize() / scale;
    }

    @DesignerProperty(editorType="non_negative_float", defaultValue="14.0")
    @SimpleProperty
    public void FontSize(float size) {
        float scale = this.$form().deviceDensity();
        this.paint.setTextSize(size * scale);
    }

    @SimpleProperty(description="The width of lines drawn on the canvas.", category=PropertyCategory.APPEARANCE)
    public float LineWidth() {
        return this.paint.getStrokeWidth() / this.$form().deviceDensity();
    }

    @DesignerProperty(editorType="non_negative_float", defaultValue="2.0")
    @SimpleProperty
    public void LineWidth(float width) {
        this.paint.setStrokeWidth(width * this.$form().deviceDensity());
    }

    @SimpleProperty(description="Determines the alignment of the text drawn by DrawText() or DrawAngle() with respect to the point specified by that command: point at the left of the text, point at the center of the text, or point at the right of the text.", category=PropertyCategory.APPEARANCE, userVisible=true)
    public int TextAlignment() {
        return this.textAlignment;
    }

    @DesignerProperty(editorType="textalignment", defaultValue="1")
    @SimpleProperty(userVisible=true)
    public void TextAlignment(int alignment) {
        this.textAlignment = alignment;
        switch (alignment) {
            case 0: {
                this.paint.setTextAlign(Paint.Align.LEFT);
                break;
            }
            case 1: {
                this.paint.setTextAlign(Paint.Align.CENTER);
                break;
            }
            case 2: {
                this.paint.setTextAlign(Paint.Align.RIGHT);
            }
        }
    }

    @SimpleEvent
    public void Touched(float x, float y, boolean touchedAnySprite) {
        EventDispatcher.dispatchEvent(this, "Touched", Float.valueOf(x), Float.valueOf(y), touchedAnySprite);
    }

    @SimpleEvent
    public void TouchDown(float x, float y) {
        EventDispatcher.dispatchEvent(this, "TouchDown", Float.valueOf(x), Float.valueOf(y));
    }

    @SimpleEvent
    public void TouchUp(float x, float y) {
        EventDispatcher.dispatchEvent(this, "TouchUp", Float.valueOf(x), Float.valueOf(y));
    }

    @SimpleEvent
    public void Flung(float x, float y, float speed, float heading, float xvel, float yvel, boolean flungSprite) {
        EventDispatcher.dispatchEvent(this, "Flung", Float.valueOf(x), Float.valueOf(y), Float.valueOf(speed), Float.valueOf(heading), Float.valueOf(xvel), Float.valueOf(yvel), flungSprite);
    }

    @SimpleEvent
    public void Dragged(float startX, float startY, float prevX, float prevY, float currentX, float currentY, boolean draggedAnySprite) {
        EventDispatcher.dispatchEvent(this, "Dragged", Float.valueOf(startX), Float.valueOf(startY), Float.valueOf(prevX), Float.valueOf(prevY), Float.valueOf(currentX), Float.valueOf(currentY), draggedAnySprite);
    }

    @SimpleFunction(description="Clears anything drawn on this Canvas but not any background color or image.")
    public void Clear() {
        this.view.clearDrawingLayer();
    }

    @SimpleFunction
    public void DrawPoint(int x, int y) {
        float correctedX = (float)x * this.$form().deviceDensity();
        float correctedY = (float)y * this.$form().deviceDensity();
        this.view.canvas.drawPoint(correctedX, correctedY, this.paint);
        this.view.invalidate();
    }

    @SimpleFunction
    public void DrawCircle(int centerX, int centerY, float radius, boolean fill) {
        float correctedX = (float)centerX * this.$form().deviceDensity();
        float correctedY = (float)centerY * this.$form().deviceDensity();
        float correctedR = radius * this.$form().deviceDensity();
        Paint p = new Paint(this.paint);
        p.setStyle(fill ? Paint.Style.FILL : Paint.Style.STROKE);
        this.view.canvas.drawCircle(correctedX, correctedY, correctedR, p);
        this.view.invalidate();
    }

    @SimpleFunction
    public void DrawLine(int x1, int y1, int x2, int y2) {
        float correctedX1 = (float)x1 * this.$form().deviceDensity();
        float correctedY1 = (float)y1 * this.$form().deviceDensity();
        float correctedX2 = (float)x2 * this.$form().deviceDensity();
        float correctedY2 = (float)y2 * this.$form().deviceDensity();
        this.view.canvas.drawLine(correctedX1, correctedY1, correctedX2, correctedY2, this.paint);
        this.view.invalidate();
    }

    @SimpleFunction(description="Draws the specified text relative to the specified coordinates using the values of the FontSize and TextAlignment properties.")
    public void DrawText(String text, int x, int y) {
        float fontScalingFactor = this.$form().deviceDensity();
        float correctedX = (float)x * fontScalingFactor;
        float correctedY = (float)y * fontScalingFactor;
        this.view.canvas.drawText(text, correctedX, correctedY, this.paint);
        this.view.invalidate();
    }

    @SimpleFunction(description="Draws the specified text starting at the specified coordinates at the specified angle using the values of the FontSize and TextAlignment properties.")
    public void DrawTextAtAngle(String text, int x, int y, float angle) {
        int correctedX = (int)((float)x * this.$form().deviceDensity());
        int correctedY = (int)((float)y * this.$form().deviceDensity());
        this.view.drawTextAtAngle(text, correctedX, correctedY, angle);
    }

    @SimpleFunction(description="Gets the color of the specified point. This includes the background and any drawn points, lines, or circles but not sprites.")
    public int GetBackgroundPixelColor(int x, int y) {
        int correctedX = (int)((float)x * this.$form().deviceDensity());
        int correctedY = (int)((float)y * this.$form().deviceDensity());
        return this.view.getBackgroundPixelColor(correctedX, correctedY);
    }

    @SimpleFunction(description="Sets the color of the specified point. This differs from DrawPoint by having an argument for color.")
    public void SetBackgroundPixelColor(int x, int y, int color) {
        Paint pixelPaint = new Paint();
        PaintUtil.changePaint(pixelPaint, color);
        int correctedX = (int)((float)x * this.$form().deviceDensity());
        int correctedY = (int)((float)y * this.$form().deviceDensity());
        this.view.canvas.drawPoint((float)correctedX, (float)correctedY, pixelPaint);
        this.view.invalidate();
    }

    @SimpleFunction(description="Gets the color of the specified point.")
    public int GetPixelColor(int x, int y) {
        int correctedX = (int)((float)x * this.$form().deviceDensity());
        int correctedY = (int)((float)y * this.$form().deviceDensity());
        return this.view.getPixelColor(correctedX, correctedY);
    }

    @SimpleFunction(description="Saves a picture of this Canvas to the device's external storage. If an error occurs, the Screen's ErrorOccurred event will be called.")
    public String Save() {
        try {
            File file = FileUtil.getPictureFile("png");
            return this.saveFile(file, Bitmap.CompressFormat.PNG, "Save");
        }
        catch (IOException e) {
            this.container.$form().dispatchErrorOccurredEvent(this, "Save", 708, e.getMessage());
        }
        catch (FileUtil.FileException e) {
            this.container.$form().dispatchErrorOccurredEvent(this, "Save", e.getErrorMessageNumber(), new Object[0]);
        }
        return "";
    }

    @SimpleFunction(description="Saves a picture of this Canvas to the device's external storage in the file named fileName. fileName must end with one of .jpg, .jpeg, or .png, which determines the file type.")
    public String SaveAs(String fileName) {
        Bitmap.CompressFormat format;
        if (fileName.endsWith(".jpg") || fileName.endsWith(".jpeg")) {
            format = Bitmap.CompressFormat.JPEG;
        } else if (fileName.endsWith(".png")) {
            format = Bitmap.CompressFormat.PNG;
        } else if (!fileName.contains(".")) {
            fileName = fileName + ".png";
            format = Bitmap.CompressFormat.PNG;
        } else {
            this.container.$form().dispatchErrorOccurredEvent(this, "SaveAs", 706, new Object[0]);
            return "";
        }
        try {
            File file = FileUtil.getExternalFile(fileName);
            return this.saveFile(file, format, "SaveAs");
        }
        catch (IOException e) {
            this.container.$form().dispatchErrorOccurredEvent(this, "SaveAs", 708, e.getMessage());
        }
        catch (FileUtil.FileException e) {
            this.container.$form().dispatchErrorOccurredEvent(this, "SaveAs", e.getErrorMessageNumber(), new Object[0]);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String saveFile(File file, Bitmap.CompressFormat format, String method) {
        try {
            boolean success = false;
            FileOutputStream fos = new FileOutputStream(file);
            Bitmap bitmap = this.view.completeCache == null ? this.view.buildCache() : this.view.completeCache;
            try {
                success = bitmap.compress(format, 100, (OutputStream)fos);
            }
            finally {
                fos.close();
            }
            if (success) {
                return file.getAbsolutePath();
            }
            this.container.$form().dispatchErrorOccurredEvent(this, method, 1001, new Object[0]);
        }
        catch (FileNotFoundException e) {
            this.container.$form().dispatchErrorOccurredEvent(this, method, 707, file.getAbsolutePath());
        }
        catch (IOException e) {
            this.container.$form().dispatchErrorOccurredEvent(this, method, 708, e.getMessage());
        }
        return "";
    }

    class FlingGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        FlingGestureListener() {
        }

        public boolean onFling(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
            float x = Math.max(0, (int)(e1.getX() / Canvas.this.$form().deviceDensity()));
            float y = Math.max(0, (int)(e1.getY() / Canvas.this.$form().deviceDensity()));
            float vx = velocityX / 1000.0f;
            float vy = velocityY / 1000.0f;
            float speed = (float)Math.sqrt(vx * vx + vy * vy);
            float heading = (float)(-Math.toDegrees(Math.atan2(vy, vx)));
            int width = Canvas.this.Width();
            int height = Canvas.this.Height();
            BoundingBox rect = new BoundingBox(Math.max(0, (int)x - 12), Math.max(0, (int)y - 12), Math.min(width - 1, (int)x + 12), Math.min(height - 1, (int)y + 12));
            boolean spriteHandledFling = false;
            for (Sprite sprite : Canvas.this.sprites) {
                if (!sprite.Enabled() || !sprite.Visible() || !sprite.intersectsWith(rect)) continue;
                sprite.Flung(x, y, speed, heading, vx, vy);
                spriteHandledFling = true;
            }
            Canvas.this.Flung(x, y, speed, heading, vx, vy, spriteHandledFling);
            return true;
        }
    }

    private final class CanvasView
    extends View {
        private android.graphics.Canvas canvas;
        private Bitmap bitmap;
        private BitmapDrawable backgroundDrawable;
        private Bitmap scaledBackgroundBitmap;
        private Bitmap completeCache;

        public CanvasView(Context context) {
            super(context);
            this.bitmap = Bitmap.createBitmap((int)32, (int)48, (Bitmap.Config)Bitmap.Config.ARGB_8888);
            this.canvas = new android.graphics.Canvas(this.bitmap);
        }

        private Bitmap buildCache() {
            this.setDrawingCacheEnabled(true);
            this.destroyDrawingCache();
            Bitmap cache = this.getDrawingCache();
            if (cache == null) {
                int width = this.getWidth();
                int height = this.getHeight();
                cache = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                android.graphics.Canvas c = new android.graphics.Canvas(cache);
                this.layout(0, 0, width, height);
                this.draw(c);
            }
            return cache;
        }

        public void onDraw(android.graphics.Canvas canvas0) {
            this.completeCache = null;
            super.onDraw(canvas0);
            canvas0.drawBitmap(this.bitmap, 0.0f, 0.0f, null);
            for (Sprite sprite : Canvas.this.sprites) {
                sprite.onDraw(canvas0);
            }
            Canvas.this.drawn = true;
        }

        protected void onSizeChanged(int w, int h, int oldW, int oldH) {
            int oldBitmapWidth = this.bitmap.getWidth();
            int oldBitmapHeight = this.bitmap.getHeight();
            if (w != oldBitmapWidth || h != oldBitmapHeight) {
                Bitmap oldBitmap = this.bitmap;
                try {
                    Bitmap scaledBitmap = Bitmap.createScaledBitmap((Bitmap)oldBitmap, (int)w, (int)h, (boolean)false);
                    if (scaledBitmap.isMutable()) {
                        this.bitmap = scaledBitmap;
                        this.canvas = new android.graphics.Canvas(this.bitmap);
                    } else {
                        this.bitmap = Bitmap.createBitmap((int)w, (int)h, (Bitmap.Config)Bitmap.Config.ARGB_8888);
                        this.canvas = new android.graphics.Canvas(this.bitmap);
                        Rect src = new Rect(0, 0, oldBitmapWidth, oldBitmapHeight);
                        RectF dst = new RectF(0.0f, 0.0f, (float)w, (float)h);
                        this.canvas.drawBitmap(oldBitmap, src, dst, null);
                    }
                }
                catch (IllegalArgumentException ioe) {
                    Log.e((String)Canvas.LOG_TAG, (String)("Bad values to createScaledBimap w = " + w + ", h = " + h));
                }
                this.scaledBackgroundBitmap = null;
            }
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int preferredHeight;
            int preferredWidth;
            if (this.backgroundDrawable != null) {
                Bitmap bitmap = this.backgroundDrawable.getBitmap();
                preferredWidth = bitmap.getWidth();
                preferredHeight = bitmap.getHeight();
            } else {
                preferredWidth = 32;
                preferredHeight = 48;
            }
            this.setMeasuredDimension(this.getSize(widthMeasureSpec, preferredWidth), this.getSize(heightMeasureSpec, preferredHeight));
        }

        private int getSize(int measureSpec, int preferredSize) {
            int result;
            int specMode = View.MeasureSpec.getMode((int)measureSpec);
            int specSize = View.MeasureSpec.getSize((int)measureSpec);
            if (specMode == 0x40000000) {
                result = specSize;
            } else {
                result = preferredSize;
                if (specMode == Integer.MIN_VALUE) {
                    result = Math.min(result, specSize);
                }
            }
            return result;
        }

        public boolean onTouchEvent(MotionEvent event) {
            Canvas.this.container.$form().dontGrabTouchEventsForComponent();
            Canvas.this.motionEventParser.parse(event);
            Canvas.this.mGestureDetector.onTouchEvent(event);
            for (ExtensionGestureDetector g : Canvas.this.extensionGestureDetectors) {
                g.onTouchEvent(event);
            }
            return true;
        }

        void setBackgroundImage(String path) {
            Canvas.this.backgroundImagePath = path == null ? "" : path;
            this.backgroundDrawable = null;
            this.scaledBackgroundBitmap = null;
            if (!TextUtils.isEmpty((CharSequence)Canvas.this.backgroundImagePath)) {
                try {
                    this.backgroundDrawable = MediaUtil.getBitmapDrawable(Canvas.this.container.$form(), Canvas.this.backgroundImagePath);
                }
                catch (IOException ioe) {
                    Log.e((String)Canvas.LOG_TAG, (String)("Unable to load " + Canvas.this.backgroundImagePath));
                }
            }
            this.setBackground();
            this.clearDrawingLayer();
        }

        private void setBackground() {
            BitmapDrawable setDraw = this.backgroundDrawable;
            if (Canvas.this.backgroundImagePath != "" && this.backgroundDrawable != null) {
                setDraw = this.backgroundDrawable.getConstantState().newDrawable();
                setDraw.setColorFilter(Canvas.this.backgroundColor != 0 ? Canvas.this.backgroundColor : -1, PorterDuff.Mode.DST_OVER);
            } else {
                setDraw = new ColorDrawable(Canvas.this.backgroundColor != 0 ? Canvas.this.backgroundColor : -1);
            }
            this.setBackgroundDrawable((Drawable)setDraw);
        }

        private void clearDrawingLayer() {
            this.canvas.drawColor(0, PorterDuff.Mode.CLEAR);
            this.invalidate();
        }

        public void setBackgroundColor(int color) {
            Canvas.this.backgroundColor = color;
            this.setBackground();
            this.clearDrawingLayer();
        }

        private void drawTextAtAngle(String text, int x, int y, float angle) {
            this.canvas.save();
            this.canvas.rotate(-angle, (float)x, (float)y);
            this.canvas.drawText(text, (float)x, (float)y, Canvas.this.paint);
            this.canvas.restore();
            this.invalidate();
        }

        private int getBackgroundPixelColor(int x, int y) {
            if (x < 0 || x >= this.bitmap.getWidth() || y < 0 || y >= this.bitmap.getHeight()) {
                return 0xFFFFFF;
            }
            try {
                int color = this.bitmap.getPixel(x, y);
                if (color != 0) {
                    return color;
                }
                if (this.backgroundDrawable != null) {
                    if (this.scaledBackgroundBitmap == null) {
                        this.scaledBackgroundBitmap = Bitmap.createScaledBitmap((Bitmap)this.backgroundDrawable.getBitmap(), (int)this.bitmap.getWidth(), (int)this.bitmap.getHeight(), (boolean)false);
                    }
                    color = this.scaledBackgroundBitmap.getPixel(x, y);
                    return color;
                }
                if (Color.alpha((int)Canvas.this.backgroundColor) != 0) {
                    return Canvas.this.backgroundColor;
                }
                return 0xFFFFFF;
            }
            catch (IllegalArgumentException e) {
                Log.e((String)Canvas.LOG_TAG, (String)String.format("Returning COLOR_NONE (exception) from getBackgroundPixelColor.", new Object[0]));
                return 0xFFFFFF;
            }
        }

        private int getPixelColor(int x, int y) {
            if (x < 0 || x >= this.bitmap.getWidth() || y < 0 || y >= this.bitmap.getHeight()) {
                return 0xFFFFFF;
            }
            if (this.completeCache == null) {
                boolean anySpritesVisible = false;
                for (Sprite sprite : Canvas.this.sprites) {
                    if (!sprite.Visible()) continue;
                    anySpritesVisible = true;
                    break;
                }
                if (!anySpritesVisible) {
                    return this.getBackgroundPixelColor(x, y);
                }
                this.completeCache = this.buildCache();
            }
            try {
                return this.completeCache.getPixel(x, y);
            }
            catch (IllegalArgumentException e) {
                Log.e((String)Canvas.LOG_TAG, (String)String.format("Returning COLOR_NONE (exception) from getPixelColor.", new Object[0]));
                return 0xFFFFFF;
            }
        }
    }

    class MotionEventParser {
        public static final int TAP_THRESHOLD = 15;
        public static final int FINGER_WIDTH = 24;
        public static final int FINGER_HEIGHT = 24;
        private static final int HALF_FINGER_WIDTH = 12;
        private static final int HALF_FINGER_HEIGHT = 12;
        private final List<Sprite> draggedSprites = new ArrayList<Sprite>();
        private static final int UNSET = -1;
        private float startX = -1.0f;
        private float startY = -1.0f;
        private float lastX = -1.0f;
        private float lastY = -1.0f;
        private boolean isDrag = false;
        private boolean drag = false;

        MotionEventParser() {
        }

        void parse(MotionEvent event) {
            int width = Canvas.this.Width();
            int height = Canvas.this.Height();
            float x = Math.max(0.0f, (float)((int)event.getX()) / Canvas.this.$form().deviceDensity());
            float y = Math.max(0.0f, (float)((int)event.getY()) / Canvas.this.$form().deviceDensity());
            BoundingBox rect = new BoundingBox(Math.max(0, (int)x - 12), Math.max(0, (int)y - 12), Math.min(width - 1, (int)x + 12), Math.min(height - 1, (int)y + 12));
            switch (event.getAction()) {
                case 0: {
                    this.draggedSprites.clear();
                    this.startX = x;
                    this.startY = y;
                    this.lastX = x;
                    this.lastY = y;
                    this.drag = false;
                    this.isDrag = false;
                    for (Sprite sprite : Canvas.this.sprites) {
                        if (!sprite.Enabled() || !sprite.Visible() || !sprite.intersectsWith(rect)) continue;
                        this.draggedSprites.add(sprite);
                        sprite.TouchDown(this.startX, this.startY);
                    }
                    Canvas.this.TouchDown(this.startX, this.startY);
                    break;
                }
                case 2: {
                    if (this.startX == -1.0f || this.startY == -1.0f || this.lastX == -1.0f || this.lastY == -1.0f) {
                        Log.w((String)Canvas.LOG_TAG, (String)("In Canvas.MotionEventParser.parse(), an ACTION_MOVE was passed without a preceding ACTION_DOWN: " + event));
                    }
                    if (!this.isDrag && Math.abs(x - this.startX) < 15.0f && Math.abs(y - this.startY) < 15.0f) break;
                    this.isDrag = true;
                    this.drag = true;
                    for (Sprite sprite : Canvas.this.sprites) {
                        if (this.draggedSprites.contains(sprite) || !sprite.Enabled() || !sprite.Visible() || !sprite.intersectsWith(rect)) continue;
                        this.draggedSprites.add(sprite);
                    }
                    boolean handled = false;
                    for (Sprite sprite : this.draggedSprites) {
                        if (!sprite.Enabled() || !sprite.Visible()) continue;
                        sprite.Dragged(this.startX, this.startY, this.lastX, this.lastY, x, y);
                        handled = true;
                    }
                    Canvas.this.Dragged(this.startX, this.startY, this.lastX, this.lastY, x, y, handled);
                    this.lastX = x;
                    this.lastY = y;
                    break;
                }
                case 1: {
                    if (!this.drag) {
                        boolean handled = false;
                        for (Sprite sprite : this.draggedSprites) {
                            if (!sprite.Enabled() || !sprite.Visible()) continue;
                            sprite.Touched(x, y);
                            sprite.TouchUp(x, y);
                            handled = true;
                        }
                        Canvas.this.Touched(x, y, handled);
                    } else {
                        for (Sprite sprite : this.draggedSprites) {
                            if (!sprite.Enabled() || !sprite.Visible()) continue;
                            sprite.Touched(x, y);
                            sprite.TouchUp(x, y);
                        }
                    }
                    Canvas.this.TouchUp(x, y);
                    this.drag = false;
                    this.startX = -1.0f;
                    this.startY = -1.0f;
                    this.lastX = -1.0f;
                    this.lastY = -1.0f;
                }
            }
        }
    }

    public static interface ExtensionGestureDetector {
        public boolean onTouchEvent(MotionEvent var1);
    }
}

