/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.ContentValues;
import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.os.Parcelable;
import android.provider.MediaStore;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ActivityResultListener;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import java.io.File;
import java.util.Date;

@DesignerComponent(version=3, description="A component to take a picture using the device's camera. After the picture is taken, the name of the file on the phone containing the picture is available as an argument to the AfterPicture event. The file name can be used, for example, to set the Picture property of an Image component.", category=ComponentCategory.MEDIA, nonVisible=true, iconName="images/camera.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.WRITE_EXTERNAL_STORAGE, android.permission.READ_EXTERNAL_STORAGE")
public class Camera
extends AndroidNonvisibleComponent
implements ActivityResultListener,
Component {
    private static final String CAMERA_INTENT = "android.media.action.IMAGE_CAPTURE";
    private static final String CAMERA_OUTPUT = "output";
    private final ComponentContainer container;
    private Uri imageFile;
    private int requestCode;
    private boolean useFront;

    public Camera(ComponentContainer container) {
        super(container.$form());
        this.container = container;
        this.UseFront(false);
    }

    @Deprecated
    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean UseFront() {
        return this.useFront;
    }

    @Deprecated
    @SimpleProperty(description="Specifies whether the front-facing camera should be used (when available). If the device does not have a front-facing camera, this option will be ignored and the camera will open normally.")
    public void UseFront(boolean front) {
        this.useFront = front;
    }

    @SimpleFunction
    public void TakePicture() {
        Date date = new Date();
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            Log.i((String)"CameraComponent", (String)"External storage is available and writable");
            this.imageFile = Uri.fromFile((File)new File(Environment.getExternalStorageDirectory(), "/Pictures/app_inventor_" + date.getTime() + ".jpg"));
            ContentValues values = new ContentValues();
            values.put("_data", this.imageFile.getPath());
            values.put("mime_type", "image/jpeg");
            values.put("title", this.imageFile.getLastPathSegment());
            if (this.requestCode == 0) {
                this.requestCode = this.form.registerForActivityResult(this);
            }
            Uri imageUri = this.container.$context().getContentResolver().insert(MediaStore.Images.Media.INTERNAL_CONTENT_URI, values);
            Intent intent = new Intent(CAMERA_INTENT);
            intent.putExtra(CAMERA_OUTPUT, (Parcelable)imageUri);
            if (this.useFront) {
                intent.putExtra("android.intent.extras.CAMERA_FACING", 1);
            }
            this.container.$context().startActivityForResult(intent, this.requestCode);
        } else if ("mounted_ro".equals(state)) {
            this.form.dispatchErrorOccurredEvent(this, "TakePicture", 704, new Object[0]);
        } else {
            this.form.dispatchErrorOccurredEvent(this, "TakePicture", 705, new Object[0]);
        }
    }

    public void resultReturned(int requestCode, int resultCode, Intent data) {
        Log.i((String)"CameraComponent", (String)("Returning result. Request code = " + requestCode + ", result code = " + resultCode));
        if (requestCode == this.requestCode && resultCode == -1) {
            File image = new File(this.imageFile.getPath());
            if (image.length() != 0L) {
                this.scanFileToAdd(image);
                this.AfterPicture(this.imageFile.toString());
            } else {
                this.deleteFile(this.imageFile);
                if (data != null && data.getData() != null) {
                    Uri tryImageUri = data.getData();
                    Log.i((String)"CameraComponent", (String)("Calling Camera.AfterPicture with image path " + tryImageUri.toString()));
                    this.AfterPicture(tryImageUri.toString());
                } else {
                    Log.i((String)"CameraComponent", (String)"Couldn't find an image file from the Camera result");
                    this.form.dispatchErrorOccurredEvent(this, "TakePicture", 201, new Object[0]);
                }
            }
        } else {
            this.deleteFile(this.imageFile);
        }
    }

    private void scanFileToAdd(File image) {
        Intent mediaScanIntent = new Intent("android.intent.action.MEDIA_SCANNER_SCAN_FILE");
        Uri contentUri = Uri.fromFile((File)image);
        mediaScanIntent.setData(contentUri);
        this.container.$context().getApplicationContext().sendBroadcast(mediaScanIntent);
    }

    private void deleteFile(Uri fileUri) {
        File fileToDelete = new File(fileUri.getPath());
        try {
            if (fileToDelete.delete()) {
                Log.i((String)"CameraComponent", (String)("Deleted file " + fileUri.toString()));
            } else {
                Log.i((String)"CameraComponent", (String)("Could not delete file " + fileUri.toString()));
            }
        }
        catch (SecurityException e) {
            Log.i((String)"CameraComponent", (String)("Got security exception trying to delete file " + fileUri.toString()));
        }
    }

    @SimpleEvent
    public void AfterPicture(String image) {
        EventDispatcher.dispatchEvent(this, "AfterPicture", image);
    }
}

