/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Intent;
import android.net.Uri;
import android.os.Environment;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ActivityResultListener;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import java.io.File;

@DesignerComponent(version=1, description="A component to record a video using the device's camcorder.After the video is recorded, the name of the file on the phone containing the clip is available as an argument to the AfterRecording event. The file name can be used, for example, to set the source property of a VideoPlayer component.", category=ComponentCategory.MEDIA, nonVisible=true, iconName="images/camcorder.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.WRITE_EXTERNAL_STORAGE, android.permission.READ_EXTERNAL_STORAGE")
public class Camcorder
extends AndroidNonvisibleComponent
implements ActivityResultListener,
Component {
    private static final String CAMCORDER_INTENT = "android.media.action.VIDEO_CAPTURE";
    private final ComponentContainer container;
    private int requestCode;

    public Camcorder(ComponentContainer container) {
        super(container.$form());
        this.container = container;
    }

    @SimpleFunction
    public void RecordVideo() {
        String state = Environment.getExternalStorageState();
        if ("mounted".equals(state)) {
            Log.i((String)"CamcorderComponent", (String)"External storage is available and writable");
            if (this.requestCode == 0) {
                this.requestCode = this.form.registerForActivityResult(this);
            }
            Intent intent = new Intent(CAMCORDER_INTENT);
            this.container.$context().startActivityForResult(intent, this.requestCode);
        } else if ("mounted_ro".equals(state)) {
            this.form.dispatchErrorOccurredEvent(this, "RecordVideo", 704, new Object[0]);
        } else {
            this.form.dispatchErrorOccurredEvent(this, "RecordVideo", 705, new Object[0]);
        }
    }

    public void resultReturned(int requestCode, int resultCode, Intent data) {
        Log.i((String)"CamcorderComponent", (String)("Returning result. Request code = " + requestCode + ", result code = " + resultCode));
        if (requestCode == this.requestCode && resultCode == -1) {
            if (data != null && data.getData() != null) {
                Uri tryClipUri = data.getData();
                Log.i((String)"CamcorderComponent", (String)("Calling Camcorder.AfterPicture with clip path " + tryClipUri.toString()));
                this.AfterRecording(tryClipUri.toString());
            } else {
                Log.i((String)"CamcorderComponent", (String)"Couldn't find a clip file from the Camcorder result");
                this.form.dispatchErrorOccurredEvent(this, "TakeVideo", 1201, new Object[0]);
            }
        } else {
            Log.i((String)"CamcorderComponent", (String)"No clip filed rerturn; request failed");
            this.form.dispatchErrorOccurredEvent(this, "TakeVideo", 1201, new Object[0]);
        }
    }

    private void deleteFile(Uri fileUri) {
        File fileToDelete = new File(fileUri.getPath());
        try {
            if (fileToDelete.delete()) {
                Log.i((String)"CamcorderComponent", (String)("Deleted file " + fileUri.toString()));
            } else {
                Log.i((String)"CamcorderComponent", (String)("Could not delete file " + fileUri.toString()));
            }
        }
        catch (SecurityException e) {
            Log.i((String)"CamcorderComponent", (String)("Got security exception trying to delete file " + fileUri.toString()));
        }
    }

    @SimpleEvent
    public void AfterRecording(String clip) {
        EventDispatcher.dispatchEvent(this, "AfterRecording", clip);
    }
}

