/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.shapes.OvalShape;
import android.graphics.drawable.shapes.RectShape;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.Button;
import android.widget.TextView;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.runtime.AndroidViewComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.util.MediaUtil;
import com.google.appinventor.components.runtime.util.TextViewUtil;
import com.google.appinventor.components.runtime.util.ViewUtil;
import java.io.IOException;

@SimpleObject
@UsesPermissions(permissionNames="android.permission.INTERNET")
public abstract class ButtonBase
extends AndroidViewComponent
implements View.OnClickListener,
View.OnFocusChangeListener,
View.OnLongClickListener,
View.OnTouchListener {
    private static final String LOG_TAG = "ButtonBase";
    private final Button view;
    private static final float ROUNDED_CORNERS_RADIUS = 10.0f;
    private static final float[] ROUNDED_CORNERS_ARRAY = new float[]{10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f, 10.0f};
    private static final int SHAPED_DEFAULT_BACKGROUND_COLOR = -3355444;
    private int textAlignment;
    private int backgroundColor;
    private int fontTypeface;
    private boolean bold;
    private boolean showFeedback = true;
    private boolean italic;
    private int textColor;
    private int shape;
    private String imagePath = "";
    private Drawable defaultButtonDrawable;
    private ColorStateList defaultColorStateList;
    private Drawable backgroundImageDrawable;

    public ButtonBase(ComponentContainer container) {
        super(container);
        this.view = new Button((Context)container.$context());
        this.defaultButtonDrawable = this.view.getBackground();
        this.defaultColorStateList = this.view.getTextColors();
        container.$add(this);
        this.view.setOnClickListener((View.OnClickListener)this);
        this.view.setOnFocusChangeListener((View.OnFocusChangeListener)this);
        this.view.setOnLongClickListener((View.OnLongClickListener)this);
        this.view.setOnTouchListener((View.OnTouchListener)this);
        this.TextAlignment(1);
        this.BackgroundColor(0);
        this.Image("");
        this.Enabled(true);
        this.fontTypeface = 0;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, this.bold, this.italic);
        this.FontSize(14.0f);
        this.Text("");
        this.TextColor(0);
        this.Shape(0);
    }

    public boolean onTouch(View view, MotionEvent me) {
        if (me.getAction() == 0) {
            if (this.ShowFeedback()) {
                view.getBackground().setAlpha(70);
                view.invalidate();
            }
            this.TouchDown();
        } else if (me.getAction() == 1 || me.getAction() == 3) {
            if (this.ShowFeedback()) {
                view.getBackground().setAlpha(255);
                view.invalidate();
            }
            this.TouchUp();
        }
        return false;
    }

    public View getView() {
        return this.view;
    }

    @SimpleEvent(description="Indicates that the button was pressed down.")
    public void TouchDown() {
        EventDispatcher.dispatchEvent(this, "TouchDown", new Object[0]);
    }

    @SimpleEvent(description="Indicates that a button has been released.")
    public void TouchUp() {
        EventDispatcher.dispatchEvent(this, "TouchUp", new Object[0]);
    }

    @SimpleEvent(description="Indicates the cursor moved over the button so it is now possible to click it.")
    public void GotFocus() {
        EventDispatcher.dispatchEvent(this, "GotFocus", new Object[0]);
    }

    @SimpleEvent(description="Indicates the cursor moved away from the button so it is now no longer possible to click it.")
    public void LostFocus() {
        EventDispatcher.dispatchEvent(this, "LostFocus", new Object[0]);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Left, center, or right.", userVisible=false)
    public int TextAlignment() {
        return this.textAlignment;
    }

    @DesignerProperty(editorType="textalignment", defaultValue="1")
    @SimpleProperty(userVisible=false)
    public void TextAlignment(int alignment) {
        this.textAlignment = alignment;
        TextViewUtil.setAlignment((TextView)this.view, alignment, true);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, userVisible=false)
    public int Shape() {
        return this.shape;
    }

    @DesignerProperty(editorType="button_shape", defaultValue="0")
    @SimpleProperty(description="Specifies the button's shape (default, rounded, rectangular, oval). The shape will not be visible if an Image is being displayed.", userVisible=false)
    public void Shape(int shape) {
        this.shape = shape;
        this.updateAppearance();
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Image to display on button.")
    public String Image() {
        return this.imagePath;
    }

    @DesignerProperty(editorType="asset", defaultValue="")
    @SimpleProperty(description="Specifies the path of the button's image.  If there is both an Image and a BackgroundColor, only the Image will be visible.")
    public void Image(String path) {
        if (path.equals(this.imagePath) && this.backgroundImageDrawable != null) {
            return;
        }
        this.imagePath = path == null ? "" : path;
        this.backgroundImageDrawable = null;
        if (this.imagePath.length() > 0) {
            try {
                this.backgroundImageDrawable = MediaUtil.getBitmapDrawable(this.container.$form(), this.imagePath);
            }
            catch (IOException ioe) {
                Log.e((String)LOG_TAG, (String)("Unable to load " + this.imagePath));
            }
        }
        this.updateAppearance();
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Returns the button's background color")
    public int BackgroundColor() {
        return this.backgroundColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&H00000000")
    @SimpleProperty(description="Specifies the button's background color. The background color will not be visible if an Image is being displayed.")
    public void BackgroundColor(int argb) {
        this.backgroundColor = argb;
        this.updateAppearance();
    }

    private void updateAppearance() {
        if (this.backgroundImageDrawable == null) {
            if (this.shape == 0) {
                if (this.backgroundColor == 0) {
                    ViewUtil.setBackgroundDrawable((View)this.view, this.defaultButtonDrawable);
                } else {
                    ViewUtil.setBackgroundDrawable((View)this.view, null);
                    TextViewUtil.setBackgroundColor((TextView)this.view, this.backgroundColor);
                }
            } else {
                this.setShape();
            }
        } else {
            ViewUtil.setBackgroundImage((View)this.view, this.backgroundImageDrawable);
        }
    }

    private void setShape() {
        ShapeDrawable drawable2 = new ShapeDrawable();
        drawable2.getPaint().setColor(this.backgroundColor == 0 ? -3355444 : this.backgroundColor);
        switch (this.shape) {
            case 1: {
                drawable2.setShape((Shape)new RoundRectShape(ROUNDED_CORNERS_ARRAY, null, null));
                break;
            }
            case 2: {
                drawable2.setShape((Shape)new RectShape());
                break;
            }
            case 3: {
                drawable2.setShape((Shape)new OvalShape());
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.view.setBackgroundDrawable((Drawable)drawable2);
        this.view.invalidate();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="If set, user can tap check box to cause action.")
    public boolean Enabled() {
        return TextViewUtil.isEnabled((TextView)this.view);
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void Enabled(boolean enabled) {
        TextViewUtil.setEnabled((TextView)this.view, enabled);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="If set, button text is displayed in bold.")
    public boolean FontBold() {
        return this.bold;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public void FontBold(boolean bold) {
        this.bold = bold;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, bold, this.italic);
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty(description="Specifies if a visual feedback should be shown  for a button that as an image as background.")
    public void ShowFeedback(boolean showFeedback) {
        this.showFeedback = showFeedback;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Returns the button's visual feedback state")
    public boolean ShowFeedback() {
        return this.showFeedback;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="If set, button text is displayed in italics.")
    public boolean FontItalic() {
        return this.italic;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public void FontItalic(boolean italic) {
        this.italic = italic;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, this.bold, italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Point size for button text.")
    public float FontSize() {
        return TextViewUtil.getFontSize((TextView)this.view, (Context)this.container.$context());
    }

    @DesignerProperty(editorType="non_negative_float", defaultValue="14.0")
    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public void FontSize(float size) {
        TextViewUtil.setFontSize((TextView)this.view, size);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Font family for button text.", userVisible=false)
    public int FontTypeface() {
        return this.fontTypeface;
    }

    @DesignerProperty(editorType="typeface", defaultValue="0")
    @SimpleProperty(userVisible=false)
    public void FontTypeface(int typeface) {
        this.fontTypeface = typeface;
        TextViewUtil.setFontTypeface((TextView)this.view, this.fontTypeface, this.bold, this.italic);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Text to display on button.")
    public String Text() {
        return TextViewUtil.getText((TextView)this.view);
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void Text(String text) {
        TextViewUtil.setText((TextView)this.view, text);
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="Color for button text.")
    public int TextColor() {
        return this.textColor;
    }

    @DesignerProperty(editorType="color", defaultValue="&H00000000")
    @SimpleProperty
    public void TextColor(int argb) {
        this.textColor = argb;
        if (argb != 0) {
            TextViewUtil.setTextColor((TextView)this.view, argb);
        } else {
            TextViewUtil.setTextColors((TextView)this.view, this.defaultColorStateList);
        }
    }

    public abstract void click();

    public boolean longClick() {
        return false;
    }

    public void onClick(View view) {
        this.click();
    }

    public void onFocusChange(View previouslyFocused, boolean gainFocus) {
        if (gainFocus) {
            this.GotFocus();
        } else {
            this.LostFocus();
        }
    }

    public boolean onLongClick(View view) {
        return this.longClick();
    }
}

