/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.os.Handler;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.BluetoothConnectionBase;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.util.AsynchUtil;
import com.google.appinventor.components.runtime.util.BluetoothReflection;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.io.IOException;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicReference;

@DesignerComponent(version=5, description="Bluetooth server component", category=ComponentCategory.CONNECTIVITY, nonVisible=true, iconName="images/bluetooth.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.BLUETOOTH, android.permission.BLUETOOTH_ADMIN")
public final class BluetoothServer
extends BluetoothConnectionBase {
    private static final String SPP_UUID = "00001101-0000-1000-8000-00805F9B34FB";
    private final Handler androidUIHandler = new Handler();
    private final AtomicReference<Object> arBluetoothServerSocket = new AtomicReference();

    public BluetoothServer(ComponentContainer container) {
        super(container, "BluetoothServer");
    }

    @SimpleFunction(description="Accept an incoming connection with the Serial Port Profile (SPP).")
    public void AcceptConnection(String serviceName) {
        this.accept("AcceptConnection", serviceName, SPP_UUID);
    }

    @SimpleFunction(description="Accept an incoming connection with a specific UUID.")
    public void AcceptConnectionWithUUID(String serviceName, String uuid) {
        this.accept("AcceptConnectionWithUUID", serviceName, uuid);
    }

    private void accept(final String functionName, String name, String uuidString) {
        UUID uuid;
        Object bluetoothAdapter = BluetoothReflection.getBluetoothAdapter();
        if (bluetoothAdapter == null) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 501, new Object[0]);
            return;
        }
        if (!BluetoothReflection.isBluetoothEnabled(bluetoothAdapter)) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 502, new Object[0]);
            return;
        }
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 506, uuidString);
            return;
        }
        try {
            Object bluetoothServerSocket = !this.secure && SdkLevel.getLevel() >= 10 ? BluetoothReflection.listenUsingInsecureRfcommWithServiceRecord(bluetoothAdapter, name, uuid) : BluetoothReflection.listenUsingRfcommWithServiceRecord(bluetoothAdapter, name, uuid);
            this.arBluetoothServerSocket.set(bluetoothServerSocket);
        }
        catch (IOException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 508, new Object[0]);
            return;
        }
        AsynchUtil.runAsynchronously(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object acceptedBluetoothSocket = null;
                Object bluetoothServerSocket = BluetoothServer.this.arBluetoothServerSocket.get();
                if (bluetoothServerSocket != null) {
                    try {
                        try {
                            acceptedBluetoothSocket = BluetoothReflection.accept(bluetoothServerSocket);
                        }
                        catch (IOException e) {
                            BluetoothServer.this.androidUIHandler.post(new Runnable(){

                                public void run() {
                                    BluetoothServer.this.form.dispatchErrorOccurredEvent(BluetoothServer.this, functionName, 509, new Object[0]);
                                }
                            });
                            BluetoothServer.this.StopAccepting();
                            return;
                        }
                    }
                    finally {
                        BluetoothServer.this.StopAccepting();
                    }
                }
                if (acceptedBluetoothSocket != null) {
                    final Object bluetoothSocket = acceptedBluetoothSocket;
                    BluetoothServer.this.androidUIHandler.post(new Runnable(){

                        public void run() {
                            try {
                                BluetoothServer.this.setConnection(bluetoothSocket);
                            }
                            catch (IOException e) {
                                BluetoothServer.this.Disconnect();
                                BluetoothServer.this.form.dispatchErrorOccurredEvent(BluetoothServer.this, functionName, 509, new Object[0]);
                                return;
                            }
                            BluetoothServer.this.ConnectionAccepted();
                        }
                    });
                }
            }
        });
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public final boolean IsAccepting() {
        return this.arBluetoothServerSocket.get() != null;
    }

    @SimpleFunction(description="Stop accepting an incoming connection.")
    public void StopAccepting() {
        Object bluetoothServerSocket = this.arBluetoothServerSocket.getAndSet(null);
        if (bluetoothServerSocket != null) {
            try {
                BluetoothReflection.closeBluetoothServerSocket(bluetoothServerSocket);
            }
            catch (IOException e) {
                Log.w((String)this.logTag, (String)("Error while closing bluetooth server socket: " + e.getMessage()));
            }
        }
    }

    @SimpleEvent(description="Indicates that a bluetooth connection has been accepted.")
    public void ConnectionAccepted() {
        Log.i((String)this.logTag, (String)"Successfullly accepted bluetooth connection.");
        EventDispatcher.dispatchEvent(this, "ConnectionAccepted", new Object[0]);
    }
}

