/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.util.Log;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.BluetoothConnectionListener;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.OnDestroyListener;
import com.google.appinventor.components.runtime.util.BluetoothReflection;
import com.google.appinventor.components.runtime.util.YailList;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@SimpleObject
public abstract class BluetoothConnectionBase
extends AndroidNonvisibleComponent
implements Component,
OnDestroyListener,
Deleteable {
    protected final String logTag;
    private final List<BluetoothConnectionListener> bluetoothConnectionListeners = new ArrayList<BluetoothConnectionListener>();
    private ByteOrder byteOrder;
    private String encoding;
    private byte delimiter;
    protected boolean secure;
    private Object connectedBluetoothSocket;
    private InputStream inputStream;
    private OutputStream outputStream;

    protected BluetoothConnectionBase(ComponentContainer container, String logTag) {
        this(container.$form(), logTag);
        this.form.registerForOnDestroy(this);
    }

    private BluetoothConnectionBase(Form form, String logTag) {
        super(form);
        this.logTag = logTag;
        this.HighByteFirst(false);
        this.CharacterEncoding("UTF-8");
        this.DelimiterByte(0);
        this.Secure(true);
    }

    protected BluetoothConnectionBase(OutputStream outputStream, InputStream inputStream) {
        this((Form)null, (String)null);
        this.connectedBluetoothSocket = "Not Null";
        this.outputStream = outputStream;
        this.inputStream = inputStream;
    }

    void addBluetoothConnectionListener(BluetoothConnectionListener listener) {
        this.bluetoothConnectionListeners.add(listener);
    }

    void removeBluetoothConnectionListener(BluetoothConnectionListener listener) {
        this.bluetoothConnectionListeners.remove(listener);
    }

    private void fireAfterConnectEvent() {
        for (BluetoothConnectionListener listener : this.bluetoothConnectionListeners) {
            listener.afterConnect(this);
        }
    }

    private void fireBeforeDisconnectEvent() {
        for (BluetoothConnectionListener listener : this.bluetoothConnectionListeners) {
            listener.beforeDisconnect(this);
        }
    }

    public final void Initialize() {
    }

    @SimpleEvent(description="The BluetoothError event is no longer used. Please use the Screen.ErrorOccurred event instead.", userVisible=false)
    public void BluetoothError(String functionName, String message) {
    }

    protected void bluetoothError(String functionName, int errorNumber, Object ... messageArgs) {
        this.form.dispatchErrorOccurredEvent(this, functionName, errorNumber, messageArgs);
    }

    @SimpleProperty(description="Whether Bluetooth is available on the device", category=PropertyCategory.BEHAVIOR)
    public boolean Available() {
        Object bluetoothAdapter = BluetoothReflection.getBluetoothAdapter();
        return bluetoothAdapter != null;
    }

    @SimpleProperty(description="Whether Bluetooth is enabled", category=PropertyCategory.BEHAVIOR)
    public boolean Enabled() {
        Object bluetoothAdapter = BluetoothReflection.getBluetoothAdapter();
        return bluetoothAdapter != null && BluetoothReflection.isBluetoothEnabled(bluetoothAdapter);
    }

    protected final void setConnection(Object bluetoothSocket) throws IOException {
        this.connectedBluetoothSocket = bluetoothSocket;
        this.inputStream = new BufferedInputStream(BluetoothReflection.getInputStream(this.connectedBluetoothSocket));
        this.outputStream = new BufferedOutputStream(BluetoothReflection.getOutputStream(this.connectedBluetoothSocket));
        this.fireAfterConnectEvent();
    }

    @SimpleFunction(description="Disconnect from the connected Bluetooth device.")
    public final void Disconnect() {
        if (this.connectedBluetoothSocket != null) {
            this.fireBeforeDisconnectEvent();
            try {
                BluetoothReflection.closeBluetoothSocket(this.connectedBluetoothSocket);
                Log.i((String)this.logTag, (String)"Disconnected from Bluetooth device.");
            }
            catch (IOException e) {
                Log.w((String)this.logTag, (String)("Error while disconnecting: " + e.getMessage()));
            }
            this.connectedBluetoothSocket = null;
        }
        this.inputStream = null;
        this.outputStream = null;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public final boolean IsConnected() {
        return this.connectedBluetoothSocket != null;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="Whether to invoke SSP (Simple Secure Pairing), which is supported on devices with Bluetooth v2.1 or higher. When working with embedded Bluetooth devices, this property may need to be set to False. For Android 2.0-2.2, this property setting will be ignored.")
    public boolean Secure() {
        return this.secure;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void Secure(boolean secure) {
        this.secure = secure;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean HighByteFirst() {
        return this.byteOrder == ByteOrder.BIG_ENDIAN;
    }

    @DesignerProperty(editorType="boolean", defaultValue="False")
    @SimpleProperty
    public void HighByteFirst(boolean highByteFirst) {
        this.byteOrder = highByteFirst ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN;
    }

    @DesignerProperty(editorType="string", defaultValue="UTF-8")
    @SimpleProperty
    public void CharacterEncoding(String encoding) {
        try {
            "check".getBytes(encoding);
            this.encoding = encoding;
        }
        catch (UnsupportedEncodingException e) {
            this.bluetoothError("CharacterEncoding", 519, encoding);
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String CharacterEncoding() {
        return this.encoding;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="0")
    @SimpleProperty
    public void DelimiterByte(int number) {
        String functionName = "DelimiterByte";
        int n = number;
        byte b = (byte)n;
        if ((n >>= 8) != 0 && n != -1) {
            this.bluetoothError(functionName, 511, number);
            return;
        }
        this.delimiter = b;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public int DelimiterByte() {
        return this.delimiter;
    }

    @SimpleFunction(description="Send text to the connected Bluetooth device.")
    public void SendText(String text) {
        byte[] bytes;
        try {
            bytes = text.getBytes(this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            Log.w((String)this.logTag, (String)("UnsupportedEncodingException: " + e.getMessage()));
            bytes = text.getBytes();
        }
        this.write("SendText", bytes);
    }

    @SimpleFunction(description="Send a 1-byte number to the connected Bluetooth device.")
    public void Send1ByteNumber(String number) {
        int n;
        String functionName = "Send1ByteNumber";
        try {
            n = Integer.decode(number);
        }
        catch (NumberFormatException e) {
            this.bluetoothError(functionName, 510, number);
            return;
        }
        byte b = (byte)n;
        if ((n >>= 8) != 0 && n != -1) {
            this.bluetoothError(functionName, 511, number);
            return;
        }
        this.write(functionName, b);
    }

    @SimpleFunction(description="Send a 2-byte number to the connected Bluetooth device.")
    public void Send2ByteNumber(String number) {
        int n;
        String functionName = "Send2ByteNumber";
        try {
            n = Integer.decode(number);
        }
        catch (NumberFormatException e) {
            this.bluetoothError(functionName, 510, number);
            return;
        }
        byte[] bytes = new byte[2];
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            bytes[1] = (byte)(n & 0xFF);
            bytes[0] = (byte)((n >>= 8) & 0xFF);
        } else {
            bytes[0] = (byte)(n & 0xFF);
            bytes[1] = (byte)((n >>= 8) & 0xFF);
        }
        if ((n >>= 8) != 0 && n != -1) {
            this.bluetoothError(functionName, 512, number, 2);
            return;
        }
        this.write(functionName, bytes);
    }

    @SimpleFunction(description="Send a 4-byte number to the connected Bluetooth device.")
    public void Send4ByteNumber(String number) {
        long n;
        String functionName = "Send4ByteNumber";
        try {
            n = Long.decode(number);
        }
        catch (NumberFormatException e) {
            this.bluetoothError(functionName, 510, number);
            return;
        }
        byte[] bytes = new byte[4];
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            bytes[3] = (byte)(n & 0xFFL);
            bytes[2] = (byte)((n >>= 8) & 0xFFL);
            bytes[1] = (byte)((n >>= 8) & 0xFFL);
            bytes[0] = (byte)((n >>= 8) & 0xFFL);
        } else {
            bytes[0] = (byte)(n & 0xFFL);
            bytes[1] = (byte)((n >>= 8) & 0xFFL);
            bytes[2] = (byte)((n >>= 8) & 0xFFL);
            bytes[3] = (byte)((n >>= 8) & 0xFFL);
        }
        if ((n >>= 8) != 0L && n != -1L) {
            this.bluetoothError(functionName, 512, number, 4);
            return;
        }
        this.write(functionName, bytes);
    }

    @SimpleFunction(description="Send a list of byte values to the connected Bluetooth device.")
    public void SendBytes(YailList list) {
        String functionName = "SendBytes";
        Object[] array = list.toArray();
        byte[] bytes = new byte[array.length];
        for (int i = 0; i < array.length; ++i) {
            int n;
            Object element = array[i];
            String s = element.toString();
            try {
                n = Integer.decode(s);
            }
            catch (NumberFormatException e) {
                this.bluetoothError(functionName, 513, i + 1);
                return;
            }
            bytes[i] = (byte)(n & 0xFF);
            if ((n >>= 8) == 0 || n == -1) continue;
            this.bluetoothError(functionName, 514, i + 1);
            return;
        }
        this.write(functionName, bytes);
    }

    protected void write(String functionName, byte b) {
        if (!this.IsConnected()) {
            this.bluetoothError(functionName, 515, new Object[0]);
            return;
        }
        try {
            this.outputStream.write(b);
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.bluetoothError(functionName, 516, e.getMessage());
        }
    }

    protected void write(String functionName, byte[] bytes) {
        if (!this.IsConnected()) {
            this.bluetoothError(functionName, 515, new Object[0]);
            return;
        }
        try {
            this.outputStream.write(bytes);
            this.outputStream.flush();
        }
        catch (IOException e) {
            this.bluetoothError(functionName, 516, e.getMessage());
        }
    }

    @SimpleFunction(description="Returns an estimate of the number of bytes that can be received without blocking")
    public int BytesAvailableToReceive() {
        String functionName = "BytesAvailableToReceive";
        if (!this.IsConnected()) {
            this.bluetoothError(functionName, 515, new Object[0]);
            return 0;
        }
        try {
            return this.inputStream.available();
        }
        catch (IOException e) {
            this.bluetoothError(functionName, 517, e.getMessage());
            return 0;
        }
    }

    @SimpleFunction(description="Receive text from the connected Bluetooth device. If numberOfBytes is less than 0, read until a delimiter byte value is received.")
    public String ReceiveText(int numberOfBytes) {
        byte[] bytes = this.read("ReceiveText", numberOfBytes);
        try {
            if (numberOfBytes < 0) {
                return new String(bytes, 0, bytes.length - 1, this.encoding);
            }
            return new String(bytes, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            Log.w((String)this.logTag, (String)("UnsupportedEncodingException: " + e.getMessage()));
            return new String(bytes);
        }
    }

    @SimpleFunction(description="Receive a signed 1-byte number from the connected Bluetooth device.")
    public int ReceiveSigned1ByteNumber() {
        byte[] bytes = this.read("ReceiveSigned1ByteNumber", 1);
        if (bytes.length != 1) {
            return 0;
        }
        return bytes[0];
    }

    @SimpleFunction(description="Receive an unsigned 1-byte number from the connected Bluetooth device.")
    public int ReceiveUnsigned1ByteNumber() {
        byte[] bytes = this.read("ReceiveUnsigned1ByteNumber", 1);
        if (bytes.length != 1) {
            return 0;
        }
        return bytes[0] & 0xFF;
    }

    @SimpleFunction(description="Receive a signed 2-byte number from the connected Bluetooth device.")
    public int ReceiveSigned2ByteNumber() {
        byte[] bytes = this.read("ReceiveSigned2ByteNumber", 2);
        if (bytes.length != 2) {
            return 0;
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return bytes[1] & 0xFF | bytes[0] << 8;
        }
        return bytes[0] & 0xFF | bytes[1] << 8;
    }

    @SimpleFunction(description="Receive a unsigned 2-byte number from the connected Bluetooth device.")
    public int ReceiveUnsigned2ByteNumber() {
        byte[] bytes = this.read("ReceiveUnsigned2ByteNumber", 2);
        if (bytes.length != 2) {
            return 0;
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return bytes[1] & 0xFF | (bytes[0] & 0xFF) << 8;
        }
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8;
    }

    @SimpleFunction(description="Receive a signed 4-byte number from the connected Bluetooth device.")
    public long ReceiveSigned4ByteNumber() {
        byte[] bytes = this.read("ReceiveSigned4ByteNumber", 4);
        if (bytes.length != 4) {
            return 0L;
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return bytes[3] & 0xFF | (bytes[2] & 0xFF) << 8 | (bytes[1] & 0xFF) << 16 | bytes[0] << 24;
        }
        return bytes[0] & 0xFF | (bytes[1] & 0xFF) << 8 | (bytes[2] & 0xFF) << 16 | bytes[3] << 24;
    }

    @SimpleFunction(description="Receive a unsigned 4-byte number from the connected Bluetooth device.")
    public long ReceiveUnsigned4ByteNumber() {
        byte[] bytes = this.read("ReceiveUnsigned4ByteNumber", 4);
        if (bytes.length != 4) {
            return 0L;
        }
        if (this.byteOrder == ByteOrder.BIG_ENDIAN) {
            return (long)bytes[3] & 0xFFL | ((long)bytes[2] & 0xFFL) << 8 | ((long)bytes[1] & 0xFFL) << 16 | ((long)bytes[0] & 0xFFL) << 24;
        }
        return (long)bytes[0] & 0xFFL | ((long)bytes[1] & 0xFFL) << 8 | ((long)bytes[2] & 0xFFL) << 16 | ((long)bytes[3] & 0xFFL) << 24;
    }

    @SimpleFunction(description="Receive multiple signed byte values from the connected Bluetooth device. If numberOfBytes is less than 0, read until a delimiter byte value is received.")
    public List<Integer> ReceiveSignedBytes(int numberOfBytes) {
        byte[] bytes = this.read("ReceiveSignedBytes", numberOfBytes);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < bytes.length; ++i) {
            byte n = bytes[i];
            list.add(Integer.valueOf(n));
        }
        return list;
    }

    @SimpleFunction(description="Receive multiple unsigned byte values from the connected Bluetooth device. If numberOfBytes is less than 0, read until a delimiter byte value is received.")
    public List<Integer> ReceiveUnsignedBytes(int numberOfBytes) {
        byte[] bytes = this.read("ReceiveUnsignedBytes", numberOfBytes);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int i = 0; i < bytes.length; ++i) {
            int n = bytes[i] & 0xFF;
            list.add(n);
        }
        return list;
    }

    protected final byte[] read(String functionName, int numberOfBytes) {
        if (!this.IsConnected()) {
            this.bluetoothError(functionName, 515, new Object[0]);
            return new byte[0];
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        if (numberOfBytes >= 0) {
            int totalBytesRead;
            int numBytesRead;
            byte[] bytes = new byte[numberOfBytes];
            for (totalBytesRead = 0; totalBytesRead < numberOfBytes; totalBytesRead += numBytesRead) {
                try {
                    numBytesRead = this.inputStream.read(bytes, totalBytesRead, bytes.length - totalBytesRead);
                    if (numBytesRead != -1) continue;
                    this.bluetoothError(functionName, 518, new Object[0]);
                    break;
                }
                catch (IOException e) {
                    this.bluetoothError(functionName, 517, e.getMessage());
                    break;
                }
            }
            buffer.write(bytes, 0, totalBytesRead);
        } else {
            try {
                int value;
                do {
                    if ((value = this.inputStream.read()) == -1) {
                        this.bluetoothError(functionName, 518, new Object[0]);
                        break;
                    }
                    buffer.write(value);
                } while (value != this.delimiter);
            }
            catch (IOException e) {
                this.bluetoothError(functionName, 517, e.getMessage());
            }
        }
        return buffer.toByteArray();
    }

    @Override
    public void onDestroy() {
        this.prepareToDie();
    }

    @Override
    public void onDelete() {
        this.prepareToDie();
    }

    private void prepareToDie() {
        if (this.connectedBluetoothSocket != null) {
            this.Disconnect();
        }
    }
}

