/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.BluetoothConnectionBase;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.util.BluetoothReflection;
import com.google.appinventor.components.runtime.util.SdkLevel;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=5, description="Bluetooth client component", category=ComponentCategory.CONNECTIVITY, nonVisible=true, iconName="images/bluetooth.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.BLUETOOTH, android.permission.BLUETOOTH_ADMIN")
public final class BluetoothClient
extends BluetoothConnectionBase {
    private static final String SPP_UUID = "00001101-0000-1000-8000-00805F9B34FB";
    private final List<Component> attachedComponents = new ArrayList<Component>();
    private Set<Integer> acceptableDeviceClasses;

    public BluetoothClient(ComponentContainer container) {
        super(container, "BluetoothClient");
    }

    boolean attachComponent(Component component, Set<Integer> acceptableDeviceClasses) {
        if (this.attachedComponents.isEmpty()) {
            this.acceptableDeviceClasses = acceptableDeviceClasses == null ? null : new HashSet<Integer>(acceptableDeviceClasses);
        } else if (this.acceptableDeviceClasses == null) {
            if (acceptableDeviceClasses != null) {
                return false;
            }
        } else {
            if (acceptableDeviceClasses == null) {
                return false;
            }
            if (!this.acceptableDeviceClasses.containsAll(acceptableDeviceClasses)) {
                return false;
            }
            if (!acceptableDeviceClasses.containsAll(this.acceptableDeviceClasses)) {
                return false;
            }
        }
        this.attachedComponents.add(component);
        return true;
    }

    void detachComponent(Component component) {
        this.attachedComponents.remove(component);
        if (this.attachedComponents.isEmpty()) {
            this.acceptableDeviceClasses = null;
        }
    }

    @SimpleFunction(description="Checks whether the Bluetooth device with the specified address is paired.")
    public boolean IsDevicePaired(String address) {
        String functionName = "IsDevicePaired";
        Object bluetoothAdapter = BluetoothReflection.getBluetoothAdapter();
        if (bluetoothAdapter == null) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 501, new Object[0]);
            return false;
        }
        if (!BluetoothReflection.isBluetoothEnabled(bluetoothAdapter)) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 502, new Object[0]);
            return false;
        }
        int firstSpace = address.indexOf(" ");
        if (firstSpace != -1) {
            address = address.substring(0, firstSpace);
        }
        if (!BluetoothReflection.checkBluetoothAddress(bluetoothAdapter, address)) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 503, new Object[0]);
            return false;
        }
        Object bluetoothDevice = BluetoothReflection.getRemoteDevice(bluetoothAdapter, address);
        return BluetoothReflection.isBonded(bluetoothDevice);
    }

    @SimpleProperty(description="The addresses and names of paired Bluetooth devices", category=PropertyCategory.BEHAVIOR)
    public List<String> AddressesAndNames() {
        ArrayList<String> addressesAndNames = new ArrayList<String>();
        Object bluetoothAdapter = BluetoothReflection.getBluetoothAdapter();
        if (bluetoothAdapter != null && BluetoothReflection.isBluetoothEnabled(bluetoothAdapter)) {
            for (Object bluetoothDevice : BluetoothReflection.getBondedDevices(bluetoothAdapter)) {
                if (!this.isDeviceClassAcceptable(bluetoothDevice)) continue;
                String name = BluetoothReflection.getBluetoothDeviceName(bluetoothDevice);
                String address = BluetoothReflection.getBluetoothDeviceAddress(bluetoothDevice);
                addressesAndNames.add(address + " " + name);
            }
        }
        return addressesAndNames;
    }

    private boolean isDeviceClassAcceptable(Object bluetoothDevice) {
        if (this.acceptableDeviceClasses == null) {
            return true;
        }
        Object bluetoothClass = BluetoothReflection.getBluetoothClass(bluetoothDevice);
        if (bluetoothClass == null) {
            return false;
        }
        int deviceClass = BluetoothReflection.getDeviceClass(bluetoothClass);
        return this.acceptableDeviceClasses.contains(deviceClass);
    }

    @SimpleFunction(description="Connect to the Bluetooth device with the specified address and the Serial Port Profile (SPP). Returns true if the connection was successful.")
    public boolean Connect(String address) {
        return this.connect("Connect", address, SPP_UUID);
    }

    @SimpleFunction(description="Connect to the Bluetooth device with the specified address and UUID. Returns true if the connection was successful.")
    public boolean ConnectWithUUID(String address, String uuid) {
        return this.connect("ConnectWithUUID", address, uuid);
    }

    private boolean connect(String functionName, String address, String uuidString) {
        UUID uuid;
        Object bluetoothAdapter = BluetoothReflection.getBluetoothAdapter();
        if (bluetoothAdapter == null) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 501, new Object[0]);
            return false;
        }
        if (!BluetoothReflection.isBluetoothEnabled(bluetoothAdapter)) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 502, new Object[0]);
            return false;
        }
        int firstSpace = address.indexOf(" ");
        if (firstSpace != -1) {
            address = address.substring(0, firstSpace);
        }
        if (!BluetoothReflection.checkBluetoothAddress(bluetoothAdapter, address)) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 503, new Object[0]);
            return false;
        }
        Object bluetoothDevice = BluetoothReflection.getRemoteDevice(bluetoothAdapter, address);
        if (!BluetoothReflection.isBonded(bluetoothDevice)) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 504, new Object[0]);
            return false;
        }
        if (!this.isDeviceClassAcceptable(bluetoothDevice)) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 505, new Object[0]);
            return false;
        }
        try {
            uuid = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            this.form.dispatchErrorOccurredEvent(this, functionName, 506, uuidString);
            return false;
        }
        this.Disconnect();
        try {
            this.connect(bluetoothDevice, uuid);
            return true;
        }
        catch (IOException e) {
            this.Disconnect();
            this.form.dispatchErrorOccurredEvent(this, functionName, 507, new Object[0]);
            return false;
        }
    }

    private void connect(Object bluetoothDevice, UUID uuid) throws IOException {
        Object bluetoothSocket = !this.secure && SdkLevel.getLevel() >= 10 ? BluetoothReflection.createInsecureRfcommSocketToServiceRecord(bluetoothDevice, uuid) : BluetoothReflection.createRfcommSocketToServiceRecord(bluetoothDevice, uuid);
        BluetoothReflection.connectToBluetoothSocket(bluetoothSocket);
        this.setConnection(bluetoothSocket);
        Log.i((String)this.logTag, (String)("Connected to Bluetooth device " + BluetoothReflection.getBluetoothDeviceAddress(bluetoothDevice) + " " + BluetoothReflection.getBluetoothDeviceName(bluetoothDevice) + "."));
    }
}

