/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.UsesLibraries;
import com.google.appinventor.components.annotations.UsesPermissions;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ActivityResultListener;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.util.SdkLevel;

@DesignerComponent(version=2, description="Component for using the Barcode Scanner to read a barcode", category=ComponentCategory.SENSORS, nonVisible=true, iconName="images/barcodeScanner.png")
@SimpleObject
@UsesPermissions(permissionNames="android.permission.CAMERA")
@UsesLibraries(libraries="Barcode.jar,core.jar")
public class BarcodeScanner
extends AndroidNonvisibleComponent
implements ActivityResultListener,
Component {
    private static final String SCAN_INTENT = "com.google.zxing.client.android.SCAN";
    private static final String LOCAL_SCAN = "com.google.zxing.client.android.AppInvCaptureActivity";
    private static final String SCANNER_RESULT_NAME = "SCAN_RESULT";
    private String result = "";
    private boolean useExternalScanner = true;
    private final ComponentContainer container;
    private int requestCode;

    public BarcodeScanner(ComponentContainer container) {
        super(container.$form());
        this.container = container;
    }

    @SimpleProperty(description="Text result of the previous scan.", category=PropertyCategory.BEHAVIOR)
    public String Result() {
        return this.result;
    }

    @SimpleFunction(description="Begins a barcode scan, using the camera. When the scan is complete, the AfterScan event will be raised.")
    public void DoScan() {
        Intent intent = new Intent(SCAN_INTENT);
        if (!this.useExternalScanner && SdkLevel.getLevel() >= 5) {
            String packageName = this.container.$form().getPackageName();
            intent.setComponent(new ComponentName(packageName, LOCAL_SCAN));
        }
        if (this.requestCode == 0) {
            this.requestCode = this.form.registerForActivityResult(this);
        }
        try {
            this.container.$context().startActivityForResult(intent, this.requestCode);
        }
        catch (ActivityNotFoundException e) {
            e.printStackTrace();
            this.container.$form().dispatchErrorOccurredEvent(this, "BarcodeScanner", 1501, "");
        }
    }

    public void resultReturned(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.requestCode && resultCode == -1) {
            this.result = data.hasExtra(SCANNER_RESULT_NAME) ? data.getStringExtra(SCANNER_RESULT_NAME) : "";
            this.AfterScan(this.result);
        }
    }

    @SimpleEvent
    public void AfterScan(String result) {
        EventDispatcher.dispatchEvent(this, "AfterScan", result);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="If true App Inventor will look for and use an external scanning program such as \"Bar Code Scanner.\"")
    public boolean UseExternalScanner() {
        return this.useExternalScanner;
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void UseExternalScanner(boolean useExternalScanner) {
        this.useExternalScanner = useExternalScanner;
    }
}

