/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.view.View;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.annotations.SimplePropertyCopier;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Form;
import com.google.appinventor.components.runtime.HandlesEventDispatching;
import com.google.appinventor.components.runtime.VisibleComponent;

@SimpleObject
public abstract class AndroidViewComponent
extends VisibleComponent {
    protected final ComponentContainer container;
    private int percentWidthHolder = -3;
    private int percentHeightHolder = -3;
    private int lastSetWidth = -3;
    private int lastSetHeight = -3;
    private int column = -1;
    private int row = -1;

    protected AndroidViewComponent(ComponentContainer container) {
        this.container = container;
    }

    public abstract View getView();

    @SimpleProperty(category=PropertyCategory.APPEARANCE)
    public boolean Visible() {
        return this.getView().getVisibility() == 0;
    }

    @DesignerProperty(editorType="visibility", defaultValue="True")
    @SimpleProperty(description="Specifies whether the component should be visible on the screen. Value is true if the component is showing and false if hidden.")
    public void Visible(Boolean visibility) {
        this.getView().setVisibility(visibility != false ? 0 : 8);
    }

    @SimpleProperty
    public int Width() {
        int zWidth = (int)((float)this.getView().getWidth() / this.container.$form().deviceDensity());
        return zWidth;
    }

    @SimpleProperty
    public void Width(int width) {
        this.container.setChildWidth(this, width);
        this.lastSetWidth = width;
        if (width <= -1000) {
            this.container.$form().registerPercentLength(this, width, Form.PercentStorageRecord.Dim.WIDTH);
        }
    }

    @SimpleProperty
    public void WidthPercent(int pCent) {
        if (pCent < 0 || pCent > 100) {
            this.container.$form().dispatchErrorOccurredEvent(this, "WidthPercent", 2801, pCent);
            return;
        }
        int v = -pCent + -1000;
        this.Width(v);
    }

    public void setLastWidth(int width) {
        this.percentWidthHolder = width;
    }

    public int getSetWidth() {
        if (this.percentWidthHolder == -3) {
            return this.Width();
        }
        return this.percentWidthHolder;
    }

    public void setLastHeight(int height) {
        this.percentHeightHolder = height;
    }

    public int getSetHeight() {
        if (this.percentHeightHolder == -3) {
            return this.Height();
        }
        return this.percentHeightHolder;
    }

    @SimplePropertyCopier
    public void CopyWidth(AndroidViewComponent sourceComponent) {
        this.Width(sourceComponent.lastSetWidth);
    }

    @SimpleProperty
    public int Height() {
        return (int)((float)this.getView().getHeight() / this.container.$form().deviceDensity());
    }

    @SimpleProperty
    public void Height(int height) {
        this.container.setChildHeight(this, height);
        this.lastSetHeight = height;
        if (height <= -1000) {
            this.container.$form().registerPercentLength(this, height, Form.PercentStorageRecord.Dim.HEIGHT);
        }
    }

    @SimpleProperty
    public void HeightPercent(int pCent) {
        if (pCent < 0 || pCent > 100) {
            this.container.$form().dispatchErrorOccurredEvent(this, "HeightPercent", 2801, pCent);
            return;
        }
        int v = -pCent + -1000;
        this.Height(v);
    }

    @SimplePropertyCopier
    public void CopyHeight(AndroidViewComponent sourceComponent) {
        this.Height(sourceComponent.lastSetHeight);
    }

    @SimpleProperty(userVisible=false)
    public int Column() {
        return this.column;
    }

    @SimpleProperty(userVisible=false)
    public void Column(int column) {
        this.column = column;
    }

    @SimpleProperty(userVisible=false)
    public int Row() {
        return this.row;
    }

    @SimpleProperty(userVisible=false)
    public void Row(int row) {
        this.row = row;
    }

    public HandlesEventDispatching getDispatchDelegate() {
        return this.container.$form();
    }
}

