/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.content.ActivityNotFoundException;
import android.content.ComponentName;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.util.Log;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleFunction;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.ActivityResultListener;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.Component;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.errors.YailRuntimeError;
import com.google.appinventor.components.runtime.util.AnimationUtil;
import com.google.appinventor.components.runtime.util.YailList;

@DesignerComponent(version=6, designerHelpDescription="A component that can launch an activity using the <code>StartActivity</code> method.<p>Activities that can be launched include: <ul> \n<li> starting other App Inventor for Android apps </li> \n<li> starting the camera application </li> \n<li> performing web search </li> \n<li> opening a browser to a specified web page</li> \n<li> opening the map application to a specified location</li></ul> \nYou can also launch activities that return text data.  See the documentation on using the Activity Starter for examples.</p>", description="A component that can launch an activity using the <code>StartActivity</code> method. \n<p>Activities that can be launched include:<ul> <li> Starting another App Inventor for Android app. \n To do so, first      find out the <em>class</em> of the other application by      downloading the source code and using a file explorer or unzip      utility to find a file named      \"youngandroidproject/project.properties\".  \n The first line of      the file will start with \"main=\" and be followed by the class      name; for example,      <code>main=com.gmail.Bitdiddle.Ben.HelloPurr.Screen1</code>.       (The first components indicate that it was created by      Ben.Bitdiddle@gmail.com.)  \n To make your      <code>ActivityStarter</code> launch this application, set the      following properties: <ul>\n      <li> <code>ActivityPackage</code> to the class name, dropping the           last component (for example,           <code>com.gmail.Bitdiddle.Ben.HelloPurr</code>)</li>\n      <li> <code>ActivityClass</code> to the entire class name (for           example,           <code>com.gmail.Bitdiddle.Ben.HelloPurr.Screen1</code>)</li>      </ul></li> \n<li> Starting the camera application by setting the following      properties:<ul> \n     <li> <code>Action: android.intent.action.MAIN</code> </li> \n     <li> <code>ActivityPackage: com.android.camera</code> </li> \n     <li> <code>ActivityClass: com.android.camera.Camera</code></li>\n      </ul></li>\n<li> Performing web search.  Assuming the term you want to search      for is \"vampire\" (feel free to substitute your own choice), \n     set the properties to:\n<ul><code>     <li>Action: android.intent.action.WEB_SEARCH</li>      <li>ExtraKey: query</li>      <li>ExtraValue: vampire</li>      <li>ActivityPackage: com.google.android.providers.enhancedgooglesearch</li>     <li>ActivityClass: com.google.android.providers.enhancedgooglesearch.Launcher</li>      </code></ul></li> \n<li> Opening a browser to a specified web page.  Assuming the page you      want to go to is \"www.facebook.com\" (feel free to substitute      your own choice), set the properties to:\n<ul><code>      <li>Action: android.intent.action.VIEW</li>      <li>DataUri: http://www.facebook.com</li> </code> </ul> </li> </ul></p>", category=ComponentCategory.CONNECTIVITY, nonVisible=true, iconName="images/activityStarter.png")
@SimpleObject
public class ActivityStarter
extends AndroidNonvisibleComponent
implements ActivityResultListener,
Component,
Deleteable {
    private String action;
    private String dataUri;
    private String dataType;
    private String activityPackage;
    private String activityClass;
    private String extraKey;
    private String extraValue;
    private String resultName;
    private Intent resultIntent;
    private String result;
    private int requestCode;
    private YailList extras;
    private final ComponentContainer container;

    public ActivityStarter(ComponentContainer container) {
        super(container.$form());
        this.container = container;
        this.result = "";
        this.Action("android.intent.action.MAIN");
        this.ActivityPackage("");
        this.ActivityClass("");
        this.DataUri("");
        this.DataType("");
        this.ExtraKey("");
        this.ExtraValue("");
        this.Extras(new YailList());
        this.ResultName("");
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String Action() {
        return this.action;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void Action(String action) {
        this.action = action.trim();
    }

    @SimpleProperty(description="Returns the extra key that will be passed to the activity.\nDEPRECATED: New code should use Extras property instead.", category=PropertyCategory.BEHAVIOR)
    public String ExtraKey() {
        return this.extraKey;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void ExtraKey(String extraKey) {
        this.extraKey = extraKey.trim();
    }

    @SimpleProperty(description="Returns the extra value that will be passed to the activity.\nDEPRECATED: New code should use Extras property instead.", category=PropertyCategory.BEHAVIOR)
    public String ExtraValue() {
        return this.extraValue;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void ExtraValue(String extraValue) {
        this.extraValue = extraValue.trim();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String ResultName() {
        return this.resultName;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void ResultName(String resultName) {
        this.resultName = resultName.trim();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String Result() {
        return this.result;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String DataUri() {
        return this.dataUri;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void DataUri(String dataUri) {
        this.dataUri = dataUri.trim();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String DataType() {
        return this.dataType;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void DataType(String dataType) {
        this.dataType = dataType.trim();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String ActivityPackage() {
        return this.activityPackage;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void ActivityPackage(String activityPackage) {
        this.activityPackage = activityPackage.trim();
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String ActivityClass() {
        return this.activityClass;
    }

    @DesignerProperty(editorType="string", defaultValue="")
    @SimpleProperty
    public void ActivityClass(String activityClass) {
        this.activityClass = activityClass.trim();
    }

    @SimpleEvent(description="Event raised after this ActivityStarter returns.")
    public void AfterActivity(String result) {
        EventDispatcher.dispatchEvent(this, "AfterActivity", result);
    }

    @SimpleEvent(description="Event raised if this ActivityStarter returns because the activity was canceled.")
    public void ActivityCanceled() {
        EventDispatcher.dispatchEvent(this, "ActivityCanceled", new Object[0]);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String ResultType() {
        String resultType;
        if (this.resultIntent != null && (resultType = this.resultIntent.getType()) != null) {
            return resultType;
        }
        return "";
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public String ResultUri() {
        String resultUri;
        if (this.resultIntent != null && (resultUri = this.resultIntent.getDataString()) != null) {
            return resultUri;
        }
        return "";
    }

    @SimpleProperty
    public void Extras(YailList pairs) {
        for (Object pair : pairs.toArray()) {
            boolean isPair;
            boolean isYailList = pair instanceof YailList;
            boolean bl = isYailList ? ((YailList)pair).size() == 2 : (isPair = false);
            if (isYailList && isPair) continue;
            throw new YailRuntimeError("Argument to Extras should be a list of pairs", "ActivityStarter Error");
        }
        this.extras = pairs;
    }

    @SimpleProperty
    public YailList Extras() {
        return this.extras;
    }

    @SimpleFunction(description="Returns the name of the activity that corresponds to this ActivityStarter, or an empty string if no corresponding activity can be found.")
    public String ResolveActivity() {
        Intent intent = this.buildActivityIntent();
        PackageManager pm = this.container.$context().getPackageManager();
        ResolveInfo resolveInfo = pm.resolveActivity(intent, 0);
        if (resolveInfo != null && resolveInfo.activityInfo != null) {
            return resolveInfo.activityInfo.name;
        }
        return "";
    }

    @SimpleFunction(description="Start the activity corresponding to this ActivityStarter.")
    public void StartActivity() {
        this.resultIntent = null;
        this.result = "";
        Intent intent = this.buildActivityIntent();
        if (this.requestCode == 0) {
            this.requestCode = this.form.registerForActivityResult(this);
        }
        if (intent == null) {
            this.form.dispatchErrorOccurredEvent(this, "StartActivity", 602, new Object[0]);
        } else {
            try {
                this.container.$context().startActivityForResult(intent, this.requestCode);
                String openAnim = this.container.$form().getOpenAnimType();
                AnimationUtil.ApplyOpenScreenAnimation(this.container.$context(), openAnim);
            }
            catch (ActivityNotFoundException e) {
                this.form.dispatchErrorOccurredEvent(this, "StartActivity", 601, new Object[0]);
            }
        }
    }

    private Intent buildActivityIntent() {
        Intent intent;
        Uri uri = this.dataUri.length() != 0 ? Uri.parse((String)this.dataUri) : null;
        Intent intent2 = intent = uri != null ? new Intent(this.action, uri) : new Intent(this.action);
        if (this.Action().isEmpty()) {
            return null;
        }
        if (this.dataType.length() != 0) {
            if (uri != null) {
                intent.setDataAndType(uri, this.dataType);
            } else {
                intent.setType(this.dataType);
            }
        }
        if (this.activityPackage.length() != 0 || this.activityClass.length() != 0) {
            ComponentName component = new ComponentName(this.activityPackage, this.activityClass);
            intent.setComponent(component);
        } else if (this.Action() == "android.intent.action.MAIN") {
            return null;
        }
        if (this.extraKey.length() != 0 && this.extraValue.length() != 0) {
            Log.i((String)"ActivityStarter", (String)("Adding extra, key = " + this.extraKey + " value = " + this.extraValue));
            intent.putExtra(this.extraKey, this.extraValue);
        }
        for (Object extra : this.extras.toArray()) {
            YailList castExtra = (YailList)extra;
            String key = castExtra.getString(0);
            String value = castExtra.getString(1);
            if (key.length() == 0 || value.length() == 0) continue;
            Log.i((String)"ActivityStarter", (String)("Adding extra (pairs), key = " + key + " value = " + value));
            intent.putExtra(key, value);
        }
        return intent;
    }

    public void resultReturned(int requestCode, int resultCode, Intent data) {
        if (requestCode == this.requestCode) {
            Log.i((String)"ActivityStarter", (String)("resultReturned - resultCode = " + resultCode));
            if (resultCode == -1) {
                this.resultIntent = data;
                this.result = this.resultName.length() != 0 && this.resultIntent != null && this.resultIntent.hasExtra(this.resultName) ? this.resultIntent.getStringExtra(this.resultName) : "";
                this.AfterActivity(this.result);
            } else if (resultCode == 0) {
                this.ActivityCanceled();
            }
        }
    }

    @SimpleEvent(description="The ActivityError event is no longer used. Please use the Screen.ErrorOccurred event instead.", userVisible=false)
    public void ActivityError(String message) {
    }

    public void onDelete() {
        this.form.unregisterForActivityResult(this);
    }
}

