/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.runtime;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import com.google.appinventor.components.annotations.DesignerComponent;
import com.google.appinventor.components.annotations.DesignerProperty;
import com.google.appinventor.components.annotations.PropertyCategory;
import com.google.appinventor.components.annotations.SimpleEvent;
import com.google.appinventor.components.annotations.SimpleObject;
import com.google.appinventor.components.annotations.SimpleProperty;
import com.google.appinventor.components.common.ComponentCategory;
import com.google.appinventor.components.runtime.AndroidNonvisibleComponent;
import com.google.appinventor.components.runtime.ComponentContainer;
import com.google.appinventor.components.runtime.Deleteable;
import com.google.appinventor.components.runtime.EventDispatcher;
import com.google.appinventor.components.runtime.OnResumeListener;
import com.google.appinventor.components.runtime.OnStopListener;
import com.google.appinventor.components.runtime.SensorComponent;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@DesignerComponent(version=3, description="Non-visible component that can detect shaking and measure acceleration approximately in three dimensions using SI units (m/s<sup>2</sup>).  The components are: <ul>\n<li> <strong>xAccel</strong>: 0 when the phone is at rest on a flat      surface, positive when the phone is tilted to the right (i.e.,      its left side is raised), and negative when the phone is tilted      to the left (i.e., its right size is raised).</li>\n <li> <strong>yAccel</strong>: 0 when the phone is at rest on a flat      surface, positive when its bottom is raised, and negative when      its top is raised. </li>\n <li> <strong>zAccel</strong>: Equal to -9.8 (earth's gravity in meters per      second per second when the device is at rest parallel to the ground      with the display facing up,      0 when perpindicular to the ground, and +9.8 when facing down.       The value can also be affected by accelerating it with or against      gravity. </li></ul>", category=ComponentCategory.SENSORS, nonVisible=true, iconName="images/accelerometersensor.png")
@SimpleObject
public class AccelerometerSensor
extends AndroidNonvisibleComponent
implements OnStopListener,
OnResumeListener,
SensorComponent,
SensorEventListener,
Deleteable {
    private static final double weakShakeThreshold = 5.0;
    private static final double moderateShakeThreshold = 13.0;
    private static final double strongShakeThreshold = 20.0;
    private static final int SENSOR_CACHE_SIZE = 10;
    private final Queue<Float> X_CACHE = new LinkedList<Float>();
    private final Queue<Float> Y_CACHE = new LinkedList<Float>();
    private final Queue<Float> Z_CACHE = new LinkedList<Float>();
    private float xAccel;
    private float yAccel;
    private float zAccel;
    private int accuracy;
    private int sensitivity;
    private final SensorManager sensorManager;
    private boolean enabled;
    private int minimumInterval;
    private long timeLastShook;
    private Sensor accelerometerSensor;

    public AccelerometerSensor(ComponentContainer container) {
        super(container.$form());
        this.form.registerForOnResume(this);
        this.form.registerForOnStop(this);
        this.enabled = true;
        this.sensorManager = (SensorManager)container.$context().getSystemService("sensor");
        this.accelerometerSensor = this.sensorManager.getDefaultSensor(1);
        this.startListening();
        this.MinimumInterval(400);
        this.Sensitivity(2);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR, description="The minimum interval, in milliseconds, between phone shakes")
    public int MinimumInterval() {
        return this.minimumInterval;
    }

    @DesignerProperty(editorType="non_negative_integer", defaultValue="400")
    @SimpleProperty
    public void MinimumInterval(int interval) {
        this.minimumInterval = interval;
    }

    @SimpleProperty(category=PropertyCategory.APPEARANCE, description="A number that encodes how sensitive the accelerometer is. The choices are: 1 = weak, 2 = moderate,  3 = strong.")
    public int Sensitivity() {
        return this.sensitivity;
    }

    @DesignerProperty(editorType="accelerometer_sensitivity", defaultValue="2")
    @SimpleProperty
    public void Sensitivity(int sensitivity) {
        if (sensitivity == 1 || sensitivity == 2 || sensitivity == 3) {
            this.sensitivity = sensitivity;
        } else {
            this.form.dispatchErrorOccurredEvent(this, "Sensitivity", 1901, sensitivity);
        }
    }

    @SimpleEvent
    public void AccelerationChanged(float xAccel, float yAccel, float zAccel) {
        this.xAccel = xAccel;
        this.yAccel = yAccel;
        this.zAccel = zAccel;
        this.addToSensorCache(this.X_CACHE, xAccel);
        this.addToSensorCache(this.Y_CACHE, yAccel);
        this.addToSensorCache(this.Z_CACHE, zAccel);
        long currentTime = System.currentTimeMillis();
        if ((this.isShaking(this.X_CACHE, xAccel) || this.isShaking(this.Y_CACHE, yAccel) || this.isShaking(this.Z_CACHE, zAccel)) && (this.timeLastShook == 0L || currentTime >= this.timeLastShook + (long)this.minimumInterval)) {
            this.timeLastShook = currentTime;
            this.Shaking();
        }
        EventDispatcher.dispatchEvent(this, "AccelerationChanged", Float.valueOf(xAccel), Float.valueOf(yAccel), Float.valueOf(zAccel));
    }

    @SimpleEvent
    public void Shaking() {
        EventDispatcher.dispatchEvent(this, "Shaking", new Object[0]);
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Available() {
        List sensors = this.sensorManager.getSensorList(1);
        return sensors.size() > 0;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public boolean Enabled() {
        return this.enabled;
    }

    private void startListening() {
        this.sensorManager.registerListener((SensorEventListener)this, this.accelerometerSensor, 1);
    }

    private void stopListening() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    @DesignerProperty(editorType="boolean", defaultValue="True")
    @SimpleProperty
    public void Enabled(boolean enabled) {
        if (this.enabled == enabled) {
            return;
        }
        this.enabled = enabled;
        if (enabled) {
            this.startListening();
        } else {
            this.stopListening();
        }
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public float XAccel() {
        return this.xAccel;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public float YAccel() {
        return this.yAccel;
    }

    @SimpleProperty(category=PropertyCategory.BEHAVIOR)
    public float ZAccel() {
        return this.zAccel;
    }

    private void addToSensorCache(Queue<Float> cache, float value) {
        if (cache.size() >= 10) {
            cache.remove();
        }
        cache.add(Float.valueOf(value));
    }

    private boolean isShaking(Queue<Float> cache, float currentValue) {
        float average = 0.0f;
        Iterator iterator = cache.iterator();
        while (iterator.hasNext()) {
            float value = ((Float)iterator.next()).floatValue();
            average += value;
        }
        average /= (float)cache.size();
        if (this.Sensitivity() == 1) {
            return (double)Math.abs(average - currentValue) > 20.0;
        }
        if (this.Sensitivity() == 2) {
            return (double)Math.abs(average - currentValue) > 13.0 && (double)Math.abs(average - currentValue) < 20.0;
        }
        return (double)Math.abs(average - currentValue) > 5.0 && (double)Math.abs(average - currentValue) < 13.0;
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        if (this.enabled) {
            float[] values = sensorEvent.values;
            this.xAccel = values[0];
            this.yAccel = values[1];
            this.zAccel = values[2];
            this.accuracy = sensorEvent.accuracy;
            this.AccelerationChanged(this.xAccel, this.yAccel, this.zAccel);
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    @Override
    public void onResume() {
        if (this.enabled) {
            this.startListening();
        }
    }

    @Override
    public void onStop() {
        if (this.enabled) {
            this.stopListening();
        }
    }

    @Override
    public void onDelete() {
        if (this.enabled) {
            this.stopListening();
        }
    }
}

