/*
 * Decompiled with CFR 0.152.
 */
package com.google.appinventor.components.common;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum ComponentCategory {
    USERINTERFACE("User Interface"),
    LAYOUT("Layout"),
    MEDIA("Media"),
    ANIMATION("Drawing and Animation"),
    SENSORS("Sensors"),
    SOCIAL("Social"),
    STORAGE("Storage"),
    CONNECTIVITY("Connectivity"),
    LEGOMINDSTORMS("LEGO\u00ae MINDSTORMS\u00ae"),
    EXPERIMENTAL("Experimental"),
    EXTENSION("Extension"),
    INTERNAL("For internal use only"),
    UNINITIALIZED("Uninitialized");

    private static final Map<String, String> DOC_MAP;
    private String name;

    private ComponentCategory(String categoryName) {
        this.name = categoryName;
    }

    public String getName() {
        return this.name;
    }

    public String getDocName() {
        return DOC_MAP.get(this.name);
    }

    static {
        DOC_MAP = new HashMap<String, String>();
        DOC_MAP.put("User Interface", "userinterface");
        DOC_MAP.put("Layout", "layout");
        DOC_MAP.put("Media", "media");
        DOC_MAP.put("Drawing and Animation", "animation");
        DOC_MAP.put("Sensors", "sensors");
        DOC_MAP.put("Social", "social");
        DOC_MAP.put("Storage", "storage");
        DOC_MAP.put("Connectivity", "connectivity");
        DOC_MAP.put("LEGO\u00ae MINDSTORMS\u00ae", "legomindstorms");
        DOC_MAP.put("Experimental", "experimental");
        DOC_MAP.put("Extension", "extension");
    }
}

